/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.http.initializer;

import com.webull.openapi.core.common.Region;
import com.webull.openapi.core.http.HttpApiClient;
import com.webull.openapi.core.http.initializer.token.TokenManager;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.Objects;

public class ClientInitializer {
    private static final Logger logger = LoggerFactory.getLogger(ClientInitializer.class);

    public static void init(HttpApiClient apiClient) {
        ClientInitializer.initToken(apiClient);
    }

    private static void initToken(HttpApiClient apiClient) {
        if (!ClientInitializer.checkRegionTokenEnable(apiClient)) {
            return;
        }
        TokenManager tokenManager = new TokenManager();
        tokenManager.initToken(apiClient);
    }

    private static boolean checkRegionTokenEnable(HttpApiClient apiClient) {
        if (Objects.isNull(apiClient)) {
            logger.warn("CheckRegionTokenEnable apiClient is null return false");
            return false;
        }
        if (Objects.isNull(apiClient.getConfig())) {
            logger.warn("CheckRegionTokenEnable apiConfig is null return false");
            return false;
        }
        if (StringUtils.isBlank(apiClient.getConfig().getRegionId())) {
            logger.warn("CheckRegionTokenEnable regionId is blank return false");
            return false;
        }
        ArrayList<String> enableRegionIds = new ArrayList<String>();
        enableRegionIds.add(Region.hk.name());
        boolean result = enableRegionIds.contains(apiClient.getConfig().getRegionId());
        logger.info("CheckRegionTokenEnable result is {}, enable regionIds is {}.", result, enableRegionIds);
        return result;
    }
}

