/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.data.internal.mqtt.lifecycle.binder;

import com.webull.openapi.data.internal.mqtt.lifecycle.binder.MqttClientHandlerBinder;
import com.webull.openapi.data.internal.mqtt.lifecycle.binder.MqttInboundHandlerBinder;
import com.webull.openapi.data.internal.mqtt.lifecycle.binder.MqttSessionHandlerBinder;
import com.webull.openapi.data.quotes.subsribe.lifecycle.QuotesSubsHandler;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public class MqttClientHandlerBinderRegistry {
    private static final MqttClientHandlerBinderRegistry instance = new MqttClientHandlerBinderRegistry();
    private final Set<MqttClientHandlerBinder> registry = new LinkedHashSet<MqttClientHandlerBinder>();

    private MqttClientHandlerBinderRegistry() {
        this.registryDefault();
    }

    public static MqttClientHandlerBinderRegistry getInstance() {
        return instance;
    }

    public void register(MqttClientHandlerBinder binder) {
        this.registry.add(binder);
    }

    public Optional<MqttClientHandlerBinder> get(QuotesSubsHandler handler) {
        return this.registry.stream().filter(binder -> binder.order(handler) >= 0).max(Comparator.comparing(binder -> binder.order(handler)));
    }

    public void unregister(MqttClientHandlerBinder binder) {
        this.registry.remove(binder);
    }

    private void registryDefault() {
        this.register(MqttSessionHandlerBinder.getInstance());
        this.register(MqttInboundHandlerBinder.getInstance());
    }
}

