/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.trade.grpc.retry;

import com.webull.openapi.core.retry.RetryContext;
import com.webull.openapi.core.retry.condition.RetryCondition;
import com.webull.openapi.trade.grpc.lifecycle.GrpcFailedContext;
import io.grpc.Status;

public class GrpcRetryCondition
implements RetryCondition {
    private GrpcRetryCondition() {
    }

    public static GrpcRetryCondition getInstance() {
        return InstanceHolder.instance;
    }

    @Override
    public boolean shouldRetry(RetryContext context) {
        if (!(context instanceof GrpcFailedContext)) {
            throw new IllegalArgumentException("Retry context[" + context.getClass().getName() + "] is inappropriate to grpc retry condition!");
        }
        GrpcFailedContext grpcFailedContext = (GrpcFailedContext)((Object)context);
        if (grpcFailedContext.userCancelled()) {
            return false;
        }
        int statusCode = grpcFailedContext.getStatusCode();
        return Status.UNKNOWN.getCode().value() == statusCode || Status.INTERNAL.getCode().value() == statusCode || Status.UNAVAILABLE.getCode().value() == statusCode;
    }

    private static class InstanceHolder {
        private static final GrpcRetryCondition instance = new GrpcRetryCondition();

        private InstanceHolder() {
        }
    }
}

