/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.endpoint;

import com.webull.openapi.core.common.ApiModule;
import com.webull.openapi.core.endpoint.EndpointResolver;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ChainedEndpointResolver
implements EndpointResolver {
    private final List<EndpointResolver> endpointResolvers;

    public ChainedEndpointResolver(List<EndpointResolver> endpointResolvers) {
        this.endpointResolvers = endpointResolvers.stream().sorted(Comparator.comparing(EndpointResolver::order)).collect(Collectors.toList());
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public Optional<String> resolve(String region, ApiModule apiModule) {
        for (EndpointResolver resolver : this.endpointResolvers) {
            Optional<String> endpointOpt = resolver.resolve(region, apiModule);
            if (!endpointOpt.isPresent()) continue;
            return endpointOpt;
        }
        return Optional.empty();
    }

    @Override
    public void addEndpoint(String region, ApiModule apiModule, String endpoint) {
        this.endpointResolvers.forEach(resolver -> resolver.addEndpoint(region, apiModule, endpoint));
    }
}

