/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.http.okhttp;

import com.webull.openapi.core.execption.ClientException;
import com.webull.openapi.core.http.RuntimeOptions;
import com.webull.openapi.core.http.common.ProxyType;
import com.webull.openapi.core.http.okhttp.OkHttpClientBuilder;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class OkHttpClientPool {
    protected static final ConcurrentHashMap<String, OkHttpClient> clients = new ConcurrentHashMap();

    private OkHttpClientPool() {
    }

    public static OkHttpClient get(URL url, RuntimeOptions options) throws MalformedURLException {
        if (options.getProxyType().isPresent()) {
            url = new URL(options.getProxyAddress());
        }
        String key = OkHttpClientPool.getClientKey(url);
        return clients.computeIfAbsent(key, ignore -> OkHttpClientPool.createClient(options));
    }

    public static OkHttpClient createClient(RuntimeOptions options) {
        Optional<Proxy.Type> proxyType = options.getProxyType().map(type -> {
            if (ProxyType.HTTP == type || ProxyType.HTTPS == type) {
                return Proxy.Type.HTTP;
            }
            if (ProxyType.SOCKS5 == type) {
                return Proxy.Type.SOCKS;
            }
            throw new ClientException("InvalidParameter", "Unrecognized proxy type");
        });
        OkHttpClientBuilder builder = OkHttpClientBuilder.builder().connectTimeout(options.getConnectTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).readTimeout(options.getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).connectionPool(options.getMaxIdleConn()).certificate(options.getIgnoreSSL());
        if (proxyType.isPresent()) {
            String proxyAddress = options.getProxyAddress();
            builder = builder.proxy(proxyType.get(), proxyAddress).proxyAuthenticator(proxyType.get(), proxyAddress);
        }
        return builder.build();
    }

    private static String getClientKey(URL url) {
        return String.format("%s:%d", url.getHost(), url.getPort());
    }
}

