/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.http.okhttp;

import com.webull.openapi.core.http.HttpRequest;
import com.webull.openapi.core.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class OkHttpRequestBody
extends RequestBody {
    private static final String DEFAULT_CONTENT_TYPE = "application/json; charset=UTF-8;";
    private final InputStream inputStream;
    private final String contentType;

    public OkHttpRequestBody(HttpRequest request) {
        this.inputStream = new ByteArrayInputStream(request.getBodyString().getBytes(StandardCharsets.UTF_8));
        this.contentType = request.getHeaders().get("Content-Type");
    }

    public MediaType contentType() {
        if (StringUtils.isEmpty(this.contentType)) {
            if (null == this.inputStream) {
                return null;
            }
            MediaType type = MediaType.parse((String)DEFAULT_CONTENT_TYPE);
            return type;
        }
        return MediaType.parse((String)this.contentType);
    }

    public long contentLength() throws IOException {
        if (null != this.inputStream && this.inputStream.available() > 0) {
            return this.inputStream.available();
        }
        return super.contentLength();
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        int bytesRead;
        if (null == this.inputStream) {
            return;
        }
        byte[] buffer = new byte[4096];
        while ((bytesRead = this.inputStream.read(buffer)) != -1) {
            bufferedSink.write(buffer, 0, bytesRead);
        }
    }
}

