/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.logger;

import com.webull.openapi.core.logger.JdkLoggerFactory;
import com.webull.openapi.core.logger.Log4J2LoggerFactory;
import com.webull.openapi.core.logger.Log4JLoggerFactory;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.Slf4JLoggerFactory;
import java.util.Objects;

public abstract class LoggerFactory {
    private static volatile LoggerFactory defaultFactory;

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        return LoggerFactory.getDefaultFactory().newLogger(name);
    }

    protected abstract Logger newLogger(String var1);

    public static LoggerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = LoggerFactory.newDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefault(LoggerFactory defaultFactory) {
        LoggerFactory.defaultFactory = Objects.requireNonNull(defaultFactory, "defaultFactory");
    }

    private static LoggerFactory newDefaultFactory() {
        LoggerFactory factory2;
        try {
            factory2 = Slf4JLoggerFactory.getInstance();
            if (factory2 != null) {
                return factory2.tryGetLogger();
            }
        }
        catch (Exception | LinkageError factory2) {
            // empty catch block
        }
        try {
            factory2 = Log4J2LoggerFactory.getInstance();
            if (factory2 != null) {
                return factory2.tryGetLogger();
            }
        }
        catch (Exception | LinkageError factory3) {
            // empty catch block
        }
        try {
            factory2 = Log4JLoggerFactory.getInstance();
            if (factory2 != null) {
                return factory2.tryGetLogger();
            }
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
        return JdkLoggerFactory.getFactoryInstance().tryGetLogger();
    }

    private LoggerFactory tryGetLogger() {
        Logger logger = this.newLogger(LoggerFactory.class.getName());
        logger.info("Use {} as default logger factory.", (Object)this.getClass().getName());
        return this;
    }
}

