/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.utils;

import java.nio.ByteBuffer;

public final class ByteUtils {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ByteUtils() {
    }

    public static String bytesToHex(byte[] bytes) {
        char[] resultCharArray = new char[bytes.length * 2];
        int index = 0;
        for (byte b : bytes) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray);
    }

    public static byte[] getBytes(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return new byte[0];
        }
        byte[] binary = new byte[byteBuffer.remaining()];
        byteBuffer.duplicate().get(binary);
        return binary;
    }
}

