/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.utils;

public class DesensitizeUtils {
    public static String desensitize(String content, int keepLength, int maskLength) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        int totalLength = content.length();
        if (totalLength <= keepLength * 2) {
            return content;
        }
        String frontPart = content.substring(0, Math.min(keepLength, totalLength));
        String rearPart = "";
        if (keepLength > 0 && totalLength >= keepLength) {
            rearPart = content.substring(totalLength - keepLength);
        }
        StringBuilder maskBuilder = new StringBuilder();
        for (int i = 0; i < maskLength; ++i) {
            maskBuilder.append('*');
        }
        return frontPart + maskBuilder + rearPart;
    }

    public static String desensitizeToken(String token) {
        return DesensitizeUtils.desensitize(token, 6, 6);
    }
}

