/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.data.internal.mqtt.lifecycle;

import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.data.quotes.subsribe.lifecycle.QuotesSubsConnectedContext;
import com.webull.openapi.data.quotes.subsribe.lifecycle.QuotesSubsFailedContext;
import com.webull.openapi.data.quotes.subsribe.lifecycle.QuotesSubsInboundHandler;
import com.webull.openapi.data.quotes.subsribe.lifecycle.QuotesSubsSessionHandler;

public final class QuotesSubsLoggingHandler
implements QuotesSubsSessionHandler,
QuotesSubsInboundHandler {
    private static final Logger logger = LoggerFactory.getLogger(QuotesSubsLoggingHandler.class);

    @Override
    public void onConnected(QuotesSubsConnectedContext context) {
        logger.debug("Quotes subscribe client connected, app key={}.", (Object)context.getAuthProvider().getAppKey());
    }

    @Override
    public void onDisconnected(QuotesSubsFailedContext context) {
        if (context.userDisconnect()) {
            logger.debug("Quotes subscribe client disconnected by user.");
        } else {
            Integer ack = context.getConnAck().orElse(null);
            logger.error("Quotes subscribe client disconnected by error, ack={}, attempts={}.", ack, context.getRetriesAttempted(), context.getCause());
        }
    }

    @Override
    public Object onMessage(Object message) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received quotes subscribe message={}", message);
        }
        return message;
    }
}

