/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.trade;

import com.google.gson.reflect.TypeToken;
import com.webull.openapi.core.common.Region;
import com.webull.openapi.core.common.dict.InstrumentSuperType;
import com.webull.openapi.core.context.RequestContextHolder;
import com.webull.openapi.core.execption.ClientException;
import com.webull.openapi.core.http.HttpApiClient;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.http.HttpRequest;
import com.webull.openapi.core.http.common.HttpMethod;
import com.webull.openapi.core.http.initializer.ClientInitializer;
import com.webull.openapi.core.utils.Assert;
import com.webull.openapi.core.utils.CollectionUtils;
import com.webull.openapi.core.utils.StringUtils;
import com.webull.openapi.trade.http.ITradeClient;
import com.webull.openapi.trade.request.StockOrder;
import com.webull.openapi.trade.request.v2.OptionOrder;
import com.webull.openapi.trade.request.v2.OptionOrderItemLeg;
import com.webull.openapi.trade.response.Account;
import com.webull.openapi.trade.response.AccountBalance;
import com.webull.openapi.trade.response.AccountDetail;
import com.webull.openapi.trade.response.AccountPositions;
import com.webull.openapi.trade.response.BalanceBase;
import com.webull.openapi.trade.response.ComboOrder;
import com.webull.openapi.trade.response.ComboOrderResponse;
import com.webull.openapi.trade.response.InstrumentInfo;
import com.webull.openapi.trade.response.JPAccountBalance;
import com.webull.openapi.trade.response.Order;
import com.webull.openapi.trade.response.OrderResponse;
import com.webull.openapi.trade.response.Orders;
import com.webull.openapi.trade.response.SimpleOrder;
import com.webull.openapi.trade.response.SimpleOrderResponse;
import com.webull.openapi.trade.response.TradableInstruments;
import com.webull.openapi.trade.response.TradeCalendar;
import com.webull.openapi.trade.response.v2.PreviewOrderResponse;
import com.webull.openapi.trade.response.v2.TradeOrderResponse;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TradeClient
implements ITradeClient {
    private static final String ACCOUNT_ID_ARG = "accountId";
    private static final String STOCK_ORDER_ARG = "stockOrder";
    private static final String TRADE_ORDER_ARG = "tradeOrder";
    private static final String OPTION_ORDER_ARG = "optionOrder";
    private static final String NEW_ORDERS_ARG = "newOrders";
    private static final String MODIFY_ORDERS_ARG = "modifyOrders";
    private static final String CLIENT_ORDER_ID_ARG = "clientOrderId";
    private static final String INSTRUMENT_ID_ARG = "instrumentId";
    private static final String MARKET_ARG = "market";
    private static final String START_ARG = "start";
    private static final String END_ARG = "end";
    private static final String SYMBOL_ARG = "symbol";
    private static final String INSTRUMENT_SUPER_TYPE_ARG = "instrumentSuperType";
    private static final String INSTRUMENT_TYPE_ARG = "instrumentType";
    private static final String STRIKE_PRICE_ARG = "strikePrice";
    private static final String INIT_EXP_DATE_ARG = "initExpDate";
    private static final String ACCOUNT_ID_PARAM = "account_id";
    private static final String PAGE_SIZE_PARAM = "page_size";
    private static final String SUBSCRIPTION_ID_PARAM = "subscription_id";
    private static final String TOTAL_ASSET_CURRENCY_PARAM = "total_asset_currency";
    private static final String LAST_INSTRUMENT_ID_PARAM = "last_instrument_id";
    private static final String STOCK_ORDER_PARAM = "stock_order";
    private static final String CLIENT_ORDER_ID_PARAM = "client_order_id";
    private static final String LAST_CLIENT_ORDER_ID_PARAM = "last_client_order_id";
    private static final String INSTRUMENT_ID_PARAM = "instrument_id";
    private static final String LAST_SECURITY_ID = "last_security_id";
    private static final String MARKET_PARAM = "market";
    private static final String START_PARAM = "start";
    private static final String END_PARAM = "end";
    private static final String SYMBOL_PARAM = "symbol";
    private static final String INSTRUMENT_SUPER_TYPE_PARAM = "instrument_super_type";
    private static final String INSTRUMENT_TYPE_PARAM = "instrument_type";
    private static final String STRIKE_PRICE_PARAM = "strike_price";
    private static final String INIT_EXP_DATE_PARAM = "init_exp_date";
    private static final String START_TIME_PARAM = "start_date";
    private final Region region;
    private final HttpApiClient apiClient;

    public TradeClient(HttpApiConfig config) {
        this(new HttpApiClient(config));
    }

    public TradeClient(HttpApiClient apiClient) {
        this.region = Region.of(apiClient.getConfig().getRegionId()).orElseThrow(() -> new ClientException("InvalidParameter", "Must set region id which defined in " + Region.class.getName() + " when using this service."));
        this.apiClient = apiClient;
        ClientInitializer.init(apiClient);
    }

    @Override
    public List<Account> getAccountList(String subscriptionId) {
        HttpRequest request = new HttpRequest("/app/subscriptions/list", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty(subscriptionId)) {
            params.put(SUBSCRIPTION_ID_PARAM, subscriptionId);
        }
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<Account>>(){}.getType()).doAction();
    }

    @Override
    public AccountDetail getAccountDetail(String accountId) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        HttpRequest request = new HttpRequest("/account/profile", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        request.setQuery(params);
        return (AccountDetail)this.apiClient.request(request).responseType((Type)((Object)AccountDetail.class)).doAction();
    }

    @Override
    @Deprecated
    public <T extends BalanceBase> T getAccountBalance(String accountId, String totalAssetCurrency) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        HttpRequest request = new HttpRequest("/account/balance", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        if (StringUtils.isNotEmpty(totalAssetCurrency)) {
            params.put(TOTAL_ASSET_CURRENCY_PARAM, totalAssetCurrency);
        }
        request.setQuery(params);
        Class responseType = this.region == Region.jp ? JPAccountBalance.class : AccountBalance.class;
        return (T)((BalanceBase)this.apiClient.request(request).responseType((Type)((Object)responseType)).doAction());
    }

    @Override
    public AccountPositions getAccountPositions(String accountId, Integer pageSize, String lastId) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        HttpRequest request = new HttpRequest("/account/positions", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(PAGE_SIZE_PARAM, pageSize == null ? 10 : pageSize);
        if (StringUtils.isNotEmpty(lastId)) {
            params.put(LAST_INSTRUMENT_ID_PARAM, lastId);
        }
        request.setQuery(params);
        return (AccountPositions)this.apiClient.request(request).responseType((Type)((Object)AccountPositions.class)).doAction();
    }

    @Override
    public OrderResponse placeOrder(String accountId, StockOrder stockOrder) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        Assert.notNull(STOCK_ORDER_ARG, (Object)stockOrder);
        HttpRequest request = new HttpRequest("/trade/order/place", "v2", HttpMethod.POST);
        this.addCustomHeaderFromContext(request);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(STOCK_ORDER_PARAM, stockOrder);
        request.setBody(params);
        return (OrderResponse)this.apiClient.request(request).responseType(this.getTradeOrderResponseType()).doAction();
    }

    @Override
    public OrderResponse replaceOrder(String accountId, StockOrder stockOrder) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        Assert.notNull(STOCK_ORDER_ARG, (Object)stockOrder);
        HttpRequest request = new HttpRequest("/trade/order/replace", "v2", HttpMethod.POST);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(STOCK_ORDER_PARAM, stockOrder);
        request.setBody(params);
        return (OrderResponse)this.apiClient.request(request).responseType(this.getTradeOrderResponseType()).doAction();
    }

    @Override
    public OrderResponse cancelOrder(String accountId, String clientOrderId) {
        Assert.notBlank(Arrays.asList(ACCOUNT_ID_ARG, CLIENT_ORDER_ID_ARG), accountId, clientOrderId);
        HttpRequest request = new HttpRequest("/trade/order/cancel", "v2", HttpMethod.POST);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(CLIENT_ORDER_ID_PARAM, clientOrderId);
        request.setBody(params);
        return (OrderResponse)this.apiClient.request(request).responseType(this.getTradeOrderResponseType()).doAction();
    }

    private Type getTradeOrderResponseType() {
        return this.region == Region.us ? new TypeToken<SimpleOrderResponse>(){}.getType() : new TypeToken<ComboOrderResponse>(){}.getType();
    }

    @Override
    public <T extends Order> Orders<T> getDayOrders(String accountId, Integer pageSize, String lastClientOrderId) {
        return this.getOrders("/trade/orders/list-today", accountId, pageSize, lastClientOrderId);
    }

    @Override
    public <T extends Order> Orders<T> getOpenedOrders(String accountId, Integer pageSize, String lastClientOrderId) {
        return this.getOrders("/trade/orders/list-open", accountId, pageSize, lastClientOrderId);
    }

    private <T extends Order> Orders<T> getOrders(String uri, String accountId, Integer pageSize, String lastClientOrderId) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        HttpRequest request = new HttpRequest(uri, "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(PAGE_SIZE_PARAM, pageSize == null ? 10 : pageSize);
        if (StringUtils.isNotEmpty(lastClientOrderId)) {
            params.put(LAST_CLIENT_ORDER_ID_PARAM, lastClientOrderId);
        }
        request.setQuery(params);
        Type responseType = this.region == Region.us ? new TypeToken<Orders<ComboOrder>>(){}.getType() : new TypeToken<Orders<SimpleOrder>>(){}.getType();
        return (Orders)this.apiClient.request(request).responseType(responseType).doAction();
    }

    @Override
    public <T extends Order> T getOrderDetails(String accountId, String clientOrderId) {
        Assert.notBlank(Arrays.asList(ACCOUNT_ID_ARG, CLIENT_ORDER_ID_ARG), accountId, clientOrderId);
        HttpRequest request = new HttpRequest("/trade/order/detail", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ACCOUNT_ID_PARAM, accountId);
        params.put(CLIENT_ORDER_ID_PARAM, clientOrderId);
        request.setQuery(params);
        Class responseType = this.region == Region.us ? ComboOrder.class : SimpleOrder.class;
        return (T)((Order)this.apiClient.request(request).responseType((Type)((Object)responseType)).doAction());
    }

    @Override
    public InstrumentInfo getTradeInstrument(String instrumentId) {
        Assert.notBlank(INSTRUMENT_ID_ARG, instrumentId);
        HttpRequest request = new HttpRequest("/trade/instrument", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(INSTRUMENT_ID_PARAM, instrumentId);
        request.setQuery(params);
        return (InstrumentInfo)this.apiClient.request(request).responseType((Type)((Object)InstrumentInfo.class)).doAction();
    }

    @Override
    public TradableInstruments getTradeableInstruments(String lastSecurityId, Integer pageSize) {
        HttpRequest request = new HttpRequest("/trade/instrument/tradable/list", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty(lastSecurityId)) {
            params.put(LAST_SECURITY_ID, lastSecurityId);
        }
        params.put(PAGE_SIZE_PARAM, pageSize == null ? 10 : pageSize);
        request.setQuery(params);
        return (TradableInstruments)this.apiClient.request(request).responseType((Type)((Object)TradableInstruments.class)).doAction();
    }

    @Override
    public List<TradeCalendar> getTradeCalendar(String market, String start, String end) {
        Assert.notBlank(Arrays.asList("market", "start", "end"), market, start, end);
        HttpRequest request = new HttpRequest("/trade/calendar", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("market", market);
        params.put("start", start);
        params.put("end", end);
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<TradeCalendar>>(){}.getType()).doAction();
    }

    @Override
    public InstrumentInfo getSecurityInfo(String symbol, String market, String instrumentSuperType, String instrumentType, String strikePrice, String initExpDate) {
        Assert.notBlank(Arrays.asList("symbol", "market", INSTRUMENT_SUPER_TYPE_ARG), symbol, market, instrumentSuperType);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (instrumentSuperType.equals(InstrumentSuperType.OPTION.name())) {
            Assert.notBlank(Arrays.asList(INSTRUMENT_TYPE_ARG, STRIKE_PRICE_ARG, INIT_EXP_DATE_ARG), instrumentType, strikePrice, initExpDate);
            params.put(INSTRUMENT_TYPE_PARAM, instrumentType);
            params.put(STRIKE_PRICE_PARAM, strikePrice);
            params.put(INIT_EXP_DATE_PARAM, initExpDate);
        }
        HttpRequest request = new HttpRequest("/trade/security", "v2", HttpMethod.GET);
        params.put("symbol", symbol);
        params.put("market", market);
        params.put(INSTRUMENT_SUPER_TYPE_PARAM, instrumentSuperType);
        request.setQuery(params);
        return (InstrumentInfo)this.apiClient.request(request).responseType((Type)((Object)InstrumentInfo.class)).doAction();
    }

    private void addCustomHeadersFromOrder(HttpRequest request, OptionOrder optionOrder) {
        if (CollectionUtils.isEmpty(optionOrder.getNewOrders()) || Objects.isNull(optionOrder.getNewOrders().get(0)) || CollectionUtils.isEmpty(optionOrder.getNewOrders().get(0).getOrders())) {
            return;
        }
        OptionOrderItemLeg item = optionOrder.getNewOrders().get(0).getOrders().stream().filter(v -> Objects.nonNull(v) && Objects.equals(InstrumentSuperType.OPTION.name(), v.getInstrumentType())).findFirst().orElse(null);
        if (Objects.isNull(item)) {
            return;
        }
        List<String> categoryList = Arrays.asList(item.getMarket(), item.getInstrumentType());
        String category = StringUtils.join(categoryList, "_");
        if (StringUtils.isNotBlank(category)) {
            request.getHeaders().put("category", category);
        }
    }

    @Override
    public PreviewOrderResponse previewOption(String accountId, OptionOrder optionOrder) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        Assert.notNull(OPTION_ORDER_ARG, (Object)optionOrder);
        Assert.notEmpty(NEW_ORDERS_ARG, optionOrder.getNewOrders());
        HttpRequest request = new HttpRequest("/openapi/account/orders/option/preview", "v2", HttpMethod.POST);
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(ACCOUNT_ID_PARAM, accountId);
        request.setQuery(queryMap);
        request.setBody(optionOrder);
        return (PreviewOrderResponse)this.apiClient.request(request).responseType((Type)((Object)PreviewOrderResponse.class)).doAction();
    }

    @Override
    public TradeOrderResponse placeOption(String accountId, OptionOrder optionOrder) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        Assert.notNull(OPTION_ORDER_ARG, (Object)optionOrder);
        Assert.notEmpty(NEW_ORDERS_ARG, optionOrder.getNewOrders());
        HttpRequest request = new HttpRequest("/openapi/account/orders/option/place", "v2", HttpMethod.POST);
        this.addCustomHeadersFromOrder(request, optionOrder);
        this.addCustomHeaderFromContext(request);
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(ACCOUNT_ID_PARAM, accountId);
        request.setQuery(queryMap);
        request.setBody(optionOrder);
        return (TradeOrderResponse)this.apiClient.request(request).responseType((Type)((Object)TradeOrderResponse.class)).doAction();
    }

    @Override
    public TradeOrderResponse replaceOption(String accountId, OptionOrder optionOrder) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        Assert.notNull(OPTION_ORDER_ARG, (Object)optionOrder);
        Assert.notEmpty(MODIFY_ORDERS_ARG, optionOrder.getModifyOrders());
        HttpRequest request = new HttpRequest("/openapi/account/orders/option/replace", "v2", HttpMethod.POST);
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(ACCOUNT_ID_PARAM, accountId);
        request.setQuery(queryMap);
        request.setBody(optionOrder);
        return (TradeOrderResponse)this.apiClient.request(request).responseType((Type)((Object)TradeOrderResponse.class)).doAction();
    }

    @Override
    public TradeOrderResponse cancelOption(String accountId, OptionOrder optionOrder) {
        Assert.notBlank(ACCOUNT_ID_ARG, accountId);
        Assert.notNull(OPTION_ORDER_ARG, (Object)optionOrder);
        Assert.notBlank(CLIENT_ORDER_ID_ARG, optionOrder.getClientOrderId());
        HttpRequest request = new HttpRequest("/openapi/account/orders/option/cancel", "v2", HttpMethod.POST);
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(ACCOUNT_ID_PARAM, accountId);
        params.put(CLIENT_ORDER_ID_PARAM, optionOrder.getClientOrderId());
        request.setQuery(queryMap);
        request.setBody(params);
        return (TradeOrderResponse)this.apiClient.request(request).responseType((Type)((Object)TradeOrderResponse.class)).doAction();
    }

    @Override
    public void addCustomHeaders(Map<String, String> headersMap) {
        if (Objects.isNull(headersMap) || headersMap.isEmpty()) {
            return;
        }
        RequestContextHolder.get().putAll(headersMap);
    }

    @Override
    public void removeCustomHeaders() {
        RequestContextHolder.clear();
    }

    private void addCustomHeaderFromContext(HttpRequest request) {
        try {
            Map<String, String> headersMap = RequestContextHolder.get();
            if (Objects.isNull(headersMap) || headersMap.isEmpty()) {
                return;
            }
            request.getHeaders().putAll(headersMap);
        }
        finally {
            RequestContextHolder.clear();
        }
    }
}

