/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.data.internal.mqtt.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import com.webull.openapi.data.internal.mqtt.codec.Quotes;
import com.webull.openapi.data.internal.mqtt.codec.QuotesPublishDecoder;
import com.webull.openapi.data.quotes.domain.AskBid;
import com.webull.openapi.data.quotes.domain.Broker;
import com.webull.openapi.data.quotes.domain.Order;
import com.webull.openapi.data.quotes.domain.Quote;
import com.webull.openapi.data.quotes.subsribe.exception.DecoderException;
import com.webull.openapi.data.quotes.subsribe.message.QuotesPublish;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;

public class QuoteDecoder
implements QuotesPublishDecoder<Quote> {
    @Override
    public QuotesPublish<Quote> decode(ByteBuffer in) {
        try {
            Quotes.Quote from = Quotes.Quote.parseFrom(in);
            Quote quote = this.assembleQuote(from);
            return new QuotesPublish<Quote>(from.getBasic().getTimestamp(), quote);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecoderException("Decode quote data error", e);
        }
    }

    private Quote assembleQuote(Quotes.Quote from) {
        Quote result = new Quote();
        result.setSymbol(from.getBasic().getSymbol());
        result.setInstrumentId(from.getBasic().getInstrumentId());
        result.setTradingSession(from.getBasic().getTradingSession());
        List<AskBid> asks = from.getAsksList().stream().map(this::assembleAskBid).collect(Collectors.toList());
        result.setAsks(asks);
        List<AskBid> bids = from.getBidsList().stream().map(this::assembleAskBid).collect(Collectors.toList());
        result.setBids(bids);
        return result;
    }

    private AskBid assembleAskBid(Quotes.AskBid from) {
        AskBid result = new AskBid();
        result.setPrice(from.getPrice());
        result.setSize(from.getSize());
        List<Order> order = from.getOrderList().stream().map(this::assembleOrder).collect(Collectors.toList());
        result.setOrder(order);
        List<Broker> broker = from.getBrokerList().stream().map(this::assembleBroker).collect(Collectors.toList());
        result.setBroker(broker);
        return result;
    }

    private Order assembleOrder(Quotes.Order from) {
        Order result = new Order();
        result.setMpid(from.getMpid());
        result.setSize(from.getSize());
        return result;
    }

    private Broker assembleBroker(Quotes.Broker from) {
        Broker result = new Broker();
        result.setBid(from.getBid());
        result.setName(from.getName());
        return result;
    }
}

