/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.trade.grpc.lifecycle;

import com.webull.openapi.core.utils.ExceptionUtils;
import com.webull.openapi.trade.grpc.exception.UserCancelledException;
import com.webull.openapi.trade.grpc.lifecycle.GrpcFailedContext;
import io.grpc.Status;

public class GrpcFailedContextAdapter
implements GrpcFailedContext {
    protected final boolean userCancelled;
    protected final int statusCode;
    protected final Throwable cause;

    protected GrpcFailedContextAdapter(Throwable cause) {
        this.cause = cause;
        this.statusCode = Status.fromThrowable((Throwable)cause).getCode().value();
        Throwable rootCause = ExceptionUtils.getRootCause(cause);
        this.userCancelled = rootCause instanceof UserCancelledException;
    }

    public static GrpcFailedContextAdapter of(Throwable cause) {
        return new GrpcFailedContextAdapter(cause);
    }

    @Override
    public boolean userCancelled() {
        return this.userCancelled;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }
}

