/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.http.initializer.token;

import com.webull.openapi.core.common.Region;
import com.webull.openapi.core.execption.ClientException;
import com.webull.openapi.core.http.HttpApiClient;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.http.HttpRequest;
import com.webull.openapi.core.http.common.HttpMethod;
import com.webull.openapi.core.http.initializer.token.bean.AccessToken;
import com.webull.openapi.core.utils.Assert;
import com.webull.openapi.core.utils.StringUtils;
import java.lang.reflect.Type;
import java.util.HashMap;

public class TokenService {
    private static final String TOKEN_ARG = "token";
    private final Region region;
    private final HttpApiClient apiClient;

    public TokenService(HttpApiConfig config) {
        this(new HttpApiClient(config));
    }

    public TokenService(HttpApiClient apiClient) {
        this.region = Region.of(apiClient.getConfig().getRegionId()).orElseThrow(() -> new ClientException("InvalidParameter", "Must set region id which defined in " + Region.class.getName() + " when using this service."));
        this.apiClient = apiClient;
    }

    public AccessToken createToken(String token) {
        HttpRequest request = new HttpRequest("/openapi/auth/token/create", "v2", HttpMethod.POST);
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank(token)) {
            params.put(TOKEN_ARG, token);
        }
        request.setBody(params);
        return (AccessToken)this.apiClient.request(request).responseType((Type)((Object)AccessToken.class)).doAction();
    }

    public AccessToken checkToken(String token) {
        Assert.notBlank(TOKEN_ARG, token);
        HttpRequest request = new HttpRequest("/openapi/auth/token/check", "v2", HttpMethod.POST);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(TOKEN_ARG, token);
        request.setBody(params);
        return (AccessToken)this.apiClient.request(request).responseType((Type)((Object)AccessToken.class)).doAction();
    }

    public AccessToken refreshToken(String token) {
        Assert.notBlank(TOKEN_ARG, token);
        HttpRequest request = new HttpRequest("/openapi/auth/token/refresh", "v2", HttpMethod.POST);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(TOKEN_ARG, token);
        request.setBody(params);
        return (AccessToken)this.apiClient.request(request).responseType((Type)((Object)AccessToken.class)).doAction();
    }
}

