/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.core.http.retry;

import com.webull.openapi.core.http.HttpResponse;
import com.webull.openapi.core.http.retry.HttpRetryContext;
import com.webull.openapi.core.retry.RetryContext;
import com.webull.openapi.core.retry.RetryPolicy;
import com.webull.openapi.core.retry.SynchronousRetryable;
import java.util.Optional;
import java.util.function.Supplier;

public class SynchronousHttpRetryable
extends SynchronousRetryable<HttpResponse> {
    public SynchronousHttpRetryable(Supplier<HttpResponse> doRetry, RetryPolicy retryPolicy) {
        super(doRetry, retryPolicy);
    }

    @Override
    protected Optional<RetryContext> maybeContinue(RetryContext previousContext, HttpResponse response, Throwable cause) {
        if (!(previousContext instanceof HttpRetryContext)) {
            throw new IllegalArgumentException("Retry context[" + previousContext.getClass().getName() + "] is inappropriate to http retryable!");
        }
        HttpRetryContext prevHttpCtx = (HttpRetryContext)previousContext;
        if (cause != null) {
            HttpRetryContext newContext = new HttpRetryContext(prevHttpCtx.getUri(), prevHttpCtx.getMethod(), 400, prevHttpCtx.getRetriesAttempted() + 1, cause);
            return Optional.of(newContext);
        }
        if (response != null && !response.isSuccess()) {
            HttpRetryContext newContext = new HttpRetryContext(prevHttpCtx.getUri(), prevHttpCtx.getMethod(), response.getStatusCode(), prevHttpCtx.getRetriesAttempted() + 1, response.getException());
            return Optional.of(newContext);
        }
        return Optional.empty();
    }
}

