/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.data;

import com.google.gson.reflect.TypeToken;
import com.webull.openapi.core.http.HttpApiClient;
import com.webull.openapi.core.http.HttpApiConfig;
import com.webull.openapi.core.http.HttpRequest;
import com.webull.openapi.core.http.common.HttpMethod;
import com.webull.openapi.core.http.initializer.ClientInitializer;
import com.webull.openapi.core.utils.Assert;
import com.webull.openapi.core.utils.CollectionUtils;
import com.webull.openapi.core.utils.StringUtils;
import com.webull.openapi.data.quotes.api.IDataClient;
import com.webull.openapi.data.quotes.domain.Bar;
import com.webull.openapi.data.quotes.domain.BatchBarResponse;
import com.webull.openapi.data.quotes.domain.CorpAction;
import com.webull.openapi.data.quotes.domain.CorpActionRequest;
import com.webull.openapi.data.quotes.domain.CryptoInstrumentDetail;
import com.webull.openapi.data.quotes.domain.DepthOfBook;
import com.webull.openapi.data.quotes.domain.EodBars;
import com.webull.openapi.data.quotes.domain.EventDepth;
import com.webull.openapi.data.quotes.domain.EventInstrumentParam;
import com.webull.openapi.data.quotes.domain.EventMarket;
import com.webull.openapi.data.quotes.domain.EventSeries;
import com.webull.openapi.data.quotes.domain.EventSnapshot;
import com.webull.openapi.data.quotes.domain.FootprintResponse;
import com.webull.openapi.data.quotes.domain.FuturesInstrument;
import com.webull.openapi.data.quotes.domain.FuturesProduct;
import com.webull.openapi.data.quotes.domain.Instrument;
import com.webull.openapi.data.quotes.domain.InstrumentQueryParam;
import com.webull.openapi.data.quotes.domain.NBar;
import com.webull.openapi.data.quotes.domain.Quote;
import com.webull.openapi.data.quotes.domain.Snapshot;
import com.webull.openapi.data.quotes.domain.StockInstrumentDetail;
import com.webull.openapi.data.quotes.domain.Tick;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class DataClient
implements IDataClient {
    private static final String NOT_SUPPORT_MSG = "Http client not support for this method, please use default grpc client.";
    private final HttpApiClient apiClient;
    private String userId;

    public DataClient(HttpApiConfig config) {
        this.apiClient = new HttpApiClient(config);
        ClientInitializer.init(this.apiClient);
    }

    public DataClient(HttpApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DataClient setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    private void addCustomHeaders(HttpRequest request) {
        if (StringUtils.isNotEmpty(this.userId)) {
            request.getHeaders().put("wb-user-id", this.userId);
        }
    }

    @Override
    public List<Instrument> getInstruments(Set<String> symbols, String category) {
        Assert.notEmpty("symbols", symbols);
        Assert.notBlank("category", category);
        HttpRequest request = new HttpRequest("/openapi/instrument/stock/list", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbols", String.join((CharSequence)",", symbols));
        params.put("category", category);
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<Instrument>>(){}.getType()).doAction();
    }

    @Override
    public List<Bar> getBars(String symbol, String category, String timespan, int count) {
        return this.getBars(symbol, category, timespan, count, null, null);
    }

    @Override
    public BatchBarResponse getBatchBars(List<String> symbols, String category, String timespan, int count) {
        return this.getBatchBars(symbols, category, timespan, count, null, null);
    }

    @Override
    public List<Bar> getBars(String symbol, String category, String timespan, int count, Boolean realTimeRequired, List<String> tradingSessions) {
        Assert.notBlank(Arrays.asList("symbol", "category", "timespan"), symbol, category, timespan);
        HttpRequest request = new HttpRequest("/openapi/market-data/stock/bars", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbol", symbol);
        params.put("category", category);
        params.put("timespan", timespan);
        params.put("count", count);
        if (Objects.nonNull(realTimeRequired)) {
            params.put("real_time_required", realTimeRequired);
        }
        if (CollectionUtils.isNotEmpty(tradingSessions)) {
            params.put("trading_sessions", String.join((CharSequence)",", tradingSessions));
        }
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<Bar>>(){}.getType()).doAction();
    }

    @Override
    public BatchBarResponse getBatchBars(List<String> symbols, String category, String timespan, int count, Boolean realTimeRequired, List<String> tradingSessions) {
        Assert.notEmpty("symbols", symbols);
        Assert.notBlank("category", category);
        Assert.notBlank("timespan", timespan);
        HttpRequest request = new HttpRequest("/openapi/market-data/stock/batch-bars", "v2", HttpMethod.POST);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbols", symbols);
        params.put("category", category);
        params.put("timespan", timespan);
        params.put("count", count);
        if (Objects.nonNull(realTimeRequired)) {
            params.put("real_time_required", realTimeRequired);
        }
        if (CollectionUtils.isNotEmpty(tradingSessions)) {
            params.put("trading_sessions", String.join((CharSequence)",", tradingSessions));
        }
        request.setBody(params);
        this.addCustomHeaders(request);
        return (BatchBarResponse)this.apiClient.request(request).responseType(new TypeToken<BatchBarResponse>(){}.getType()).doAction();
    }

    @Override
    public List<EodBars> getEodBars(Set<String> instrumentIds, String date, Integer count) {
        Assert.notEmpty("instrument_ids", instrumentIds);
        HttpRequest request = new HttpRequest("/market-data/eod-bars", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("instrument_ids", String.join((CharSequence)",", instrumentIds));
        if (StringUtils.isNotEmpty(date)) {
            params.put("date", date);
        }
        params.put("count", count == null ? 1 : count);
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<EodBars>>(){}.getType()).doAction();
    }

    @Override
    public List<CorpAction> getCorpAction(CorpActionRequest action) {
        HttpRequest request = new HttpRequest("/instrument/corp-action", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        Assert.notEmpty("event_types", action.getEventTypes());
        params.put("event_types", String.join((CharSequence)",", action.getEventTypes()));
        Optional.ofNullable(action.getInstrumentIds()).filter(StringUtils::isNotEmpty).ifPresent(instrumentIds -> params.put("instrument_ids", String.join((CharSequence)",", instrumentIds)));
        Optional.ofNullable(action.getStartDate()).filter(StringUtils::isNotEmpty).ifPresent(startDate -> params.put("start_date", startDate));
        Optional.ofNullable(action.getEndDate()).filter(StringUtils::isNotEmpty).ifPresent(endDate -> params.put("end_date", endDate));
        Optional.ofNullable(action.getLastUpdateTime()).filter(StringUtils::isNotEmpty).ifPresent(lastUpdateTime -> params.put("last_update_time", lastUpdateTime));
        Optional.ofNullable(action.getPageNumber()).filter(StringUtils::isNotEmpty).ifPresent(pageNumber -> params.put("page_number", pageNumber));
        Optional.ofNullable(action.getPageSize()).filter(StringUtils::isNotEmpty).ifPresent(pageSize -> params.put("page_size", pageSize));
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<CorpAction>>(){}.getType()).doAction();
    }

    @Override
    public Quote getQuote(String symbol, String category, String depth, Boolean overnightRequired) {
        Assert.notBlank("symbol", symbol);
        Assert.notBlank("category", category);
        HttpRequest request = new HttpRequest("/openapi/market-data/stock/quotes", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbol", symbol);
        params.put("category", category);
        if (StringUtils.isNotBlank(depth)) {
            params.put("depth", depth);
        }
        if (Objects.nonNull(overnightRequired)) {
            params.put("overnight_required", overnightRequired);
        }
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (Quote)this.apiClient.request(request).responseType(new TypeToken<Quote>(){}.getType()).doAction();
    }

    @Override
    public List<Snapshot> getSnapshots(Set<String> symbols, String category, Boolean extendHourRequired, Boolean overnightRequired) {
        Assert.notEmpty("symbols", symbols);
        Assert.notBlank("category", category);
        HttpRequest request = new HttpRequest("/market-data/snapshot", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbols", String.join((CharSequence)",", symbols));
        params.put("category", category);
        if (Objects.nonNull(extendHourRequired)) {
            params.put("extend_hour_required", extendHourRequired);
        }
        if (Objects.nonNull(overnightRequired)) {
            params.put("overnight_required", overnightRequired);
        }
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<Snapshot>>(){}.getType()).doAction();
    }

    @Override
    public Tick getTicks(String symbol, String category, int count, List<String> tradingSessions) {
        Assert.notBlank(Arrays.asList("symbol", "category"), symbol, category);
        HttpRequest request = new HttpRequest("/openapi/market-data/stock/tick", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbol", symbol);
        params.put("category", category);
        params.put("count", count);
        if (CollectionUtils.isNotEmpty(tradingSessions)) {
            params.put("trading_sessions", String.join((CharSequence)",", tradingSessions));
        }
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (Tick)this.apiClient.request(request).responseType(new TypeToken<Tick>(){}.getType()).doAction();
    }

    @Override
    public List<FootprintResponse> getFootprint(Set<String> symbols, String category, String timespan, int count, Boolean realTimeRequired, String tradingSessions) {
        Assert.notEmpty("symbols", symbols);
        Assert.notBlank("category", category);
        Assert.notBlank("timespan", timespan);
        HttpRequest request = new HttpRequest("/openapi/market-data/stock/footprint", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbols", String.join((CharSequence)",", symbols));
        params.put("category", category);
        params.put("timespan", timespan);
        params.put("count", count);
        if (Objects.nonNull(realTimeRequired)) {
            params.put("real_time_required", realTimeRequired);
        }
        if (StringUtils.isNotEmpty(tradingSessions)) {
            params.put("trading_sessions", tradingSessions);
        }
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<FootprintResponse>>(){}.getType()).doAction();
    }

    @Override
    public List<NBar> getFuturesBars(List<String> symbols, String category, String timespan, int count, Boolean realTimeRequired) {
        Assert.notEmpty("symbols", symbols);
        Assert.notBlank("category", category);
        Assert.notBlank("timespan", timespan);
        HttpRequest request = new HttpRequest("/openapi/market-data/futures/bars", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbols", String.join((CharSequence)",", symbols));
        params.put("category", category);
        params.put("timespan", timespan);
        params.put("count", count);
        if (Objects.nonNull(realTimeRequired)) {
            params.put("real_time_required", realTimeRequired);
        }
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<NBar>>(){}.getType()).doAction();
    }

    @Override
    public DepthOfBook getFuturesDepth(String symbol, String category, String depth) {
        Assert.notBlank("symbol", symbol);
        Assert.notBlank("category", category);
        HttpRequest request = new HttpRequest("/openapi/market-data/futures/depth", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbol", symbol);
        params.put("category", category);
        if (StringUtils.isNotBlank(depth)) {
            params.put("depth", depth);
        }
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (DepthOfBook)this.apiClient.request(request).responseType(new TypeToken<DepthOfBook>(){}.getType()).doAction();
    }

    @Override
    public List<Snapshot> getFuturesSnapshots(Set<String> symbols, String category) {
        Assert.notEmpty("symbols", symbols);
        Assert.notBlank("category", category);
        HttpRequest request = new HttpRequest("/openapi/market-data/futures/snapshot", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbols", String.join((CharSequence)",", symbols));
        params.put("category", category);
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<Snapshot>>(){}.getType()).doAction();
    }

    @Override
    public Tick getFutureTicks(String symbol, String category, int count) {
        Assert.notBlank(Arrays.asList("symbol", "category"), symbol, category);
        HttpRequest request = new HttpRequest("/openapi/market-data/futures/tick", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbol", symbol);
        params.put("category", category);
        params.put("count", count);
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (Tick)this.apiClient.request(request).responseType(new TypeToken<Tick>(){}.getType()).doAction();
    }

    @Override
    public List<FuturesProduct> getFuturesProducts(String category) {
        Assert.notBlank("category", category);
        HttpRequest request = new HttpRequest("/openapi/instrument/futures/products", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("category", category);
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<FuturesProduct>>(){}.getType()).doAction();
    }

    @Override
    public List<FuturesInstrument> getFuturesInstruments(Set<String> symbols, String category) {
        Assert.notEmpty("symbols", symbols);
        Assert.notBlank("category", category);
        HttpRequest request = new HttpRequest("/openapi/instrument/futures/list", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbols", String.join((CharSequence)",", symbols));
        params.put("category", category);
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<FuturesInstrument>>(){}.getType()).doAction();
    }

    @Override
    public List<FuturesInstrument> getFuturesInstrumentsByCode(String code, String category, String contractType) {
        Assert.notBlank(Arrays.asList("category", "code"), category, code);
        HttpRequest request = new HttpRequest("/openapi/instrument/futures/by-code", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        params.put("category", category);
        if (Objects.nonNull(contractType)) {
            params.put("contract_type", contractType);
        }
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<FuturesInstrument>>(){}.getType()).doAction();
    }

    @Override
    public List<FootprintResponse> getFuturesFootprint(Set<String> symbols, String category, String timespan, int count, Boolean realTimeRequired, String tradingSessions) {
        Assert.notEmpty("symbols", symbols);
        Assert.notBlank("category", category);
        Assert.notBlank("timespan", timespan);
        HttpRequest request = new HttpRequest("/openapi/market-data/futures/footprint", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbols", String.join((CharSequence)",", symbols));
        params.put("category", category);
        params.put("timespan", timespan);
        params.put("count", count);
        if (Objects.nonNull(realTimeRequired)) {
            params.put("real_time_required", realTimeRequired);
        }
        if (StringUtils.isNotEmpty(tradingSessions)) {
            params.put("trading_sessions", tradingSessions);
        }
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<FootprintResponse>>(){}.getType()).doAction();
    }

    @Override
    public List<Snapshot> getCryptoSnapshots(Set<String> symbols, String category) {
        Assert.notEmpty("symbols", symbols);
        Assert.notBlank("category", category);
        HttpRequest request = new HttpRequest("/openapi/market-data/crypto/snapshot", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbols", String.join((CharSequence)",", symbols));
        params.put("category", category);
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<Snapshot>>(){}.getType()).doAction();
    }

    @Override
    public List<NBar> getCryptoBars(Set<String> symbols, String category, String timespan, int count, Boolean realTimeRequired) {
        Assert.notEmpty("symbols", symbols);
        Assert.notBlank(Arrays.asList("category", "timespan"), category, timespan);
        HttpRequest request = new HttpRequest("/openapi/market-data/crypto/bars", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbols", String.join((CharSequence)",", symbols));
        params.put("category", category);
        params.put("timespan", timespan);
        params.put("count", count);
        if (Objects.nonNull(realTimeRequired)) {
            params.put("real_time_required", realTimeRequired);
        }
        request.setQuery(params);
        this.addCustomHeaders(request);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<NBar>>(){}.getType()).doAction();
    }

    @Override
    public List<StockInstrumentDetail> getInstrumentsV1(InstrumentQueryParam param) {
        Assert.notNull("parameter", (Object)param);
        String category = param.getCategory();
        Set<String> symbols = param.getSymbols();
        String status = param.getStatus();
        String lastInstrumentId = param.getLastInstrumentId();
        int pageSize = param.getPageSize();
        Assert.notBlank("category", category);
        HttpRequest request = new HttpRequest("/openapi/instrument/stock/list", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(symbols)) {
            params.put("symbols", String.join((CharSequence)",", symbols));
        }
        params.put("category", category);
        if (StringUtils.isNotEmpty(status)) {
            params.put("status", status);
        }
        if (StringUtils.isNotEmpty(lastInstrumentId)) {
            params.put("last_instrument_id", lastInstrumentId);
        }
        params.put("page_size", pageSize);
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<StockInstrumentDetail>>(){}.getType()).doAction();
    }

    @Override
    public List<CryptoInstrumentDetail> getCryptoInstrument(InstrumentQueryParam param) {
        Assert.notNull("parameter", (Object)param);
        String category = param.getCategory();
        Set<String> symbols = param.getSymbols();
        String status = param.getStatus();
        String lastInstrumentId = param.getLastInstrumentId();
        int pageSize = param.getPageSize();
        Assert.notBlank("category", category);
        HttpRequest request = new HttpRequest("/openapi/instrument/crypto/list", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("category", category);
        if (CollectionUtils.isNotEmpty(symbols)) {
            params.put("symbols", String.join((CharSequence)",", symbols));
        }
        if (StringUtils.isNotEmpty(status)) {
            params.put("status", status);
        }
        if (StringUtils.isNotEmpty(lastInstrumentId)) {
            params.put("last_instrument_id", lastInstrumentId);
        }
        params.put("page_size", pageSize);
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<CryptoInstrumentDetail>>(){}.getType()).doAction();
    }

    @Override
    public List<EventSeries> getEventSeriesList(EventInstrumentParam eventInstrumentParam) {
        Assert.notNull("parameter", (Object)eventInstrumentParam);
        String category = eventInstrumentParam.getCategory();
        Assert.notBlank("category", category);
        HttpRequest request = new HttpRequest("/openapi/instrument/event/series/list", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("category", category);
        if (StringUtils.isNotEmpty(eventInstrumentParam.getLastInstrumentId())) {
            params.put("last_instrument_id", eventInstrumentParam.getLastInstrumentId());
        }
        params.put("page_size", eventInstrumentParam.getPageSize());
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<EventSeries>>(){}.getType()).doAction();
    }

    @Override
    public List<EventMarket> getEventInstrumentsList(EventInstrumentParam eventInstrumentParam) {
        Assert.notNull("parameter", (Object)eventInstrumentParam);
        Assert.notBlank("series_symbol", eventInstrumentParam.getSeriesSymbol());
        HttpRequest request = new HttpRequest("/openapi/instrument/event/market/list", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("series_symbol", eventInstrumentParam.getSeriesSymbol());
        if (StringUtils.isNotEmpty(eventInstrumentParam.getLastInstrumentId())) {
            params.put("last_instrument_id", eventInstrumentParam.getLastInstrumentId());
        }
        params.put("page_size", eventInstrumentParam.getPageSize());
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<EventMarket>>(){}.getType()).doAction();
    }

    @Override
    public List<EventSnapshot> getEventSnapshot(Set<String> symbols, String category) {
        Assert.notNull("symbols", symbols);
        HttpRequest request = new HttpRequest("/openapi/market-data/event/snapshot", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(symbols)) {
            params.put("symbols", String.join((CharSequence)",", symbols));
        }
        if (StringUtils.isNotBlank(category)) {
            params.put("category", category);
        }
        request.setQuery(params);
        return (List)this.apiClient.request(request).responseType(new TypeToken<List<EventSnapshot>>(){}.getType()).doAction();
    }

    @Override
    public EventDepth getEventDepth(String symbol, String category, String depth) {
        Assert.notBlank("symbol", symbol);
        HttpRequest request = new HttpRequest("/openapi/market-data/event/depth", "v2", HttpMethod.GET);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("symbol", symbol);
        if (StringUtils.isNotBlank(category)) {
            params.put("category", category);
        }
        if (StringUtils.isNotBlank(depth)) {
            params.put("depth", depth);
        }
        request.setQuery(params);
        return (EventDepth)this.apiClient.request(request).responseType(new TypeToken<EventDepth>(){}.getType()).doAction();
    }
}

