/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.data.internal.mqtt.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import com.webull.openapi.data.internal.mqtt.codec.Quotes;
import com.webull.openapi.data.internal.mqtt.codec.QuotesPublishDecoder;
import com.webull.openapi.data.quotes.domain.EventDepth;
import com.webull.openapi.data.quotes.subsribe.exception.DecoderException;
import com.webull.openapi.data.quotes.subsribe.message.QuotesPublish;
import java.nio.ByteBuffer;
import java.util.stream.Collectors;

public class EventDepthDecoder
implements QuotesPublishDecoder<EventDepth> {
    @Override
    public QuotesPublish<EventDepth> decode(ByteBuffer in) {
        try {
            Quotes.EventQuote from = Quotes.EventQuote.parseFrom(in);
            EventDepth snapshot = new EventDepth();
            snapshot.setInstrumentId(from.getBasic().getInstrumentId());
            snapshot.setSymbol(from.getBasic().getSymbol());
            snapshot.setYesBids(from.getYesBidsList().stream().map(this::assembleAskBid).collect(Collectors.toList()));
            snapshot.setNoBids(from.getNoBidsList().stream().map(this::assembleAskBid).collect(Collectors.toList()));
            return new QuotesPublish<EventDepth>(from.getBasic().getTimestamp(), snapshot);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecoderException("Decode event snapshot data error", e);
        }
    }

    private EventDepth.AskBid assembleAskBid(Quotes.EventAskBid from) {
        EventDepth.AskBid result = new EventDepth.AskBid();
        result.setPrice(from.getPrice());
        result.setSize(from.getSize());
        return result;
    }
}

