/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.data.internal.mqtt.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import com.webull.openapi.data.internal.mqtt.codec.Quotes;
import com.webull.openapi.data.internal.mqtt.codec.QuotesPublishDecoder;
import com.webull.openapi.data.quotes.domain.EventSnapshot;
import com.webull.openapi.data.quotes.subsribe.exception.DecoderException;
import com.webull.openapi.data.quotes.subsribe.message.QuotesPublish;
import java.nio.ByteBuffer;

public class EventSnapshotDecoder
implements QuotesPublishDecoder<EventSnapshot> {
    @Override
    public QuotesPublish<EventSnapshot> decode(ByteBuffer in) {
        try {
            Quotes.EventSnapshot from = Quotes.EventSnapshot.parseFrom(in);
            EventSnapshot snapshot = new EventSnapshot();
            snapshot.setInstrumentId(from.getBasic().getInstrumentId());
            snapshot.setSymbol(from.getBasic().getSymbol());
            snapshot.setPrice(from.getPrice());
            snapshot.setVolume(from.getVolume());
            snapshot.setLastTradeTime(from.getLastTradeTime().isEmpty() ? null : Long.valueOf(Long.parseLong(from.getLastTradeTime())));
            snapshot.setOpenInterest(from.getOpenInterest());
            snapshot.setYesBid(from.getYesBid());
            snapshot.setYesBidSize(from.getYesBidSize());
            snapshot.setYesAsk(from.getYesAsk());
            snapshot.setYesAskSize(from.getYesAskSize());
            snapshot.setNoBid(from.getNoBid());
            snapshot.setNoBidSize(from.getNoBidSize());
            snapshot.setNoAsk(from.getNoAsk());
            snapshot.setNoAskSize(from.getNoAskSize());
            return new QuotesPublish<EventSnapshot>(from.getBasic().getTimestamp(), snapshot);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecoderException("Decode event snapshot data error", e);
        }
    }
}

