/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.data.internal.mqtt.codec;

import com.webull.openapi.core.common.dict.SubscribeType;
import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.data.internal.mqtt.codec.EventDepthDecoder;
import com.webull.openapi.data.internal.mqtt.codec.EventSnapshotDecoder;
import com.webull.openapi.data.internal.mqtt.codec.QuoteDecoder;
import com.webull.openapi.data.internal.mqtt.codec.QuotesPublishDecoder;
import com.webull.openapi.data.internal.mqtt.codec.SnapshotDecoder;
import com.webull.openapi.data.internal.mqtt.codec.TickDecoder;
import com.webull.openapi.data.internal.mqtt.message.MqttPublish;
import com.webull.openapi.data.quotes.domain.QuotesBasic;
import com.webull.openapi.data.quotes.subsribe.codec.AbstractInboundDecoder;
import com.webull.openapi.data.quotes.subsribe.message.MarketData;
import com.webull.openapi.data.quotes.subsribe.message.Metadata;
import com.webull.openapi.data.quotes.subsribe.message.QuotesPublish;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;

public class PublishToMarketDataDecoder
extends AbstractInboundDecoder<MqttPublish, MarketData> {
    private static final Logger logger = LoggerFactory.getLogger(PublishToMarketDataDecoder.class);
    private final Map<SubscribeType, QuotesPublishDecoder<? extends QuotesBasic>> delegates = new EnumMap<SubscribeType, QuotesPublishDecoder<? extends QuotesBasic>>(SubscribeType.class);

    public PublishToMarketDataDecoder() {
        this.delegates.put(SubscribeType.QUOTE, new QuoteDecoder());
        this.delegates.put(SubscribeType.SNAPSHOT, new SnapshotDecoder());
        this.delegates.put(SubscribeType.TICK, new TickDecoder());
        this.delegates.put(SubscribeType.EVENT_QUOTE, new EventDepthDecoder());
        this.delegates.put(SubscribeType.EVENT_SNAPSHOT, new EventSnapshotDecoder());
    }

    @Override
    public MarketData decode(MqttPublish in) {
        String topic = in.getTopic();
        ArrayList<String> notDecodeTopic = new ArrayList<String>();
        notDecodeTopic.add("echo");
        notDecodeTopic.add("notice");
        if (notDecodeTopic.contains(topic)) {
            logger.debug("No decoding is required, the type is {}.", (Object)topic);
            return null;
        }
        Optional<SubscribeType> subscribeTypeOpt = SubscribeType.fromType(topic);
        if (!subscribeTypeOpt.isPresent()) {
            logger.warn("Unrecognized data type={}.", (Object)topic);
            return null;
        }
        Metadata metadata = new Metadata(subscribeTypeOpt.get());
        QuotesPublishDecoder<? extends QuotesBasic> delegate = this.delegates.get((Object)subscribeTypeOpt.get());
        QuotesPublish delegateOut = (QuotesPublish)delegate.decode(in.getPayload());
        return new MarketData(metadata, delegateOut);
    }
}

