/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.data.internal.mqtt.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import com.webull.openapi.data.internal.mqtt.codec.Quotes;
import com.webull.openapi.data.internal.mqtt.codec.QuotesPublishDecoder;
import com.webull.openapi.data.quotes.domain.Tick;
import com.webull.openapi.data.quotes.domain.TickRecord;
import com.webull.openapi.data.quotes.subsribe.exception.DecoderException;
import com.webull.openapi.data.quotes.subsribe.message.QuotesPublish;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TickDecoder
implements QuotesPublishDecoder<Tick> {
    @Override
    public QuotesPublish<Tick> decode(ByteBuffer in) throws DecoderException {
        try {
            Quotes.Tick from = Quotes.Tick.parseFrom(in);
            Tick tick = new Tick();
            tick.setSymbol(from.getBasic().getSymbol());
            tick.setInstrumentId(from.getBasic().getInstrumentId());
            ArrayList<TickRecord> tickRecordList = new ArrayList<TickRecord>();
            TickRecord tickRecord = new TickRecord();
            tickRecord.setTime(from.getTime());
            tickRecord.setPrice(from.getPrice());
            tickRecord.setVolume(from.getVolume());
            tickRecord.setSide(from.getSide());
            tickRecord.setTradingSession(from.getBasic().getTradingSession());
            tickRecordList.add(tickRecord);
            tick.setResult(tickRecordList);
            return new QuotesPublish<Tick>(from.getBasic().getTimestamp(), tick);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecoderException("Decode tick data error", e);
        }
    }
}

