/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.trade.events.internal.lifecycle;

import com.webull.openapi.core.logger.Logger;
import com.webull.openapi.core.logger.LoggerFactory;
import com.webull.openapi.trade.events.subscribe.lifecycle.SubscribeInboundHandler;
import com.webull.openapi.trade.events.subscribe.lifecycle.SubscribeSysEventHandler;
import com.webull.openapi.trade.events.subscribe.message.SubscribeResponse;
import com.webull.openapi.trade.grpc.lifecycle.GrpcFailedContext;
import com.webull.openapi.trade.grpc.lifecycle.GrpcSessionHandler;
import com.webull.openapi.trade.grpc.lifecycle.GrpcSuccessContext;

public class EventLoggingHandler
implements GrpcSessionHandler,
SubscribeInboundHandler,
SubscribeSysEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(EventLoggingHandler.class);

    @Override
    public void onSuccess(GrpcSuccessContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Trade event session on ready, ack={}.", (Object)context.getAck().orElse(null));
        }
    }

    @Override
    public void onFailed(GrpcFailedContext context) {
        if (context.userCancelled()) {
            logger.debug("Trade event session ended by user cancel.");
        } else {
            logger.error("Trade event session on failed, code={}.", context.getStatusCode(), context.getCause());
        }
    }

    @Override
    public void onCompleted() {
        if (logger.isDebugEnabled()) {
            logger.debug("Trade event session on completed.");
        }
    }

    @Override
    public void onMessage(SubscribeResponse message) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received trade event msg={}", (Object)message);
        }
    }

    @Override
    public void onPing(SubscribeResponse response) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received ping, msg={}", (Object)response);
        }
    }

    @Override
    public void onAuthError(SubscribeResponse response) {
        logger.error("Received authentication error, msg={}", (Object)response);
    }

    @Override
    public void onNumOfConnectionExceed(SubscribeResponse response) {
        logger.error("Number of connection exceeded, msg={}", (Object)response);
    }

    @Override
    public void onSubscribeExpired(SubscribeResponse response) {
        logger.error("Trade event subscribe expired, msg={}", (Object)response);
    }
}

