/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.log.impl;

import ch.qos.logback.classic.Level;
import com.wedeploy.api.log.Logger;
import jodd.util.StringUtil;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogger
implements Logger {
    private static final String FQCN = Logger.class.getName();
    private final LocationAwareLogger locationAwareLogger;
    private final org.slf4j.Logger logger;

    public Slf4jLogger(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.locationAwareLogger = this.logger instanceof LocationAwareLogger ? (LocationAwareLogger)this.logger : null;
    }

    public void debug(String message, Object ... values) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 10, message, values, null);
        } else {
            this.logger.debug(message, values);
        }
    }

    public void error(String message, Object ... values) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 40, message, values, null);
        } else {
            this.logger.warn(message, values);
        }
    }

    public void error(String message, Throwable throwable, Object ... values) {
        for (Object value : values) {
            String str = StringUtil.toSafeString((Object)value);
            message = StringUtil.replaceFirst((String)message, (String)"{}", (String)str);
        }
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 40, message, values, throwable);
        } else {
            this.logger.error(message, throwable);
        }
    }

    public String getName() {
        return this.logger.getName();
    }

    public void info(String message, Object ... values) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 20, message, values, null);
        } else {
            this.logger.info(message, values);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isEnabled(Logger.Level level) {
        switch (level) {
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void log(Logger.Level level, String message, Object ... values) {
        switch (level) {
            case TRACE: {
                this.trace(message, values);
                break;
            }
            case DEBUG: {
                this.debug(message, values);
                break;
            }
            case INFO: {
                this.info(message, values);
                break;
            }
            case WARN: {
                this.warn(message, values);
                break;
            }
            case ERROR: {
                this.error(message, values);
            }
        }
    }

    public void setLevel(String name, Logger.Level level) {
        if (this.logger instanceof ch.qos.logback.classic.Logger) {
            Level l = null;
            switch (level) {
                case TRACE: {
                    l = Level.TRACE;
                    break;
                }
                case DEBUG: {
                    l = Level.DEBUG;
                    break;
                }
                case INFO: {
                    l = Level.INFO;
                    break;
                }
                case WARN: {
                    l = Level.WARN;
                    break;
                }
                case ERROR: {
                    l = Level.WARN;
                }
            }
            ((ch.qos.logback.classic.Logger)this.logger).setLevel(l);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void trace(String message, Object ... values) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 0, message, values, null);
        } else {
            this.logger.trace(message, values);
        }
    }

    public void warn(String message, Object ... values) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 30, message, values, null);
        } else {
            this.logger.warn(message, values);
        }
    }

    public void warn(String message, Throwable throwable, Object ... values) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 30, message, values, throwable);
        } else {
            this.logger.warn(message, (Object)throwable, (Object)values);
        }
    }
}

