/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the
 * GNU Lesser General Public License as published by the Free Software Foundation; either version
 * 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */

package com.wedeploy.api.sdk;

/**
 * Auth implementation.
 */
public class AuthImpl implements Auth {

	/**
	 * Creates {@link Auth} implementation usage.
	 */
	public AuthImpl(String token) {
		this.token = token;
	}

	/**
	 * Creates authentication instance.
	 */
	public AuthImpl(String username, String password) {
		this.token = null;
		this.email = username;
		this.password = password;
	}

	@Override
	public String email() {
		return email;
	}

	@Override
	public boolean hasScope(String scope) {
		throw new UnsupportedOperationException();
	}

	@Override
	public String id() {
		return id;
	}

	@Override
	public boolean isAuthenticated() {
		throw new UnsupportedOperationException();
	}

	@Override
	public String name() {
		return name;
	}

	@Override
	public String password() {
		return password;
	}

	@Override
	public String photoUrl() {
		return photoUrl;
	}

	@Override
	public String token() {
		return token;
	}

	protected String email;
	protected String id;
	protected String name;
	protected String password;
	protected String photoUrl;
	protected final String token;

}