/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * <p>
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * <p>
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * <p>
 * 3. Neither the name of Liferay, Inc. nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package com.wedeploy.api.sdk;

/**
 * Error 400 errors.
 */
public class Error400<T> extends ErrorBase<T, Error400<T>> {

	public Error400(ErrorData<T> errorData, String message) {
		super(errorData, 400, message, "Bad Request");
	}

	public Error400<T> badContent() {
		return badContent(null);
	}

	public Error400<T> badContent(String message) {
		return error(
			"badContent", message,
			"The content type of the request data or the content type of a" +
				" part of a multipart request is not supported."
		);
	}

	public Error400<T> badRequest() {
		return badRequest(null);
	}

	public Error400<T> badRequest(String message) {
		return error(
			"badRequest", message,
			"The API request is invalid or improperly formed.");
	}

	public Error400<T> exists() {
		return exists(null);
	}

	public Error400<T> exists(String message) {
		return error("exists", message, "Resource already exists.");
	}

	public Error400<T> invalidDocumentValue() {
		return invalidDocumentValue(null);
	}

	public Error400<T> invalidDocumentValue(String message) {
		return error("invalidDocumentValue", message,
			"The request failed because it contained an invalid parameter or" +
				" parameter value for the document. Review the API" +
				" documentation to determine which parameters are valid for" +
				" your request."
		);
	}

	public Error400<T> invalidQuery() {
		return invalidQuery(null);
	}

	public Error400<T> invalidQuery(String message) {
		return error(
			"invalidQuery", message,
			"The request is invalid. Check the API documentation to determine" +
				" what parameters are supported for the request and to see if" +
				" the request contains an invalid combination of parameters" +
				" or an invalid parameter value."
		);
	}

	public Error400<T> keyExpired() {
		return keyExpired(null);
	}

	public Error400<T> keyExpired(String message) {
		return error(
			"keyExpired", message,
			"The API key provided in the request expired, which means the API" +
				"server is unable to make the request."
		);
	}

	public Error400<T> keyInvalid() {
		return keyInvalid(null);
	}

	public Error400<T> keyInvalid(String message) {
		return error(
			"keyInvalid", message,
			"The API key provided in the request is invalid, which means the" +
				" API server is unable to make the request."
		);
	}

	public Error400<T> parseError() {
		return parseError(null);
	}

	public Error400<T> parseError(String message) {
		return error(
			"parseError", message,
			"The API server cannot parse the request body.");
	}

	public Error400<T> required() {
		return required(null);
	}

	public Error400<T> required(String message) {
		return error(
			"required", message,
			"The API request is missing required information. The required" +
				" information could be a parameter or resource property."
		);
	}

	public Error400<T> validationError() {
		return validationError(null);
	}

	public Error400<T> validationError(String message) {
		return error(
			"validationError", message,
			"Validation of input failed.");
	}

}
