/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * <p>
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * <p>
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * <p>
 * 3. Neither the name of Liferay, Inc. nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package com.wedeploy.api.sdk;

public final class HttpHeaders {

	public static final class Names {
		/**
		 * {@code "Accept"}
		 */
		public static final String ACCEPT = "Accept";

		/**
		 * {@code "Accept-Charset"}
		 */
		public static final String ACCEPT_CHARSET = "Accept-Charset";

		/**
		 * {@code "Accept-Encoding"}
		 */
		public static final String ACCEPT_ENCODING = "Accept-Encoding";

		/**
		 * {@code "Accept-Language"}
		 */
		public static final String ACCEPT_LANGUAGE = "Accept-Language";

		/**
		 * {@code "Accept-Patch"}
		 */
		public static final String ACCEPT_PATCH = "Accept-Patch";

		/**
		 * {@code "Accept-Ranges"}
		 */
		public static final String ACCEPT_RANGES = "Accept-Ranges";

		/**
		 * {@code "Access-Control-Allow-Credentials"}
		 */
		public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS =
			"Access-Control-Allow-Credentials";

		/**
		 * {@code "Access-Control-Allow-Headers"}
		 */
		public static final String ACCESS_CONTROL_ALLOW_HEADERS =
			"Access-Control-Allow-Headers";

		/**
		 * {@code "Access-Control-Allow-Methods"}
		 */
		public static final String ACCESS_CONTROL_ALLOW_METHODS =
			"Access-Control-Allow-Methods";

		/**
		 * {@code "Access-Control-Allow-Origin"}
		 */
		public static final String ACCESS_CONTROL_ALLOW_ORIGIN =
			"Access-Control-Allow-Origin";

		/**
		 * {@code "Access-Control-Expose-Headers"}
		 */
		public static final String ACCESS_CONTROL_EXPOSE_HEADERS =
			"Access-Control-Expose-Headers";

		/**
		 * {@code "Access-Control-Max-Age"}
		 */
		public static final String ACCESS_CONTROL_MAX_AGE =
			"Access-Control-Max-Age";

		/**
		 * {@code "Access-Control-Request-Headers"}
		 */
		public static final String ACCESS_CONTROL_REQUEST_HEADERS =
			"Access-Control-Request-Headers";

		/**
		 * {@code "Access-Control-Request-Method"}
		 */
		public static final String ACCESS_CONTROL_REQUEST_METHOD =
			"Access-Control-Request-Method";

		/**
		 * {@code "Age"}
		 */
		public static final String AGE = "Age";

		/**
		 * {@code "Allow"}
		 */
		public static final String ALLOW = "Allow";

		/**
		 * {@code "Authorization"}
		 */
		public static final String AUTHORIZATION = "Authorization";

		/**
		 * {@code "Cache-Control"}
		 */
		public static final String CACHE_CONTROL = "Cache-Control";

		/**
		 * {@code "Connection"}
		 */
		public static final String CONNECTION = "Connection";

		/**
		 * {@code "Content-Base"}
		 */
		public static final String CONTENT_BASE = "Content-Base";

		/**
		 * {@code "Content-Encoding"}
		 */
		public static final String CONTENT_ENCODING = "Content-Encoding";

		/**
		 * {@code "Content-Language"}
		 */
		public static final String CONTENT_LANGUAGE = "Content-Language";

		/**
		 * {@code "Content-Length"}
		 */
		public static final String CONTENT_LENGTH = "Content-Length";

		/**
		 * {@code "Content-Location"}
		 */
		public static final String CONTENT_LOCATION = "Content-Location";

		/**
		 * {@code "Content-MD5"}
		 */
		public static final String CONTENT_MD5 = "Content-MD5";

		/**
		 * {@code "Content-Range"}
		 */
		public static final String CONTENT_RANGE = "Content-Range";

		/**
		 * {@code "Content-Transfer-Encoding"}
		 */
		public static final String CONTENT_TRANSFER_ENCODING =
			"Content-Transfer-Encoding";

		/**
		 * {@code "Content-Type"}
		 */
		public static final String CONTENT_TYPE = "Content-Type";

		/**
		 * {@code "Cookie"}
		 */
		public static final String COOKIE = "Cookie";

		/**
		 * {@code "Date"}
		 */
		public static final String DATE = "Date";

		/**
		 * {@code "ETag"}
		 */
		public static final String ETAG = "ETag";

		/**
		 * {@code "Expect"}
		 */
		public static final String EXPECT = "Expect";

		/**
		 * {@code "Expires"}
		 */
		public static final String EXPIRES = "Expires";

		/**
		 * {@code "From"}
		 */
		public static final String FROM = "From";

		/**
		 * {@code "Host"}
		 */
		public static final String HOST = "Host";

		/**
		 * {@code "If-Match"}
		 */
		public static final String IF_MATCH = "If-Match";

		/**
		 * {@code "If-Modified-Since"}
		 */
		public static final String IF_MODIFIED_SINCE = "If-Modified-Since";

		/**
		 * {@code "If-None-Match"}
		 */
		public static final String IF_NONE_MATCH = "If-None-Match";

		/**
		 * {@code "If-Range"}
		 */
		public static final String IF_RANGE = "If-Range";

		/**
		 * {@code "If-Unmodified-Since"}
		 */
		public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";

		/**
		 * {@code "Last-Modified"}
		 */
		public static final String LAST_MODIFIED = "Last-Modified";

		/**
		 * {@code "Location"}
		 */
		public static final String LOCATION = "Location";

		/**
		 * {@code "Max-Forwards"}
		 */
		public static final String MAX_FORWARDS = "Max-Forwards";

		/**
		 * {@code "Origin"}
		 */
		public static final String ORIGIN = "Origin";

		/**
		 * {@code "Pragma"}
		 */
		public static final String PRAGMA = "Pragma";

		/**
		 * {@code "Proxy-Authenticate"}
		 */
		public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";

		/**
		 * {@code "Proxy-Authorization"}
		 */
		public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";

		/**
		 * {@code "Range"}
		 */
		public static final String RANGE = "Range";

		/**
		 * {@code "Referer"}
		 */
		public static final String REFERER = "Referer";

		/**
		 * {@code "Retry-After"}
		 */
		public static final String RETRY_AFTER = "Retry-After";

		/**
		 * {@code "Sec-WebSocket-Accept"}
		 */
		public static final String SEC_WEBSOCKET_ACCEPT =
			"Sec-WebSocket-Accept";

		/**
		 * {@code "Sec-WebSocket-Key"}
		 */
		public static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";

		/**
		 * {@code "Sec-WebSocket-Key1"}
		 */
		public static final String SEC_WEBSOCKET_KEY1 = "Sec-WebSocket-Key1";

		/**
		 * {@code "Sec-WebSocket-Key2"}
		 */
		public static final String SEC_WEBSOCKET_KEY2 = "Sec-WebSocket-Key2";

		/**
		 * {@code "Sec-WebSocket-Location"}
		 */
		public static final String SEC_WEBSOCKET_LOCATION =
			"Sec-WebSocket-Location";

		/**
		 * {@code "Sec-WebSocket-Origin"}
		 */
		public static final String SEC_WEBSOCKET_ORIGIN =
			"Sec-WebSocket-Origin";

		/**
		 * {@code "Sec-WebSocket-Protocol"}
		 */
		public static final String SEC_WEBSOCKET_PROTOCOL =
			"Sec-WebSocket-Protocol";

		/**
		 * {@code "Sec-WebSocket-Version"}
		 */
		public static final String SEC_WEBSOCKET_VERSION =
			"Sec-WebSocket-Version";

		/**
		 * {@code "Server"}
		 */
		public static final String SERVER = "Server";

		/**
		 * {@code "Set-Cookie"}
		 */
		public static final String SET_COOKIE = "Set-Cookie";

		/**
		 * {@code "Set-Cookie2"}
		 */
		public static final String SET_COOKIE2 = "Set-Cookie2";

		/**
		 * {@code "TE"}
		 */
		public static final String TE = "TE";

		/**
		 * {@code "Trailer"}
		 */
		public static final String TRAILER = "Trailer";

		/**
		 * {@code "Transfer-Encoding"}
		 */
		public static final String TRANSFER_ENCODING = "Transfer-Encoding";

		/**
		 * {@code "Upgrade"}
		 */
		public static final String UPGRADE = "Upgrade";

		/**
		 * {@code "User-Agent"}
		 */
		public static final String USER_AGENT = "User-Agent";

		/**
		 * {@code "Vary"}
		 */
		public static final String VARY = "Vary";

		/**
		 * {@code "Via"}
		 */
		public static final String VIA = "Via";

		/**
		 * {@code "Warning"}
		 */
		public static final String WARNING = "Warning";

		/**
		 * {@code "WebSocket-Location"}
		 */
		public static final String WEBSOCKET_LOCATION = "WebSocket-Location";

		/**
		 * {@code "WebSocket-Origin"}
		 */
		public static final String WEBSOCKET_ORIGIN = "WebSocket-Origin";

		/**
		 * {@code "WebSocket-Protocol"}
		 */
		public static final String WEBSOCKET_PROTOCOL = "WebSocket-Protocol";

		/**
		 * {@code "WWW-Authenticate"}
		 */
		public static final String WWW_AUTHENTICATE = "WWW-Authenticate";

		private Names() {
		}

	}

	public static final class Values {
		/**
		 * {@code "application/x-www-form-urlencoded"}
		 */
		public static final String APPLICATION_X_WWW_FORM_URLENCODED =
			"application/x-www-form-urlencoded";

		/**
		 * {@code "base64"}
		 */
		public static final String BASE64 = "base64";

		/**
		 * {@code "binary"}
		 */
		public static final String BINARY = "binary";

		/**
		 * {@code "boundary"}
		 */
		public static final String BOUNDARY = "boundary";

		/**
		 * {@code "bytes"}
		 */
		public static final String BYTES = "bytes";

		/**
		 * {@code "charset"}
		 */
		public static final String CHARSET = "charset";

		/**
		 * {@code "chunked"}
		 */
		public static final String CHUNKED = "chunked";

		/**
		 * {@code "close"}
		 */
		public static final String CLOSE = "close";

		/**
		 * {@code "compress"}
		 */
		public static final String COMPRESS = "compress";

		/**
		 * {@code "100-continue"}
		 */
		public static final String CONTINUE = "100-continue";

		/**
		 * {@code "deflate"}
		 */
		public static final String DEFLATE = "deflate";

		/**
		 * {@code "gzip"}
		 */
		public static final String GZIP = "gzip";

		/**
		 * {@code "identity"}
		 */
		public static final String IDENTITY = "identity";

		/**
		 * {@code "keep-alive"}
		 */
		public static final String KEEP_ALIVE = "keep-alive";

		/**
		 * {@code "max-age"}
		 */
		public static final String MAX_AGE = "max-age";

		/**
		 * {@code "max-stale"}
		 */
		public static final String MAX_STALE = "max-stale";

		/**
		 * {@code "min-fresh"}
		 */
		public static final String MIN_FRESH = "min-fresh";

		/**
		 * {@code "multipart/form-data"}
		 */
		public static final String MULTIPART_FORM_DATA = "multipart/form-data";

		/**
		 * {@code "must-revalidate"}
		 */
		public static final String MUST_REVALIDATE = "must-revalidate";

		/**
		 * {@code "no-cache"}
		 */
		public static final String NO_CACHE = "no-cache";

		/**
		 * {@code "no-store"}
		 */
		public static final String NO_STORE = "no-store";

		/**
		 * {@code "no-transform"}
		 */
		public static final String NO_TRANSFORM = "no-transform";

		/**
		 * {@code "none"}
		 */
		public static final String NONE = "none";

		/**
		 * {@code "only-if-cached"}
		 */
		public static final String ONLY_IF_CACHED = "only-if-cached";

		/**
		 * {@code "private"}
		 */
		public static final String PRIVATE = "private";

		/**
		 * {@code "proxy-revalidate"}
		 */
		public static final String PROXY_REVALIDATE = "proxy-revalidate";

		/**
		 * {@code "public"}
		 */
		public static final String PUBLIC = "public";

		/**
		 * {@code "quoted-printable"}
		 */
		public static final String QUOTED_PRINTABLE = "quoted-printable";

		/**
		 * {@code "s-maxage"}
		 */
		public static final String S_MAXAGE = "s-maxage";

		/**
		 * {@code "trailers"}
		 */
		public static final String TRAILERS = "trailers";

		/**
		 * {@code "Upgrade"}
		 */
		public static final String UPGRADE = "Upgrade";

		/**
		 * {@code "WebSocket"}
		 */
		public static final String WEBSOCKET = "WebSocket";

	}

}
