/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.weicoder.cache.params.CacheParams;
import com.weicoder.common.interfaces.Calls;
import com.weicoder.common.lang.W;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class LoadCache<K, V> {
    protected LoadingCache<K, V> cache;

    protected LoadCache(Calls.EoR<K, V> load) {
        this(CacheParams.MAX, CacheParams.INIT, CacheParams.LEVEL, CacheParams.REFRESH, CacheParams.EXPIRE, load);
    }

    LoadCache(long max, int init, int level, long refresh, long expire, final Calls.EoR<K, V> load) {
        this.cache = CacheBuilder.newBuilder().maximumSize(max).initialCapacity(init).concurrencyLevel(level).refreshAfterWrite(refresh, TimeUnit.SECONDS).expireAfterAccess(expire, TimeUnit.SECONDS).build(new CacheLoader<K, V>(){

            public V load(K key) throws Exception {
                return load.call(key);
            }
        });
    }

    public V put(K key, V value) {
        this.cache.put(key, value);
        return value;
    }

    public V get(K key) {
        try {
            return (V)this.cache.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public V get(K key, Calls.EoR<K, V> call) {
        Object val = this.get(key);
        if (val == null) {
            val = call.call(key);
        }
        if (val != null) {
            this.put(key, val);
        }
        return val;
    }

    public long size() {
        return this.cache.size();
    }

    public boolean exists(K key) {
        try {
            return this.cache.get(key) != null;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public Map<K, V> map() {
        return this.cache.asMap();
    }

    public Set<K> keys() {
        return this.map().keySet();
    }

    public List<V> values() {
        return W.L.list(this.map().values());
    }

    public void clean() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    public void remove(K key) {
        this.cache.invalidate(key);
    }
}

