/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.csv;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Logs;
import com.weicoder.common.util.BeanUtil;
import com.weicoder.common.util.EmptyUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public final class CsvEngine {
    public static List<String[]> read(byte[] b) {
        return CsvEngine.read(new ByteArrayInputStream(b));
    }

    public static List<String[]> read(InputStream in) {
        return CsvEngine.read(new InputStreamReader(in));
    }

    public static List<String[]> read(Reader reader) {
        List list;
        CSVReader csv = new CSVReader(reader);
        try {
            list = csv.readAll();
        }
        catch (Throwable throwable) {
            try {
                try {
                    csv.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Logs.warn((Throwable)e);
                return Lists.emptyList();
            }
        }
        csv.close();
        return list;
    }

    public static <E> List<E> read(byte[] b, Class<E> entityClass) {
        return CsvEngine.read(new ByteArrayInputStream(b), entityClass);
    }

    public static <E> List<E> read(InputStream in, Class<E> entityClass) {
        return CsvEngine.read(new InputStreamReader(in), entityClass);
    }

    public static <E> List<E> read(Reader reader, Class<E> entityClass) {
        List<String[]> list = CsvEngine.read(reader);
        if (EmptyUtil.isEmpty(list)) {
            return Lists.emptyList();
        }
        int size = list.size();
        Object[] cols = list.get(0);
        List entitys = Lists.newList((int)list.size());
        for (int i = 1; i < size; ++i) {
            entitys.add(BeanUtil.copy((Map)Maps.newMap((Object[])cols, (Object[])list.get(i)), entityClass));
        }
        return entitys;
    }

    public static void write(OutputStream out, List<String[]> list) {
        CsvEngine.write(new OutputStreamWriter(out), list);
    }

    public static void write(Writer writer, List<String[]> list) {
        try (CSVWriter csv = new CSVWriter(writer);){
            csv.writeAll(list);
        }
        catch (Exception e) {
            Logs.warn((Throwable)e);
        }
    }

    private CsvEngine() {
    }
}

