/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.http;

import com.weicoder.common.constants.SystemConstants;
import com.weicoder.common.interfaces.Callback;
import com.weicoder.common.io.IOUtil;
import com.weicoder.common.lang.C;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.CloseUtil;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.common.util.StringUtil;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.nio.reactor.IOReactorException;

public final class HttpAsyncClient {
    private static final Log LOG = LogFactory.getLog(HttpAsyncClient.class);
    static final CloseableHttpAsyncClient CLIENT;

    public static void get(String url, Callback<String> callback) {
        HttpAsyncClient.get(url, callback, CommonParams.ENCODING);
    }

    public static void get(String url, Callback<String> callback, String charset) {
        HttpAsyncClient.download(url, (Callback<byte[]>)((Callback)result -> {
            if (callback != null) {
                callback.callback((Object)StringUtil.toString((byte[])result, (String)charset));
            }
            return result;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String url, final Callback<byte[]> callback) {
        HttpGet get = null;
        try {
            get = new HttpGet(url);
            get.addHeader(new BasicHeader("Content-Type", "application/x-www-form-urlencoded"));
            CLIENT.execute(get, new FutureCallback<HttpResponse>(){

                @Override
                public void failed(Exception ex) {
                    LOG.error((Throwable)ex);
                }

                @Override
                public void completed(HttpResponse result) {
                    if (callback != null) {
                        try (InputStream in = result.getEntity().getContent();){
                            callback.callback((Object)IOUtil.read((InputStream)in));
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }

                @Override
                public void cancelled() {
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public static void post(String url, Map<String, Object> data, Callback<String> callback) {
        HttpAsyncClient.post(url, data, callback, CommonParams.ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void post(String url, Map<String, Object> data, final Callback<String> callback, String charset) {
        HttpPost post = null;
        try {
            post = new HttpPost(url);
            post.addHeader(new BasicHeader("Content-Type", "application/x-www-form-urlencoded"));
            if (EmptyUtil.isNotEmpty(data)) {
                List list = Lists.newList((int)data.size());
                data.forEach((k, v) -> list.add(new BasicNameValuePair((String)k, C.toString((Object)v))));
                post.setEntity(new UrlEncodedFormEntity(list, charset));
            }
            CLIENT.execute(post, new FutureCallback<HttpResponse>(){

                @Override
                public void failed(Exception ex) {
                    LOG.error((Throwable)ex);
                }

                @Override
                public void completed(HttpResponse result) {
                    if (callback != null) {
                        try (InputStream in = result.getEntity().getContent();){
                            callback.callback((Object)IOUtil.readString((InputStream)in));
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }

                @Override
                public void cancelled() {
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public static void close() {
        CloseUtil.close((AutoCloseable[])new AutoCloseable[]{CLIENT});
    }

    private HttpAsyncClient() {
    }

    static {
        PoolingNHttpClientConnectionManager pool = null;
        try {
            pool = new PoolingNHttpClientConnectionManager(new DefaultConnectingIOReactor());
        }
        catch (IOReactorException e) {
            LOG.error((Throwable)e);
        }
        pool.setDefaultMaxPerRoute(SystemConstants.CPU_NUM * 10);
        pool.setMaxTotal(SystemConstants.CPU_NUM * 10);
        RequestConfig.Builder config = RequestConfig.custom();
        config.setSocketTimeout(2000);
        config.setConnectTimeout(2000);
        config.setCircularRedirectsAllowed(false);
        HttpAsyncClientBuilder builder = HttpAsyncClientBuilder.create();
        builder.setDefaultRequestConfig(config.build());
        builder.setConnectionManager(pool);
        builder.setMaxConnPerRoute(SystemConstants.CPU_NUM * 10);
        List headers = Lists.newList();
        headers.add(new BasicHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; nl; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13"));
        headers.add(new BasicHeader("Accept", "text/xml,text/javascript,application/json,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5"));
        headers.add(new BasicHeader("Accept-Language", "zh-cn,zh;q=0.5"));
        headers.add(new BasicHeader("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7"));
        builder.setDefaultHeaders(headers);
        builder.setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(Charset.forName(CommonParams.ENCODING)).build());
        CLIENT = builder.build();
        CLIENT.start();
    }
}

