/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.http;

import com.weicoder.common.io.IOUtil;
import com.weicoder.common.lang.C;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.http.HttpClient;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class HttpUpload {
    private static final Log LOG = LogFactory.getLog(HttpUpload.class);

    public static String upload(String url, File ... files) {
        return HttpUpload.upload(url, null, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(String url, Map<String, Object> data, File ... files) {
        if (EmptyUtil.isEmpty((String)url) || EmptyUtil.isEmpty((Object[])files)) {
            return "";
        }
        HttpPost post = null;
        try {
            post = new HttpPost(url);
            if (EmptyUtil.isNotEmpty(data)) {
                List list = Lists.newList((int)data.size());
                data.forEach((k, v) -> list.add(new BasicNameValuePair((String)k, C.toString((Object)v))));
                post.setEntity(new UrlEncodedFormEntity(list, CommonParams.ENCODING));
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (File file : files) {
                builder.addBinaryBody(file.getName(), file);
            }
            post.setEntity(builder.build());
            CloseableHttpResponse response = HttpClient.CLIENT.execute(post);
            String string = IOUtil.readString((InputStream)response.getEntity().getContent());
            return string;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (post != null) {
                post.abort();
            }
        }
        return "";
    }

    public static String upload(String url, String name, byte[] b) {
        return HttpUpload.upload(url, null, name, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(String url, Map<String, Object> data, String name, byte[] b) {
        if (EmptyUtil.isEmpty((String)url) || EmptyUtil.isEmpty((byte[])b)) {
            return "";
        }
        HttpPost post = null;
        try {
            post = new HttpPost(url);
            post.addHeader(new BasicHeader("Content-Type", "multipart/form-data"));
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addBinaryBody(name, b);
            if (EmptyUtil.isNotEmpty(data)) {
                data.forEach((k, v) -> builder.addTextBody((String)k, C.toString((Object)v)));
            }
            post.setEntity(builder.build());
            CloseableHttpResponse response = HttpClient.CLIENT.execute(post);
            String string = IOUtil.readString((InputStream)response.getEntity().getContent());
            return string;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (post != null) {
                post.abort();
            }
        }
        return "";
    }
}

