/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.httpclient;

import com.weicoder.common.U;
import com.weicoder.common.W;
import com.weicoder.common.bean.StateCode;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.constants.SystemConstants;
import com.weicoder.common.http.params.HttpParams;
import com.weicoder.common.io.IOUtil;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.BeanUtil;
import com.weicoder.common.util.StringUtil;
import com.weicoder.json.JsonEngine;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.util.Timeout;

public final class HttpClient {
    private static final Log LOG = LogFactory.getLog(HttpClient.class);
    static final CloseableHttpClient CLIENT = HttpClient.init();

    public static CloseableHttpClient getClient() {
        return CLIENT;
    }

    public static String get(String url) {
        return HttpClient.get(url, CommonParams.ENCODING);
    }

    public static StateCode getToState(String url) {
        return (StateCode)JsonEngine.toBean((String)HttpClient.get(url, CommonParams.ENCODING), StateCode.class);
    }

    public static <E> E get(String url, Class<E> c) {
        return (E)JsonEngine.toBean((String)HttpClient.get(url, CommonParams.ENCODING), c);
    }

    public static String get(String url, String charset) {
        return StringUtil.toString((byte[])HttpClient.download(url), (String)charset);
    }

    public static byte[] download(String url) {
        HttpGet get = null;
        try {
            LOG.debug("HttpClient get url={}", new Object[]{url});
            get = new HttpGet(url);
            byte[] byArray = IOUtil.read((InputStream)CLIENT.execute((ClassicHttpRequest)get).getEntity().getContent());
            return byArray;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (get != null) {
                get.abort();
            }
        }
        return ArrayConstants.BYTES_EMPTY;
    }

    public static StateCode post(String url, Object data) {
        return HttpClient.post(url, data, StateCode.class);
    }

    public static <E> E post(String url, Object data, Class<E> c) {
        Map params = Maps.newMap();
        BeanUtil.copy((Object)data, (Object)params);
        return (E)JsonEngine.toBean((String)HttpClient.post(url, (Map<String, String>)params, CommonParams.ENCODING), c);
    }

    public static String post(String url, Map<String, String> data) {
        return HttpClient.post(url, data, CommonParams.ENCODING);
    }

    public static String post(String url, Map<String, String> data, Map<String, String> header) {
        return HttpClient.post(url, data, header, CommonParams.ENCODING);
    }

    public static String post(String url, Map<String, String> data, String charset) {
        return HttpClient.post(url, data, Maps.emptyMap(), charset);
    }

    public static String post(String url, Map<String, String> data, Map<String, String> header, String charset) {
        try {
            HttpPost post = new HttpPost(url);
            if (U.E.isNotEmpty(data)) {
                List list = Lists.newList((int)data.size());
                data.forEach((k, v) -> list.add(new BasicNameValuePair(k, W.C.toString((Object)v))));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
            }
            if (U.E.isNotEmpty(header)) {
                header.forEach((k, v) -> post.addHeader(k, v));
            }
            LOG.debug("HttpClient post url={} data={} header={} charset={}", new Object[]{url, data, header, charset});
            return IOUtil.readString((InputStream)CLIENT.execute((ClassicHttpRequest)post).getEntity().getContent());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return "";
        }
    }

    private static CloseableHttpClient init() {
        PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager();
        pool.setDefaultMaxPerRoute(SystemConstants.CPU_NUM);
        pool.setMaxTotal(HttpParams.HTTP_MAX);
        RequestConfig.Builder config = RequestConfig.custom();
        config.setConnectionRequestTimeout(Timeout.ofSeconds((long)W.C.toLong((Object)HttpParams.HTTP_TIMEOUT)));
        config.setConnectTimeout(Timeout.ofSeconds((long)W.C.toLong((Object)HttpParams.HTTP_TIMEOUT)));
        config.setCircularRedirectsAllowed(false);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(config.build());
        builder.setConnectionManager((HttpClientConnectionManager)pool);
        List headers = Lists.newList();
        headers.add(new BasicHeader("User-Agent", (Object)"Mozilla/5.0 (Windows; U; Windows NT 5.1; nl; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13"));
        headers.add(new BasicHeader("Accept", (Object)"text/xml,text/javascript,application/json,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5"));
        builder.setDefaultHeaders((Collection)headers);
        return builder.build();
    }

    private HttpClient() {
    }
}

