/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.httpclient;

import com.weicoder.common.U;
import com.weicoder.common.W;
import com.weicoder.common.constants.SystemConstants;
import com.weicoder.common.http.params.HttpParams;
import com.weicoder.common.interfaces.CallbackVoid;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.CloseUtil;
import com.weicoder.common.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.util.Timeout;

public final class HttpAsyncClient {
    private static final Log LOG = LogFactory.getLog(HttpAsyncClient.class);
    static final CloseableHttpAsyncClient CLIENT;

    public static void get(String url, CallbackVoid<String> callback) {
        HttpAsyncClient.get(url, callback, CommonParams.ENCODING);
    }

    public static void get(String url, CallbackVoid<String> callback, String charset) {
        HttpAsyncClient.download(url, (CallbackVoid<byte[]>)((CallbackVoid)result -> {
            if (callback != null) {
                callback.callback((Object)StringUtil.toString((byte[])result, (String)charset));
            }
        }));
    }

    public static void download(String url, final CallbackVoid<byte[]> callback) {
        HttpGet get = null;
        try {
            get = new HttpGet(url);
            get.addHeader((Header)new BasicHeader("Content-Type", (Object)"application/x-www-form-urlencoded"));
            CLIENT.execute(SimpleRequestBuilder.copy((HttpRequest)get).build(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void failed(Exception ex) {
                    LOG.error((Throwable)ex);
                }

                public void completed(SimpleHttpResponse result) {
                    if (callback != null) {
                        callback.callback((Object)result.getBodyBytes());
                    }
                }

                public void cancelled() {
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public static void post(String url, Map<String, Object> data, CallbackVoid<String> callback) {
        HttpAsyncClient.post(url, data, callback, CommonParams.ENCODING);
    }

    public static void post(String url, Map<String, Object> data, final CallbackVoid<String> callback, String charset) {
        HttpPost post = null;
        try {
            post = new HttpPost(url);
            post.addHeader((Header)new BasicHeader("Content-Type", (Object)"application/x-www-form-urlencoded"));
            if (U.E.isNotEmpty(data)) {
                List list = Lists.newList((int)data.size());
                data.forEach((k, v) -> list.add(new BasicNameValuePair(k, W.C.toString((Object)v))));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
            }
            CLIENT.execute(SimpleRequestBuilder.copy((HttpRequest)post).build(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void failed(Exception ex) {
                    LOG.error((Throwable)ex);
                }

                public void completed(SimpleHttpResponse result) {
                    if (callback != null) {
                        callback.callback((Object)result.getBodyText());
                    }
                }

                public void cancelled() {
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public static void close() {
        CloseUtil.close((AutoCloseable[])new AutoCloseable[]{CLIENT});
    }

    private HttpAsyncClient() {
    }

    static {
        PoolingAsyncClientConnectionManager pool = new PoolingAsyncClientConnectionManager();
        pool.setDefaultMaxPerRoute(SystemConstants.CPU_NUM);
        pool.setMaxTotal(HttpParams.HTTP_MAX);
        RequestConfig.Builder config = RequestConfig.custom();
        config.setConnectionRequestTimeout(Timeout.ofSeconds((long)W.C.toLong((Object)HttpParams.HTTP_TIMEOUT)));
        config.setConnectTimeout(Timeout.ofSeconds((long)W.C.toLong((Object)HttpParams.HTTP_TIMEOUT)));
        config.setCircularRedirectsAllowed(false);
        HttpAsyncClientBuilder builder = HttpAsyncClientBuilder.create();
        builder.setDefaultRequestConfig(config.build());
        builder.setConnectionManager((AsyncClientConnectionManager)pool);
        List headers = Lists.newList();
        headers.add(new BasicHeader("User-Agent", (Object)"Mozilla/5.0 (Windows; U; Windows NT 5.1; nl; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13"));
        headers.add(new BasicHeader("Accept", (Object)"text/xml,text/javascript,application/json,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5"));
        headers.add(new BasicHeader("Accept-Language", (Object)"zh-cn,zh;q=0.5"));
        headers.add(new BasicHeader("Accept-Charset", (Object)"ISO-8859-1,utf-8;q=0.7,*;q=0.7"));
        builder.setDefaultHeaders((Collection)headers);
        CLIENT = builder.build();
        CLIENT.start();
    }
}

