/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.httpclient;

import com.weicoder.common.C;
import com.weicoder.common.U;
import com.weicoder.common.W;
import com.weicoder.common.http.base.BaseHttp;
import com.weicoder.common.http.params.HttpParams;
import com.weicoder.common.io.IOUtil;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.log.Logs;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.util.Timeout;

public class HttpClient5
extends BaseHttp {
    static final CloseableHttpClient CLIENT = HttpClient5.init();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] download(String url, Map<String, Object> header) {
        HttpGet get = null;
        try {
            Logs.debug((String)"HttpClient5 get url={}", (Object[])new Object[]{url});
            get = new HttpGet(url);
            byte[] byArray = IOUtil.read((InputStream)CLIENT.execute((ClassicHttpRequest)get).getEntity().getContent());
            return byArray;
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
        finally {
            if (get != null) {
                get.abort();
            }
        }
        return C.A.BYTES_EMPTY;
    }

    public String post(String url, Map<String, Object> data, Map<String, Object> header) {
        try {
            HttpPost post = new HttpPost(url);
            if (U.E.isNotEmpty(data)) {
                List list = Lists.newList((int)data.size());
                data.forEach((k, v) -> list.add(new BasicNameValuePair(k, W.C.toString((Object)v))));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
            }
            if (U.E.isNotEmpty(header)) {
                header.forEach((k, v) -> post.addHeader(k, v));
            }
            Logs.debug((String)"HttpClient post url={} data={} header={}", (Object[])new Object[]{url, data, header});
            return U.I.readString((InputStream)CLIENT.execute((ClassicHttpRequest)post).getEntity().getContent());
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
            return "";
        }
    }

    private static CloseableHttpClient init() {
        PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager();
        pool.setDefaultMaxPerRoute(C.O.CPU_NUM);
        pool.setMaxTotal(HttpParams.HTTP_MAX);
        RequestConfig.Builder config = RequestConfig.custom();
        config.setConnectionRequestTimeout(Timeout.ofSeconds((long)W.C.toLong((Object)HttpParams.HTTP_TIMEOUT)));
        config.setConnectTimeout(Timeout.ofSeconds((long)W.C.toLong((Object)HttpParams.HTTP_TIMEOUT)));
        config.setCircularRedirectsAllowed(false);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(config.build());
        builder.setConnectionManager((HttpClientConnectionManager)pool);
        List headers = Lists.newList();
        headers.add(new BasicHeader("User-Agent", (Object)"Mozilla/5.0 (Windows; U; Windows NT 5.1; nl; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13"));
        headers.add(new BasicHeader("Accept", (Object)"text/xml,text/javascript,application/json,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5"));
        builder.setDefaultHeaders((Collection)headers);
        return builder.build();
    }
}

