/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.httpclient;

import com.weicoder.common.constants.C;
import com.weicoder.common.interfaces.Calls;
import com.weicoder.common.lang.W;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import com.weicoder.common.params.P;
import com.weicoder.common.statics.S;
import com.weicoder.common.util.U;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.util.Timeout;

public final class HttpAsyncClient {
    private static final Log LOG = LogFactory.getLog(HttpAsyncClient.class);
    static final CloseableHttpAsyncClient CLIENT;

    public static void get(String url, Calls.EoV<String> callback) {
        HttpAsyncClient.get(url, callback, P.C.ENCODING);
    }

    public static void get(String url, Calls.EoV<String> callback, String charset) {
        HttpAsyncClient.download(url, (Calls.EoV<byte[]>)((Calls.EoV)result -> {
            if (callback != null) {
                callback.call((Object)U.S.toString((byte[])result, (String)charset));
            }
        }));
    }

    public static void download(String url, final Calls.EoV<byte[]> callback) {
        HttpGet get = null;
        try {
            get = new HttpGet(url);
            get.addHeader((Header)new BasicHeader("Content-Type", (Object)"application/x-www-form-urlencoded"));
            CLIENT.execute(SimpleRequestBuilder.copy((HttpRequest)get).build(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void failed(Exception ex) {
                    LOG.error((Throwable)ex);
                }

                public void completed(SimpleHttpResponse result) {
                    if (callback != null) {
                        callback.call((Object)result.getBodyBytes());
                    }
                }

                public void cancelled() {
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public static void post(String url, Map<String, Object> data, Calls.EoV<String> callback) {
        HttpAsyncClient.post(url, data, callback, P.C.ENCODING);
    }

    public static void post(String url, Map<String, Object> data, final Calls.EoV<String> callback, String charset) {
        HttpPost post = null;
        try {
            post = new HttpPost(url);
            post.addHeader((Header)new BasicHeader("Content-Type", (Object)"application/x-www-form-urlencoded"));
            if (U.E.isNotEmpty(data)) {
                List list = W.L.list((int)data.size());
                data.forEach((k, v) -> list.add(new BasicNameValuePair(k, W.C.toString((Object)v))));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
            }
            CLIENT.execute(SimpleRequestBuilder.copy((HttpRequest)post).build(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void failed(Exception ex) {
                    LOG.error((Throwable)ex);
                }

                public void completed(SimpleHttpResponse result) {
                    if (callback != null) {
                        callback.call((Object)result.getBodyText());
                    }
                }

                public void cancelled() {
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public static void close() {
        S.C.close((AutoCloseable[])new AutoCloseable[]{CLIENT});
    }

    private HttpAsyncClient() {
    }

    static {
        PoolingAsyncClientConnectionManager pool = new PoolingAsyncClientConnectionManager();
        pool.setDefaultMaxPerRoute(C.O.CPU_NUM);
        pool.setMaxTotal(P.H.MAX);
        RequestConfig.Builder config = RequestConfig.custom();
        config.setConnectionRequestTimeout(Timeout.ofSeconds((long)W.C.toLong((Object)P.H.TIMEOUT)));
        config.setResponseTimeout(Timeout.ofSeconds((long)W.C.toLong((Object)P.H.TIMEOUT)));
        config.setCircularRedirectsAllowed(false);
        HttpAsyncClientBuilder builder = HttpAsyncClientBuilder.create();
        builder.setDefaultRequestConfig(config.build());
        builder.setConnectionManager((AsyncClientConnectionManager)pool);
        List headers = W.L.list();
        headers.add(new BasicHeader("User-Agent", (Object)"Mozilla/5.0 (Windows; U; Windows NT 5.1; nl; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13"));
        headers.add(new BasicHeader("Accept", (Object)"text/xml,text/javascript,application/json,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5"));
        headers.add(new BasicHeader("Accept-Language", (Object)"zh-cn,zh;q=0.5"));
        headers.add(new BasicHeader("Accept-Charset", (Object)"ISO-8859-1,utf-8;q=0.7,*;q=0.7"));
        builder.setDefaultHeaders((Collection)headers);
        CLIENT = builder.build();
        CLIENT.start();
    }
}

