/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.httpclient;

import com.weicoder.common.lang.W;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import com.weicoder.common.util.U;
import com.weicoder.httpclient.HttpClient;
import com.weicoder.httpclient.HttpCommons;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class HttpUpload {
    private static final Log LOG = LogFactory.getLog(HttpUpload.class);

    public static String upload(String url, File ... files) {
        return HttpUpload.upload(url, null, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(String url, Map<String, Object> data, File ... files) {
        if (U.E.isEmpty((String)url) || U.E.isEmpty((Object[])files)) {
            return "";
        }
        HttpPost post = null;
        try {
            post = new HttpPost(url);
            if (U.E.isNotEmpty(data)) {
                List list = W.L.list((int)data.size());
                data.forEach((k, v) -> list.add(new BasicNameValuePair(k, W.C.toString((Object)v))));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.EXTENDED);
            for (File file : files) {
                builder.addBinaryBody(file.getName(), file);
            }
            post.setEntity(builder.build());
            String string = (String)HttpClient.CLIENT.execute((ClassicHttpRequest)post, HttpCommons.HCRHS);
            return string;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (post != null) {
                post.abort();
            }
        }
        return "";
    }

    public static String upload(String url, String name, byte[] b) {
        return HttpUpload.upload(url, null, name, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(String url, Map<String, Object> data, String name, byte[] b) {
        if (U.E.isEmpty((String)url) || U.E.isEmpty((byte[])b)) {
            return "";
        }
        HttpPost post = null;
        try {
            post = new HttpPost(url);
            post.addHeader((Header)new BasicHeader("Content-Type", (Object)"multipart/form-data"));
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.EXTENDED);
            builder.addBinaryBody(name, b);
            if (U.E.isNotEmpty(data)) {
                data.forEach((k, v) -> builder.addTextBody(k, W.C.toString((Object)v)));
            }
            post.setEntity(builder.build());
            String string = (String)HttpClient.CLIENT.execute((ClassicHttpRequest)post, HttpCommons.HCRHS);
            return string;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (post != null) {
                post.abort();
            }
        }
        return "";
    }
}

