/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.memcache.impl;

import com.weicoder.common.lang.Lists;
import com.weicoder.common.util.ArrayUtil;
import com.weicoder.memcache.Memcache;
import com.weicoder.memcache.base.BaseMemcache;
import com.weicoder.memcache.factory.MemcacheFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class MemcacheArray
extends BaseMemcache {
    private Memcache[] clients;
    private ExecutorService service;
    private List<ClientEntity> ces;

    public MemcacheArray(String[] names) {
        int i;
        int num = names.length;
        this.clients = (Memcache[])ArrayUtil.getArray(Memcache.class, (int)num);
        for (i = 0; i < num; ++i) {
            this.clients[i] = MemcacheFactory.getMemcache(names[i]);
        }
        this.service = Executors.newFixedThreadPool(num);
        this.ces = Lists.newList((int)num);
        for (i = 0; i < num; ++i) {
            this.ces.add(new ClientEntity(i));
        }
    }

    @Override
    public Object get(String key) {
        return this.getMemCacheClient().get(key);
    }

    @Override
    public Object[] get(String ... keys) {
        return this.getMemCacheClient().get(keys);
    }

    @Override
    public Map<String, Object> newMap(String ... keys) {
        return this.getMemCacheClient().newMap(keys);
    }

    @Override
    public void remove(String ... key) {
        for (int i = 0; i < this.clients.length; ++i) {
            this.clients[i].remove(key);
        }
    }

    @Override
    public boolean set(final String key, final Object value) {
        int i = 0;
        while (i < this.clients.length) {
            final int n = i++;
            this.service.execute(new Runnable(){

                @Override
                public void run() {
                    MemcacheArray.this.clients[n].set(key, value);
                }
            });
        }
        return true;
    }

    @Override
    public boolean append(final String key, final Object value) {
        int i = 0;
        while (i < this.clients.length) {
            final int n = i++;
            this.service.execute(new Runnable(){

                @Override
                public void run() {
                    MemcacheArray.this.clients[n].append(key, value);
                }
            });
        }
        return true;
    }

    @Override
    public boolean exists(String key) {
        return this.clients[0].exists(key);
    }

    protected Memcache getMemCacheClient() {
        Lists.sort(this.ces);
        ClientEntity ce = this.ces.get(0);
        ce.setNum(ce.getNum() + 1);
        return this.clients[ce.getFlag()];
    }

    @Override
    protected void init(String name, String[] servers, Integer[] weights, int initConn, int minConn, int maxConn, long maxIdle, long maintSleep, int socketTO, int socketConnectTO, boolean binary) {
    }

    class ClientEntity
    implements Comparable<ClientEntity> {
        private int flag;
        private int num;

        public ClientEntity(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        public void setFlag(int flag) {
            this.flag = flag;
        }

        public int getNum() {
            return this.num;
        }

        public void setNum(int num) {
            this.num = num;
        }

        @Override
        public int compareTo(ClientEntity o) {
            return this.num > o.getNum() ? 1 : -1;
        }
    }
}

