/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.memcache.params;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.params.Params;
import com.weicoder.common.util.ArrayUtil;

public final class MemcacheParams {
    public static final String[] NAMES = Params.getStringArray((String)"memcache.names", (String[])ArrayConstants.STRING_EMPTY);

    public static boolean getBinary(String name) {
        return Params.getBoolean((String)MemcacheParams.getKey(name, "binary"), (boolean)false);
    }

    public static String getParse(String name) {
        return Params.getString((String)MemcacheParams.getKey(name, "parse"), (String)"java");
    }

    public static String[] getServers(String name) {
        return Params.getStringArray((String)MemcacheParams.getKey(name, "server"), (String[])new String[]{"127.0.0.1:11211"});
    }

    public static Integer[] getWeights(String name) {
        return ArrayUtil.toInteger((String[])Params.getStringArray((String)MemcacheParams.getKey(name, "weight"), (String[])new String[]{"1"}));
    }

    public static int getInitConn(String name) {
        return Params.getInt((String)MemcacheParams.getKey(name, "initConn"), (int)10);
    }

    public static int getMinConn(String name) {
        return Params.getInt((String)MemcacheParams.getKey(name, "minConn"), (int)10);
    }

    public static int getMaxConn(String name) {
        return Params.getInt((String)MemcacheParams.getKey(name, "maxConn"), (int)30);
    }

    public static long getMaxIdle(String name) {
        return Params.getLong((String)MemcacheParams.getKey(name, "maxIdle"), (long)3000L);
    }

    public static long getSleep(String name) {
        return Params.getLong((String)MemcacheParams.getKey(name, "sleep"), (long)30L);
    }

    public static int getTO(String name) {
        return Params.getInt((String)MemcacheParams.getKey(name, "to"), (int)3000);
    }

    public static int getConnectTO(String name) {
        return Params.getInt((String)MemcacheParams.getKey(name, "connectTO"), (int)3000);
    }

    private static String getKey(String name, String key) {
        return Params.getKey((String)"memcache", (String)name, (String)key);
    }

    private MemcacheParams() {
    }
}

