/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.ByteBufArrayInputStream;
import com.schooner.MemCached.MemcachedItem;
import com.schooner.MemCached.NativeHandler;
import com.schooner.MemCached.ObjectTransCoder;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.SchoonerSockIOPool;
import com.schooner.MemCached.SockInputStream;
import com.schooner.MemCached.SockOutputStream;
import com.schooner.MemCached.TransCoder;
import com.schooner.MemCached.command.DeletionCommand;
import com.whalin.MemCached.ErrorHandler;
import com.whalin.MemCached.LineInputStream;
import com.whalin.MemCached.MemCachedClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AscIIClient
extends MemCachedClient {
    private static final Logger LOG = LogManager.getLogger(DeletionCommand.class);
    private TransCoder transCoder = new ObjectTransCoder();
    private SchoonerSockIOPool pool;
    private String poolName;
    private boolean sanitizeKeys;
    private boolean primitiveAsString;
    private boolean compressEnable;
    private long compressThreshold;
    private String defaultEncoding;

    @Override
    public boolean isUseBinaryProtocol() {
        return false;
    }

    public AscIIClient() {
        this((String)null);
    }

    public AscIIClient(String poolName) {
        super((MemCachedClient)null);
        this.poolName = poolName;
        this.init();
    }

    public AscIIClient(String poolName, ClassLoader cl, ErrorHandler eh) {
        super((MemCachedClient)null);
        this.poolName = poolName;
        this.classLoader = cl;
        this.errorHandler = eh;
        this.init();
    }

    private void init() {
        this.sanitizeKeys = true;
        this.primitiveAsString = false;
        this.compressEnable = false;
        this.compressThreshold = 30720L;
        this.defaultEncoding = "UTF-8";
        this.poolName = this.poolName == null ? "default" : this.poolName;
        this.pool = SchoonerSockIOPool.getInstance(this.poolName);
    }

    @Override
    public boolean keyExists(String key) {
        return this.get(key, null) != null;
    }

    @Override
    public boolean delete(String key) {
        return this.delete(key, null, null);
    }

    @Override
    public boolean delete(String key, Date expiry) {
        return this.delete(key, null, expiry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String key, Integer hashCode, Date expiry) {
        if (key == null) {
            LOG.error("null value for key passed to delete()");
            return false;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, e, key);
            }
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return false;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, new IOException("no socket to server available"), key);
            }
            return false;
        }
        StringBuilder command = new StringBuilder("delete ").append(key);
        if (expiry != null) {
            command.append(" " + expiry.getTime() / 1000L);
        }
        command.append("\r\n");
        try {
            sock.write(command.toString().getBytes());
            SockInputStream sis = new SockInputStream(sock, Integer.MAX_VALUE);
            String line = sis.getLine();
            sis.close();
            if ("DELETED\r\n".equals(line)) {
                LOG.debug(new StringBuffer().append("++++ deletion of key: ").append(key).append(" from cache was a success").toString());
                boolean bl = true;
                return bl;
            }
            if ("NOT_FOUND\r\n".equals(line)) {
                LOG.debug(new StringBuffer().append("++++ deletion of key: ").append(key).append(" from cache failed as the key was not found").toString());
            } else {
                LOG.error(new StringBuffer().append("++++ error deleting key: ").append(key).toString());
                LOG.error(new StringBuffer().append("++++ server response: ").append(line).toString());
            }
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, e, key);
            }
            LOG.error("++++ exception thrown while writing bytes to server on delete");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString());
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return false;
    }

    @Override
    public boolean set(String key, Object value) {
        return this.set("set", key, value, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean set(String key, Object value, Integer hashCode) {
        return this.set("set", key, value, null, hashCode, 0L, this.primitiveAsString);
    }

    @Override
    public boolean set(String key, Object value, Date expiry) {
        return this.set("set", key, value, expiry, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean set(String key, Object value, Date expiry, Integer hashCode) {
        return this.set("set", key, value, expiry, hashCode, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String key, Object value) {
        return this.set("add", key, value, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String key, Object value, Integer hashCode) {
        return this.set("add", key, value, null, hashCode, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String key, Object value, Date expiry) {
        return this.set("add", key, value, expiry, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String key, Object value, Date expiry, Integer hashCode) {
        return this.set("add", key, value, expiry, hashCode, 0L, this.primitiveAsString);
    }

    @Override
    public boolean append(String key, Object value, Integer hashCode) {
        return this.set("append", key, value, null, hashCode, 0L, this.primitiveAsString);
    }

    @Override
    public boolean append(String key, Object value) {
        return this.set("append", key, value, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean cas(String key, Object value, Integer hashCode, long casUnique) {
        return this.set("cas", key, value, null, hashCode, casUnique, this.primitiveAsString);
    }

    @Override
    public boolean cas(String key, Object value, Date expiry, long casUnique) {
        return this.set("cas", key, value, expiry, null, casUnique, this.primitiveAsString);
    }

    @Override
    public boolean cas(String key, Object value, Date expiry, Integer hashCode, long casUnique) {
        return this.set("cas", key, value, expiry, hashCode, casUnique, this.primitiveAsString);
    }

    @Override
    public boolean cas(String key, Object value, long casUnique) {
        return this.set("cas", key, value, null, null, casUnique, this.primitiveAsString);
    }

    @Override
    public boolean prepend(String key, Object value, Integer hashCode) {
        return this.set("prepend", key, value, null, hashCode, 0L, this.primitiveAsString);
    }

    @Override
    public boolean prepend(String key, Object value) {
        return this.set("prepend", key, value, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String key, Object value) {
        return this.set("replace", key, value, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String key, Object value, Integer hashCode) {
        return this.set("replace", key, value, null, hashCode, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String key, Object value, Date expiry) {
        return this.set("replace", key, value, expiry, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String key, Object value, Date expiry, Integer hashCode) {
        return this.set("replace", key, value, expiry, hashCode, 0L, this.primitiveAsString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean set(String cmdname, String key, Object value, Date expiry, Integer hashCode, Long casUnique, boolean asString) {
        if (cmdname == null || key == null) {
            LOG.error("key is null or cmd is null/empty for set()");
            return false;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return false;
        }
        if (value == null) {
            LOG.error("trying to store a null value to cache");
            return false;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), key);
            }
            return false;
        }
        if (expiry == null) {
            expiry = new Date(0L);
        }
        int flags = asString ? 32 : NativeHandler.getMarkerFlag(value);
        String cmd = new StringBuffer().append(cmdname).append(" ").append(key).append(" ").append(flags).append(" ").append(expiry.getTime() / 1000L).append(" ").toString();
        try {
            sock.writeBuf.clear();
            sock.writeBuf.put(cmd.getBytes());
            int offset = sock.writeBuf.position();
            sock.writeBuf.put(this.BLAND_DATA_SIZE);
            if (casUnique != 0L) {
                sock.writeBuf.put((" " + casUnique.toString()).getBytes());
            }
            sock.writeBuf.put(B_RETURN);
            SockOutputStream output = new SockOutputStream(sock);
            int valLen = 0;
            if (flags != 0) {
                byte[] b = asString ? value.toString().getBytes(this.defaultEncoding) : NativeHandler.encode(value);
                output.write(b);
                valLen = b.length;
            } else {
                valLen = this.transCoder.encode(output, value);
            }
            sock.writeBuf.put(B_RETURN);
            byte[] objectSize = Integer.valueOf(valLen).toString().getBytes();
            int oldPosition = sock.writeBuf.position();
            sock.writeBuf.position(offset);
            sock.writeBuf.put(objectSize);
            sock.writeBuf.position(oldPosition);
            sock.flush();
            SockInputStream sis = new SockInputStream(sock, Integer.MAX_VALUE);
            String line = sis.getLine();
            sis.close();
            if ("STORED\r\n".equals(line)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            LOG.error("++++ exception thrown while writing bytes to server on set");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString());
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return false;
    }

    @Override
    public long addOrIncr(String key) {
        return this.addOrIncr(key, 0L, null);
    }

    @Override
    public long addOrIncr(String key, long inc) {
        return this.addOrIncr(key, inc, null);
    }

    @Override
    public long addOrIncr(String key, long inc, Integer hashCode) {
        boolean ret = this.add(key, (Object)("" + inc), hashCode);
        if (ret) {
            return inc;
        }
        return this.incrdecr("incr", key, inc, hashCode);
    }

    @Override
    public long addOrDecr(String key) {
        return this.addOrDecr(key, 0L, null);
    }

    @Override
    public long addOrDecr(String key, long inc) {
        return this.addOrDecr(key, inc, null);
    }

    @Override
    public long addOrDecr(String key, long inc, Integer hashCode) {
        boolean ret = this.add(key, (Object)("" + inc), hashCode);
        if (ret) {
            return inc;
        }
        return this.incrdecr("decr", key, inc, hashCode);
    }

    @Override
    public long incr(String key) {
        return this.incrdecr("incr", key, 1L, null);
    }

    @Override
    public long incr(String key, long inc) {
        return this.incrdecr("incr", key, inc, null);
    }

    @Override
    public long incr(String key, long inc, Integer hashCode) {
        return this.incrdecr("incr", key, inc, hashCode);
    }

    @Override
    public long decr(String key) {
        return this.incrdecr("decr", key, 1L, null);
    }

    @Override
    public long decr(String key, long inc) {
        return this.incrdecr("decr", key, inc, null);
    }

    @Override
    public long decr(String key, long inc, Integer hashCode) {
        return this.incrdecr("decr", key, inc, hashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrdecr(String cmdname, String key, long inc, Integer hashCode) {
        if (key == null) {
            LOG.error("null key for incrdecr()");
            return -1L;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)e, key);
            }
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return -1L;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), key);
            }
            return -1L;
        }
        try {
            String cmd = new StringBuffer().append(cmdname).append(" ").append(key).append(" ").append(inc).append("\r\n").toString();
            sock.write(cmd.getBytes());
            SockInputStream sis = new SockInputStream(sock, Integer.MAX_VALUE);
            String line = sis.getLine().split("\r\n")[0];
            sis.close();
            if (line.matches("\\d+")) {
                long l = Long.parseLong(line);
                return l;
            }
            if ("NOT_FOUND\r\n".equals(line + "\r\n")) {
                LOG.info(new StringBuffer().append("++++ key not found to incr/decr for key: ").append(key).toString());
            } else {
                LOG.error(new StringBuffer().append("++++ error incr/decr key: ").append(key).toString());
                LOG.error(new StringBuffer().append("++++ server response: ").append(line).toString());
            }
        }
        catch (Exception e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)e, key);
            }
            LOG.error("++++ exception thrown while writing bytes to server on incr/decr");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString());
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return -1L;
    }

    @Override
    public Object get(String key) {
        return this.get(key, null);
    }

    @Override
    public Object get(String key, Integer hashCode) {
        return this.get("get", key, hashCode, false);
    }

    @Override
    public MemcachedItem gets(String key) {
        return this.gets(key, null);
    }

    @Override
    public MemcachedItem gets(String key, Integer hashCode) {
        return this.gets("gets", key, hashCode, false);
    }

    @Override
    public Object get(String key, Integer hashCode, boolean asString) {
        return this.get("get", key, hashCode, asString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object get(String cmd, String key, Integer hashCode, boolean asString) {
        if (key == null) {
            LOG.error("key is null for get()");
            return null;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return null;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), key);
            }
            return null;
        }
        String cmdLine = cmd + " " + key;
        try {
            sock.writeBuf.clear();
            sock.writeBuf.put(cmdLine.getBytes());
            sock.writeBuf.put(B_RETURN);
            sock.flush();
            int dataSize = 0;
            int flag = 0;
            SockInputStream input = new SockInputStream(sock, Integer.MAX_VALUE);
            boolean stop = false;
            StringBuffer sb = new StringBuffer();
            int index = 0;
            while (!stop) {
                int b = input.read();
                if (b == 32 || b == 13) {
                    switch (index) {
                        case 0: {
                            if ("END\r\n".startsWith(sb.toString())) {
                                Object var14_17 = null;
                                return var14_17;
                            }
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            flag = Integer.parseInt(sb.toString());
                            break;
                        }
                        case 3: {
                            dataSize = Integer.parseInt(sb.toString());
                        }
                    }
                    ++index;
                    sb = new StringBuffer();
                    if (b != 13) continue;
                    input.read();
                    stop = true;
                    continue;
                }
                sb.append((char)b);
            }
            Object o = null;
            input.willRead(dataSize);
            if (dataSize > 0) {
                if (NativeHandler.isHandled(flag)) {
                    byte[] buf = input.getBuffer();
                    if ((flag & 2) == 2) {
                        int count;
                        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
                        byte[] tmp = new byte[2048];
                        while ((count = gzi.read(tmp)) != -1) {
                            bos.write(tmp, 0, count);
                        }
                        buf = bos.toByteArray();
                        gzi.close();
                    }
                    o = this.primitiveAsString || asString ? new String(buf, this.defaultEncoding) : NativeHandler.decode(buf, flag);
                } else if (this.transCoder != null) {
                    InputStream in = input;
                    if ((flag & 2) == 2) {
                        in = new GZIPInputStream(in);
                    }
                    o = this.classLoader == null ? this.transCoder.decode(in) : ((ObjectTransCoder)this.transCoder).decode(in, this.classLoader);
                }
            }
            input.willRead(Integer.MAX_VALUE);
            input.getLine();
            input.getLine();
            Object object = o;
            return object;
        }
        catch (Exception ce) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)ce, key);
            }
            LOG.error("++++ exception thrown while trying to get object from cache for key: " + key);
            LOG.error(ce.getMessage(), (Throwable)ce);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString());
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcachedItem gets(String cmd, String key, Integer hashCode, boolean asString) {
        if (key == null) {
            LOG.error("key is null for get()");
            return null;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return null;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), key);
            }
            return null;
        }
        String cmdLine = cmd + " " + key;
        try {
            sock.writeBuf.clear();
            sock.writeBuf.put(cmdLine.getBytes());
            sock.writeBuf.put(B_RETURN);
            sock.flush();
            int dataSize = 0;
            int flag = 0;
            MemcachedItem item = new MemcachedItem();
            SockInputStream input = new SockInputStream(sock, Integer.MAX_VALUE);
            boolean stop = false;
            StringBuffer sb = new StringBuffer();
            int index = 0;
            while (!stop) {
                int b = input.read();
                if (b == 32 || b == 13) {
                    switch (index) {
                        case 0: {
                            if ("END\r\n".startsWith(sb.toString())) {
                                MemcachedItem memcachedItem = null;
                                return memcachedItem;
                            }
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            flag = Integer.parseInt(sb.toString());
                            break;
                        }
                        case 3: {
                            dataSize = Integer.parseInt(sb.toString());
                            break;
                        }
                        case 4: {
                            if (!cmd.equals("gets")) break;
                            item.casUnique = Long.parseLong(sb.toString());
                        }
                    }
                    ++index;
                    sb = new StringBuffer();
                    if (b != 13) continue;
                    input.read();
                    stop = true;
                    continue;
                }
                sb.append((char)b);
            }
            Object o = null;
            input.willRead(dataSize);
            if (dataSize > 0) {
                if (NativeHandler.isHandled(flag)) {
                    byte[] buf = input.getBuffer();
                    if ((flag & 2) == 2) {
                        int count;
                        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
                        byte[] tmp = new byte[2048];
                        while ((count = gzi.read(tmp)) != -1) {
                            bos.write(tmp, 0, count);
                        }
                        buf = bos.toByteArray();
                        gzi.close();
                    }
                    o = this.primitiveAsString || asString ? new String(buf, this.defaultEncoding) : NativeHandler.decode(buf, flag);
                } else if (this.transCoder != null) {
                    InputStream in = input;
                    if ((flag & 2) == 2) {
                        in = new GZIPInputStream(in);
                    }
                    o = this.transCoder.decode(in);
                }
            }
            item.value = o;
            input.willRead(Integer.MAX_VALUE);
            input.getLine();
            input.getLine();
            MemcachedItem memcachedItem = item;
            return memcachedItem;
        }
        catch (Exception ce) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)ce, key);
            }
            LOG.error("++++ exception thrown while trying to get object from cache for key: " + key);
            LOG.error(ce.getMessage(), (Throwable)ce);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString());
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return null;
    }

    @Override
    public void setTransCoder(TransCoder transCoder) {
        this.transCoder = transCoder;
    }

    @Override
    public Object[] getMultiArray(String[] keys) {
        return this.getMultiArray(keys, null);
    }

    @Override
    public Object[] getMultiArray(String[] keys, Integer[] hashCodes) {
        Map<String, Object> data = this.getMulti(keys, hashCodes);
        if (data == null) {
            return null;
        }
        Object[] res = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            res[i] = data.get(keys[i]);
        }
        return res;
    }

    @Override
    public Object[] getMultiArray(String[] keys, Integer[] hashCodes, boolean asString) {
        Map<String, Object> data = this.getMulti(keys, hashCodes, asString);
        if (data == null) {
            return null;
        }
        Object[] res = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            res[i] = data.get(keys[i]);
        }
        return res;
    }

    @Override
    public Map<String, Object> getMulti(String[] keys) {
        return this.getMulti(keys, null);
    }

    @Override
    public Map<String, Object> getMulti(String[] keys, Integer[] hashCodes) {
        return this.getMulti(keys, hashCodes, false);
    }

    @Override
    public Map<String, Object> getMulti(String[] keys, Integer[] hashCodes, boolean asString) {
        if (keys == null || keys.length == 0) {
            LOG.error("missing keys for getMulti()");
            return null;
        }
        HashMap<String, StringBuilder> cmdMap = new HashMap<String, StringBuilder>();
        String[] cleanKeys = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (key == null) {
                LOG.error("null key, so skipping");
                continue;
            }
            Integer hash = null;
            if (hashCodes != null && hashCodes.length > i) {
                hash = hashCodes[i];
            }
            cleanKeys[i] = key;
            try {
                cleanKeys[i] = this.sanitizeKey(key);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)e, key);
                }
                LOG.error("failed to sanitize your key!", (Throwable)e);
                continue;
            }
            SchoonerSockIO sock = this.pool.getSock(cleanKeys[i], hash);
            if (sock == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), key);
                continue;
            }
            if (!cmdMap.containsKey(sock.getHost())) {
                cmdMap.put(sock.getHost(), new StringBuilder("get"));
            }
            ((StringBuilder)cmdMap.get(sock.getHost())).append(" " + cleanKeys[i]);
            sock.close();
        }
        LOG.debug("multi get socket count : " + cmdMap.size());
        HashMap<String, Object> ret = new HashMap<String, Object>(keys.length);
        new NIOLoader(this).doMulti(asString, cmdMap, keys, ret);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].equals(cleanKeys[i]) || !ret.containsKey(cleanKeys[i])) continue;
            ret.put(keys[i], ret.get(cleanKeys[i]));
            ret.remove(cleanKeys[i]);
        }
        LOG.debug("++++ memcache: got back " + ret.size() + " results");
        return ret;
    }

    private void loadMulti(LineInputStream input, Map<String, Object> hm, boolean asString) throws IOException {
        while (true) {
            String line;
            if ((line = input.readLine()).startsWith("VALUE")) {
                String[] info = line.split(" ");
                String key = info[1];
                int flag = Integer.parseInt(info[2]);
                int length = Integer.parseInt(info[3]);
                byte[] buf = new byte[length];
                input.read(buf);
                input.clearEOL();
                Object o = null;
                if ((flag & 2) == 2) {
                    int count;
                    GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
                    byte[] tmp = new byte[2048];
                    while ((count = gzi.read(tmp)) != -1) {
                        bos.write(tmp, 0, count);
                    }
                    buf = bos.toByteArray();
                    gzi.close();
                }
                if (flag != 0) {
                    if (this.primitiveAsString || asString) {
                        o = new String(buf, this.defaultEncoding);
                    } else {
                        try {
                            o = NativeHandler.decode(buf, flag);
                        }
                        catch (Exception e) {
                            LOG.error("++++ Exception thrown while trying to deserialize for key: " + key + " -- " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                } else if (this.transCoder != null) {
                    o = this.transCoder.decode(new ByteArrayInputStream(buf));
                }
                hm.put(key, o);
                continue;
            }
            if ("END\r\n".equals(line)) break;
        }
    }

    @Override
    public boolean flushAll() {
        return this.flushAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushAll(String[] servers) {
        if (this.pool == null) {
            LOG.error("++++ unable to get SockIOPool instance");
            return false;
        }
        String[] stringArray = servers = servers == null ? this.pool.getServers() : servers;
        if (servers == null || servers.length <= 0) {
            LOG.error("++++ no servers to flush");
            return false;
        }
        boolean success = true;
        for (int i = 0; i < servers.length; ++i) {
            SchoonerSockIO sock = this.pool.getConnection(servers[i]);
            if (sock == null) {
                LOG.error("++++ unable to get connection to : " + servers[i]);
                success = false;
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnFlush(this, new IOException("no socket to server available"));
                continue;
            }
            String command = "flush_all\r\n";
            try {
                sock.write(command.getBytes());
                SockInputStream sis = new SockInputStream(sock, Integer.MAX_VALUE);
                String line = sis.getLine();
                sis.close();
                success = "OK\r\n".equals(line) ? success : false;
                continue;
            }
            catch (IOException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnFlush(this, e);
                }
                LOG.error("++++ exception thrown while writing bytes to server on flushAll");
                LOG.error(e.getMessage(), (Throwable)e);
                try {
                    sock.sockets.invalidateObject(sock);
                }
                catch (Exception e1) {
                    LOG.error("++++ failed to close socket : " + sock.toString());
                }
                success = false;
                sock = null;
                continue;
            }
            finally {
                if (sock != null) {
                    sock.close();
                    sock = null;
                }
            }
        }
        return success;
    }

    @Override
    public Map<String, Map<String, String>> stats() {
        return this.stats(null);
    }

    @Override
    public Map<String, Map<String, String>> stats(String[] servers) {
        return this.stats(servers, "stats\r\n", "STAT");
    }

    @Override
    public Map<String, Map<String, String>> statsItems() {
        return this.statsItems(null);
    }

    @Override
    public Map<String, Map<String, String>> statsItems(String[] servers) {
        return this.stats(servers, "stats items\r\n", "STAT");
    }

    @Override
    public Map<String, Map<String, String>> statsSlabs() {
        return this.statsSlabs(null);
    }

    @Override
    public Map<String, Map<String, String>> statsSlabs(String[] servers) {
        return this.stats(servers, "stats slabs\r\n", "STAT");
    }

    @Override
    public Map<String, Map<String, String>> statsCacheDump(int slabNumber, int limit) {
        return this.statsCacheDump(null, slabNumber, limit);
    }

    @Override
    public Map<String, Map<String, String>> statsCacheDump(String[] servers, int slabNumber, int limit) {
        return this.stats(servers, String.format("stats cachedump %d %d\r\n", slabNumber, limit), "ITEM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> stats(String[] servers, String command, String lineStart) {
        if (command == null || command.trim().equals("")) {
            LOG.error("++++ invalid / missing command for stats()");
            return null;
        }
        String[] stringArray = servers = servers == null ? this.pool.getServers() : servers;
        if (servers == null || servers.length <= 0) {
            LOG.error("++++ no servers to check stats");
            return null;
        }
        HashMap<String, Map<String, String>> statsMaps = new HashMap<String, Map<String, String>>();
        for (int i = 0; i < servers.length; ++i) {
            SchoonerSockIO sock = this.pool.getConnection(servers[i]);
            if (sock == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnStats(this, new IOException("no socket to server available"));
                continue;
            }
            try {
                String line;
                sock.write(command.getBytes());
                HashMap<String, String> stats = new HashMap<String, String>();
                SockInputStream input = new SockInputStream(sock, Integer.MAX_VALUE);
                while ((line = input.getLine()) != null) {
                    if (line.startsWith(lineStart)) {
                        String[] info = line.split(" ", 3);
                        String key = info.length > 1 ? info[1] : null;
                        String value = info.length > 2 ? info[2] : null;
                        stats.put(key, value);
                    } else {
                        if ("END\r\n".equals(line)) break;
                        if (line.startsWith("ERROR\r\n") || line.startsWith("CLIENT_ERROR\r\n") || line.startsWith("SERVER_ERROR\r\n")) {
                            LOG.error("++++ failed to query stats");
                            LOG.error("++++ server response: " + line);
                            break;
                        }
                    }
                    statsMaps.put(servers[i], stats);
                }
                input.close();
                continue;
            }
            catch (Exception e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnStats(this, e);
                }
                LOG.error("++++ exception thrown while writing bytes to server on stats");
                LOG.error(e.getMessage(), (Throwable)e);
                try {
                    sock.sockets.invalidateObject(sock);
                }
                catch (Exception e1) {
                    LOG.error("++++ failed to close socket : " + sock.toString());
                }
                sock = null;
                continue;
            }
            finally {
                if (sock != null) {
                    sock.close();
                    sock = null;
                }
            }
        }
        return statsMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sync(String key, Integer hashCode) {
        if (key == null) {
            LOG.error("null value for key passed to sync()");
            return false;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            return false;
        }
        StringBuilder command = new StringBuilder("sync ").append(key);
        command.append("\r\n");
        try {
            sock.write(command.toString().getBytes());
            SockInputStream sis = new SockInputStream(sock, Integer.MAX_VALUE);
            String line = sis.getLine();
            sis.close();
            if ("SYNCED\r\n".equals(line)) {
                LOG.info(new StringBuffer().append("++++ sync of key: ").append(key).append(" from cache was a success").toString());
                boolean bl = true;
                return bl;
            }
            if ("NOT_FOUND\r\n".equals(line)) {
                LOG.info(new StringBuffer().append("++++ sync of key: ").append(key).append(" from cache failed as the key was not found").toString());
            } else {
                LOG.error(new StringBuffer().append("++++ error sync key: ").append(key).toString());
                LOG.error(new StringBuffer().append("++++ server response: ").append(line).toString());
            }
        }
        catch (IOException e) {
            LOG.error("++++ exception thrown while writing bytes to server on delete");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return false;
    }

    @Override
    public boolean sync(String key) {
        return this.sync(key, null);
    }

    @Override
    public boolean syncAll() {
        return this.syncAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean syncAll(String[] servers) {
        if (this.pool == null) {
            LOG.error("++++ unable to get SockIOPool instance");
            return false;
        }
        String[] stringArray = servers = servers == null ? this.pool.getServers() : servers;
        if (servers == null || servers.length <= 0) {
            LOG.error("++++ no servers to sync");
            return false;
        }
        boolean success = true;
        for (int i = 0; i < servers.length; ++i) {
            SchoonerSockIO sock = this.pool.getConnection(servers[i]);
            if (sock == null) {
                LOG.error("++++ unable to get connection to : " + servers[i]);
                success = false;
                continue;
            }
            String command = "sync_all\r\n";
            try {
                sock.write(command.getBytes());
                SockInputStream sis = new SockInputStream(sock, Integer.MAX_VALUE);
                String line = sis.getLine();
                sis.close();
                success = "SYNCED\r\n".equals(line) ? success : false;
                continue;
            }
            catch (IOException e) {
                LOG.error("++++ exception thrown while writing bytes to server on flushAll");
                LOG.error(e.getMessage(), (Throwable)e);
                try {
                    sock.sockets.invalidateObject(sock);
                }
                catch (Exception e1) {
                    LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
                }
                success = false;
                sock = null;
                continue;
            }
            finally {
                if (sock != null) {
                    sock.close();
                    sock = null;
                }
            }
        }
        return success;
    }

    @Override
    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public void setPrimitiveAsString(boolean primitiveAsString) {
        this.primitiveAsString = primitiveAsString;
    }

    @Override
    public void setSanitizeKeys(boolean sanitizeKeys) {
        this.sanitizeKeys = sanitizeKeys;
    }

    private String sanitizeKey(String key) throws UnsupportedEncodingException {
        return this.sanitizeKeys ? URLEncoder.encode(key, "UTF-8") : key;
    }

    protected final class NIOLoader {
        protected Selector selector;
        protected int numConns = 0;
        protected AscIIClient mc;
        protected Connection[] conns;

        public NIOLoader(AscIIClient mc) {
            this.mc = mc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doMulti(boolean asString, Map<String, StringBuilder> sockKeys, String[] keys, Map<String, Object> ret) {
            long timeRemaining = 0L;
            try {
                long timeout;
                this.selector = Selector.open();
                this.conns = new Connection[sockKeys.keySet().size()];
                this.numConns = 0;
                for (String host : sockKeys.keySet()) {
                    SchoonerSockIO sock = AscIIClient.this.pool.getConnection(host);
                    if (sock == null) {
                        if (AscIIClient.this.errorHandler != null) {
                            AscIIClient.this.errorHandler.handleErrorOnGet((MemCachedClient)this.mc, (Throwable)new IOException("no socket to server available"), keys);
                        }
                        return;
                    }
                    this.conns[this.numConns++] = new Connection(this, sock, sockKeys.get(host));
                }
                long startTime = System.currentTimeMillis();
                timeRemaining = timeout = AscIIClient.this.pool.getMaxBusy();
                while (this.numConns > 0 && timeRemaining > 0L) {
                    int n = this.selector.select(Math.min(timeout, 5000L));
                    if (n > 0) {
                        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                        while (it.hasNext()) {
                            SelectionKey key = it.next();
                            it.remove();
                            this.handleKey(key);
                        }
                    } else {
                        LOG.error("selector timed out waiting for activity");
                    }
                    timeRemaining = timeout - (System.currentTimeMillis() - startTime);
                }
            }
            catch (IOException e) {
                return;
            }
            finally {
                LOG.debug("Disconnecting; numConns=" + this.numConns + "  timeRemaining=" + timeRemaining);
                try {
                    if (this.selector != null) {
                        this.selector.close();
                    }
                }
                catch (IOException iOException) {}
                for (Connection c : this.conns) {
                    if (c == null) continue;
                    c.close();
                }
            }
            for (Connection c : this.conns) {
                try {
                    if (c.incoming.size() <= 0 || !c.isDone()) continue;
                    AscIIClient.this.loadMulti(new ByteBufArrayInputStream(c.incoming), ret, asString);
                }
                catch (Exception e) {
                    LOG.debug("Caught the aforementioned exception on " + String.valueOf(c));
                }
            }
        }

        public void doMulti(Map<String, StringBuilder> sockKeys, String[] keys, Map<String, Object> ret) {
            this.doMulti(false, sockKeys, keys, ret);
        }

        private void handleKey(SelectionKey key) throws IOException {
            if (key.isReadable()) {
                this.readResponse(key);
            } else if (key.isWritable()) {
                this.writeRequest(key);
            }
        }

        public void writeRequest(SelectionKey key) throws IOException {
            ByteBuffer buf = ((Connection)key.attachment()).outgoing;
            SocketChannel sc = (SocketChannel)key.channel();
            if (buf.hasRemaining()) {
                sc.write(buf);
            }
            if (!buf.hasRemaining()) {
                key.interestOps(1);
            }
        }

        public void readResponse(SelectionKey key) throws IOException {
            Connection conn = (Connection)key.attachment();
            ByteBuffer buf = conn.getBuffer();
            int count = conn.channel.read(buf);
            if (count > 0 && conn.isDone()) {
                key.cancel();
                --this.numConns;
                return;
            }
        }

        private final class Connection {
            public List<ByteBuffer> incoming = new ArrayList<ByteBuffer>();
            public ByteBuffer outgoing;
            public SchoonerSockIO sock;
            public SocketChannel channel;
            private boolean isDone = false;

            public Connection(NIOLoader nIOLoader, SchoonerSockIO sock, StringBuilder request) throws IOException {
                this.sock = sock;
                this.outgoing = ByteBuffer.wrap(request.append("\r\n").toString().getBytes());
                this.channel = sock.getChannel();
                if (this.channel == null) {
                    throw new IOException("dead connection to: " + sock.getHost());
                }
                this.channel.configureBlocking(false);
                this.channel.register(nIOLoader.selector, 4, this);
            }

            public void close() {
                try {
                    if (this.isDone) {
                        this.channel.configureBlocking(true);
                        this.sock.close();
                        return;
                    }
                }
                catch (IOException e) {
                    LOG.warn("++++ memcache: unexpected error closing normally", (Throwable)e);
                }
                try {
                    this.sock.sockets.invalidateObject(this.sock);
                }
                catch (Exception e1) {
                    LOG.error("++++ failed to close socket : " + this.sock.toString(), (Throwable)e1);
                }
            }

            public boolean isDone() {
                if (this.isDone) {
                    return true;
                }
                int strPos = MemCachedClient.B_END.length - 1;
                for (int bi = this.incoming.size() - 1; bi >= 0 && strPos >= 0; --bi) {
                    ByteBuffer buf = this.incoming.get(bi);
                    int pos = buf.position() - 1;
                    while (pos >= 0 && strPos >= 0) {
                        if (buf.get(pos--) == MemCachedClient.B_END[strPos--]) continue;
                        return false;
                    }
                }
                this.isDone = strPos < 0;
                return this.isDone;
            }

            public ByteBuffer getBuffer() {
                int last = this.incoming.size() - 1;
                if (last >= 0 && this.incoming.get(last).hasRemaining()) {
                    return this.incoming.get(last);
                }
                ByteBuffer newBuf = ByteBuffer.allocate(8192);
                this.incoming.add(newBuf);
                return newBuf;
            }

            public String toString() {
                return new StringBuffer().append("Connection to ").append(this.sock.getHost()).append(" with ").append(this.incoming.size()).append(" bufs; done is ").append(this.isDone).toString();
            }
        }
    }
}

