/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.MemcachedItem;
import com.schooner.MemCached.ObjectTransCoder;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.SchoonerSockIOPool;
import com.schooner.MemCached.TransCoder;
import com.schooner.MemCached.command.DeletionCommand;
import com.schooner.MemCached.command.FlushAllCommand;
import com.schooner.MemCached.command.IncrdecrCommand;
import com.schooner.MemCached.command.RetrievalCommand;
import com.schooner.MemCached.command.StatsCommand;
import com.schooner.MemCached.command.StorageCommand;
import com.schooner.MemCached.command.SyncAllCommand;
import com.schooner.MemCached.command.SyncCommand;
import com.whalin.MemCached.ErrorHandler;
import com.whalin.MemCached.MemCachedClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AscIIUDPClient
extends MemCachedClient {
    private static final Logger LOG = LogManager.getLogger(DeletionCommand.class);
    private TransCoder transCoder = new ObjectTransCoder();
    private SchoonerSockIOPool pool;
    private String poolName;
    private boolean sanitizeKeys;
    private boolean primitiveAsString;
    private boolean compressEnable;
    private long compressThreshold;
    private String defaultEncoding = "utf-8";
    public static final byte B_DELIMITER = 32;
    public static final byte B_RETURN = 13;

    @Override
    public boolean isUseBinaryProtocol() {
        return false;
    }

    public AscIIUDPClient() {
        this("default");
    }

    public AscIIUDPClient(String poolName) {
        this.poolName = poolName;
        this.init();
    }

    public AscIIUDPClient(String poolName, ClassLoader cl, ErrorHandler eh) {
        this.poolName = poolName;
        this.classLoader = cl;
        this.errorHandler = eh;
        this.init();
    }

    private void init() {
        this.sanitizeKeys = true;
        this.primitiveAsString = false;
        this.compressEnable = true;
        this.compressThreshold = 30720L;
        this.defaultEncoding = "UTF-8";
        this.poolName = this.poolName == null ? "default" : this.poolName;
        this.pool = SchoonerSockIOPool.getInstance(this.poolName);
    }

    @Override
    public boolean set(String key, Object value) {
        return this.set("set", key, value, null, null, 0L);
    }

    @Override
    public boolean set(String key, Object value, Integer hashCode) {
        return this.set("set", key, value, null, hashCode, 0L);
    }

    @Override
    public boolean set(String key, Object value, Date expiry) {
        return this.set("set", key, value, expiry, null, 0L);
    }

    @Override
    public boolean set(String key, Object value, Date expiry, Integer hashCode) {
        return this.set("set", key, value, expiry, hashCode, 0L);
    }

    @Override
    public boolean add(String key, Object value) {
        return this.set("add", key, value, null, null, 0L);
    }

    @Override
    public boolean add(String key, Object value, Integer hashCode) {
        return this.set("add", key, value, null, hashCode, 0L);
    }

    @Override
    public boolean add(String key, Object value, Date expiry) {
        return this.set("add", key, value, expiry, null, 0L);
    }

    @Override
    public boolean add(String key, Object value, Date expiry, Integer hashCode) {
        return this.set("add", key, value, expiry, hashCode, 0L);
    }

    @Override
    public boolean append(String key, Object value, Integer hashCode) {
        return this.set("append", key, value, null, hashCode, 0L);
    }

    @Override
    public boolean append(String key, Object value) {
        return this.set("append", key, value, null, null, 0L);
    }

    @Override
    public boolean cas(String key, Object value, Integer hashCode, long casUnique) {
        return this.set("cas", key, value, null, hashCode, casUnique);
    }

    @Override
    public boolean cas(String key, Object value, Date expiry, long casUnique) {
        return this.set("cas", key, value, expiry, null, casUnique);
    }

    @Override
    public boolean cas(String key, Object value, Date expiry, Integer hashCode, long casUnique) {
        return this.set("cas", key, value, expiry, hashCode, casUnique);
    }

    @Override
    public boolean cas(String key, Object value, long casUnique) {
        return this.set("cas", key, value, null, null, casUnique);
    }

    @Override
    public boolean prepend(String key, Object value, Integer hashCode) {
        return this.set("prepend", key, value, null, hashCode, 0L);
    }

    @Override
    public boolean prepend(String key, Object value) {
        return this.set("prepend", key, value, null, null, 0L);
    }

    @Override
    public boolean replace(String key, Object value) {
        return this.set("replace", key, value, null, null, 0L);
    }

    @Override
    public boolean replace(String key, Object value, Integer hashCode) {
        return this.set("replace", key, value, null, hashCode, 0L);
    }

    @Override
    public boolean replace(String key, Object value, Date expiry) {
        return this.set("replace", key, value, expiry, null, 0L);
    }

    @Override
    public boolean replace(String key, Object value, Date expiry, Integer hashCode) {
        return this.set("replace", key, value, expiry, hashCode, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean set(String cmdname, String key, Object value, Date expiry, Integer hashCode, Long casUnique) {
        if (cmdname == null || key == null) {
            LOG.error("key is null or cmd is null/empty for set()");
            return false;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return false;
        }
        if (value == null) {
            LOG.error("trying to store a null value to cache");
            return false;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), key);
            }
            return false;
        }
        if (expiry == null) {
            expiry = new Date(0L);
        }
        try {
            StorageCommand setCmd = new StorageCommand(cmdname, key, value, expiry, hashCode, casUnique, this.transCoder);
            short rid = setCmd.request(sock);
            boolean bl = setCmd.response(sock, rid);
            return bl;
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            LOG.error("++++ exception thrown while writing bytes to server on set");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return false;
    }

    @Override
    public void setTransCoder(TransCoder transCoder) {
        this.transCoder = transCoder;
    }

    @Override
    public long addOrDecr(String key) {
        return this.addOrDecr(key, 0L, null);
    }

    @Override
    public long addOrDecr(String key, long inc) {
        return this.addOrDecr(key, inc, null);
    }

    @Override
    public long addOrDecr(String key, long inc, Integer hashCode) {
        boolean ret = this.add(key, (Object)("" + inc), hashCode);
        if (ret) {
            return inc;
        }
        return this.incrdecr("decr", key, inc, hashCode);
    }

    @Override
    public long addOrIncr(String key) {
        return this.addOrIncr(key, 0L, null);
    }

    @Override
    public long addOrIncr(String key, long inc) {
        return this.addOrIncr(key, inc, null);
    }

    @Override
    public long addOrIncr(String key, long inc, Integer hashCode) {
        boolean ret = this.add(key, (Object)("" + inc), hashCode);
        if (ret) {
            return inc;
        }
        return this.incrdecr("incr", key, inc, hashCode);
    }

    @Override
    public long decr(String key) {
        return this.incrdecr("decr", key, 1L, null);
    }

    @Override
    public long decr(String key, long inc) {
        return this.incrdecr("decr", key, inc, null);
    }

    @Override
    public long decr(String key, long inc, Integer hashCode) {
        return this.incrdecr("decr", key, inc, hashCode);
    }

    @Override
    public boolean delete(String key) {
        return this.delete(key, null, null);
    }

    @Override
    public boolean delete(String key, Date expiry) {
        return this.delete(key, null, expiry);
    }

    @Override
    public boolean flushAll() {
        return this.flushAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushAll(String[] servers) {
        if (this.pool == null) {
            LOG.error("++++ unable to get SockIOPool instance");
            return false;
        }
        String[] stringArray = servers = servers == null ? this.pool.getServers() : servers;
        if (servers == null || servers.length <= 0) {
            LOG.error("++++ no servers to flush");
            return false;
        }
        boolean success = true;
        for (int i = 0; i < servers.length; ++i) {
            SchoonerSockIO sock = this.pool.getConnection(servers[i]);
            if (sock == null) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnFlush(this, new IOException("no socket to server available"));
                }
                LOG.error("++++ unable to get connection to : " + servers[i]);
                success = false;
                continue;
            }
            try {
                FlushAllCommand flushallCmd = new FlushAllCommand();
                short rid = flushallCmd.request(sock);
                success = flushallCmd.response(sock, rid);
                if (success) continue;
                boolean bl = success;
                return bl;
            }
            catch (IOException e) {
                this.errorHandler.handleErrorOnFlush(this, e);
                LOG.error("++++ exception thrown while writing bytes to server on flushAll");
                LOG.error(e.getMessage(), (Throwable)e);
                try {
                    sock.sockets.invalidateObject(sock);
                }
                catch (Exception e1) {
                    LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
                }
                success = false;
                sock = null;
                continue;
            }
            finally {
                if (sock != null) {
                    sock.close();
                    sock = null;
                }
            }
        }
        return success;
    }

    @Override
    public Object get(String key) {
        return this.get(key, null);
    }

    @Override
    public Object get(String key, Integer hashCode) {
        return this.get((String)"get", (String)key, (Integer)hashCode).value;
    }

    @Override
    public Map<String, Object> getMulti(String[] keys) {
        return this.getMulti(keys, null);
    }

    @Override
    public Map<String, Object> getMulti(String[] keys, Integer[] hashCodes) {
        if (keys == null || keys.length == 0) {
            LOG.error("missing keys for getMulti()");
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            SchoonerSockIO sock;
            String key = keys[i];
            if (key == null) {
                LOG.error("null key, so skipping");
                continue;
            }
            Integer hash = null;
            if (hashCodes != null && hashCodes.length > i) {
                hash = hashCodes[i];
            }
            if ((sock = this.pool.getSock(key, hash)) == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), key);
                continue;
            }
            ret.put(key, this.get((String)"get", (String)key, (Integer)hash).value);
            sock.close();
        }
        return ret;
    }

    @Override
    public Object[] getMultiArray(String[] keys) {
        return this.getMultiArray(keys, null);
    }

    @Override
    public Object[] getMultiArray(String[] keys, Integer[] hashCodes) {
        Map<String, Object> data = this.getMulti(keys, hashCodes);
        if (data == null) {
            return null;
        }
        Object[] res = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            res[i] = data.get(keys[i]);
        }
        return res;
    }

    @Override
    public Object[] getMultiArray(String[] keys, Integer[] hashCodes, boolean asString) {
        Map<String, Object> data = this.getMulti(keys, hashCodes, asString);
        if (data == null) {
            return null;
        }
        Object[] res = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            res[i] = data.get(keys[i]);
        }
        return res;
    }

    @Override
    public MemcachedItem gets(String key) {
        return this.gets(key, null);
    }

    @Override
    public MemcachedItem gets(String key, Integer hashCode) {
        return this.get("gets", key, hashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemcachedItem get(String cmd, String key, Integer hashCode) {
        MemcachedItem item = new MemcachedItem();
        if (key == null) {
            LOG.error("key is null for get()");
            return item;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)e, key);
            }
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return null;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), key);
            }
            return item;
        }
        RetrievalCommand retrieval = new RetrievalCommand(cmd, key);
        try {
            short rid = retrieval.request(sock);
            MemcachedItem memcachedItem = retrieval.response(sock, this.transCoder, rid);
            return memcachedItem;
        }
        catch (IOException e) {
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return item;
    }

    @Override
    public long incr(String key) {
        return this.incrdecr("incr", key, 1L, null);
    }

    @Override
    public long incr(String key, long inc) {
        return this.incrdecr("incr", key, inc, null);
    }

    @Override
    public long incr(String key, long inc, Integer hashCode) {
        return this.incrdecr("incr", key, inc, hashCode);
    }

    @Override
    public boolean keyExists(String key) {
        return this.get(key, null) != null;
    }

    @Override
    public Map<String, Map<String, String>> stats() {
        return this.stats(null);
    }

    @Override
    public Map<String, Map<String, String>> stats(String[] servers) {
        return this.stats(servers, "stats\r\n", "STAT");
    }

    @Override
    public Map<String, Map<String, String>> statsCacheDump(int slabNumber, int limit) {
        return this.statsCacheDump(null, slabNumber, limit);
    }

    @Override
    public Map<String, Map<String, String>> statsCacheDump(String[] servers, int slabNumber, int limit) {
        return this.stats(servers, String.format("stats cachedump %d %d\r\n", slabNumber, limit), "ITEM");
    }

    @Override
    public Map<String, Map<String, String>> statsItems() {
        return this.statsItems(null);
    }

    @Override
    public Map<String, Map<String, String>> statsItems(String[] servers) {
        return this.stats(servers, "stats items\r\n", "STAT");
    }

    @Override
    public Map<String, Map<String, String>> statsSlabs() {
        return this.statsSlabs(null);
    }

    @Override
    public Map<String, Map<String, String>> statsSlabs(String[] servers) {
        return this.stats(servers, "stats slabs\r\n", "STAT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sync(String key, Integer hashCode) {
        if (key == null) {
            LOG.error("null value for key passed to delete()");
            return false;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            return false;
        }
        try {
            SyncCommand syncCmd = new SyncCommand(key, hashCode);
            short rid = syncCmd.request(sock);
            boolean bl = syncCmd.response(sock, rid);
            return bl;
        }
        catch (IOException e) {
            LOG.error("++++ exception thrown while writing bytes to server on delete");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return false;
    }

    @Override
    public boolean sync(String key) {
        return this.sync(key, null);
    }

    @Override
    public boolean syncAll() {
        return this.syncAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean syncAll(String[] servers) {
        if (this.pool == null) {
            LOG.error("++++ unable to get SockIOPool instance");
            return false;
        }
        String[] stringArray = servers = servers == null ? this.pool.getServers() : servers;
        if (servers == null || servers.length <= 0) {
            LOG.error("++++ no servers to sync");
            return false;
        }
        boolean success = true;
        for (int i = 0; i < servers.length; ++i) {
            SchoonerSockIO sock = this.pool.getConnection(servers[i]);
            if (sock == null) {
                LOG.error("++++ unable to get connection to : " + servers[i]);
                success = false;
                continue;
            }
            try {
                SyncAllCommand syncCmd = new SyncAllCommand();
                short rid = syncCmd.request(sock);
                success = syncCmd.response(sock, rid);
                if (success) continue;
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                LOG.error("++++ exceptionthrown while writing bytes to server on flushAll");
                LOG.error(e.getMessage(), (Throwable)e);
                try {
                    sock.sockets.invalidateObject(sock);
                }
                catch (Exception e1) {
                    LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
                }
                success = false;
                sock = null;
                continue;
            }
            finally {
                if (sock != null) {
                    sock.close();
                    sock = null;
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String key, Integer hashCode, Date expiry) {
        if (key == null) {
            LOG.error("null value for key passed to delete()");
            return false;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, new IOException("no socket to server available"), key);
            }
            return false;
        }
        try {
            DeletionCommand deletion = new DeletionCommand(key, hashCode, expiry);
            short rid = deletion.request(sock);
            boolean bl = deletion.response(sock, rid);
            return bl;
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, e, key);
            }
            LOG.error("++++ exception thrown while writing bytes to server on delete");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrdecr(String cmdname, String key, long inc, Integer hashCode) {
        if (key == null) {
            LOG.error("null key for incrdecr()");
            return -1L;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)e, key);
            }
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return -1L;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), key);
            }
            return -1L;
        }
        try {
            IncrdecrCommand idCmd = new IncrdecrCommand(cmdname, key, inc, hashCode);
            short rid = idCmd.request(sock);
            if (idCmd.response(sock, rid)) {
                long l = idCmd.getResult();
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)e, key);
            }
            LOG.error("++++ exception thrown while writing bytes to server on incr/decr");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> stats(String[] servers, String command, String lineStart) {
        if (command == null || command.trim().equals("")) {
            LOG.error("++++ invalid / missing command for stats()");
            return null;
        }
        String[] stringArray = servers = servers == null ? this.pool.getServers() : servers;
        if (servers == null || servers.length <= 0) {
            LOG.error("++++ no servers to check stats");
            return null;
        }
        HashMap<String, Map<String, String>> statsMaps = new HashMap<String, Map<String, String>>();
        for (int i = 0; i < servers.length; ++i) {
            SchoonerSockIO sock = this.pool.getConnection(servers[i]);
            if (sock == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnStats(this, new IOException("no socket to server available"));
                continue;
            }
            try {
                StatsCommand statsCmd = new StatsCommand(command, lineStart);
                short rid = statsCmd.request(sock);
                Map<String, String> stats = statsCmd.response(sock, rid);
                statsMaps.put(servers[i], stats);
                continue;
            }
            catch (IOException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnStats(this, e);
                }
                LOG.error("++++ exception thrown while writing bytes to server on stats");
                LOG.error(e.getMessage(), (Throwable)e);
                try {
                    sock.sockets.invalidateObject(sock);
                }
                catch (Exception e1) {
                    LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
                }
                sock = null;
                continue;
            }
            finally {
                if (sock != null) {
                    sock.close();
                    sock = null;
                }
            }
        }
        return statsMaps;
    }

    @Override
    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public void setPrimitiveAsString(boolean primitiveAsString) {
        this.primitiveAsString = primitiveAsString;
    }

    @Override
    public void setSanitizeKeys(boolean sanitizeKeys) {
        this.sanitizeKeys = sanitizeKeys;
    }

    private String sanitizeKey(String key) throws UnsupportedEncodingException {
        return this.sanitizeKeys ? URLEncoder.encode(key, "UTF-8") : key;
    }

    @Override
    public Object get(String key, Integer hashCode, boolean asString) {
        return this.get((String)"get", (String)key, (Integer)hashCode).value;
    }

    @Override
    public Map<String, Object> getMulti(String[] keys, Integer[] hashCodes, boolean asString) {
        return this.getMulti(keys, hashCodes);
    }
}

