/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.AuthInfo;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.SchoonerSockIOFactory;
import com.schooner.MemCached.SockInputStream;
import com.schooner.MemCached.command.DeletionCommand;
import java.io.DataInputStream;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.apache.commons.pool2.PooledObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuthSchoonerSockIOFactory
extends SchoonerSockIOFactory {
    private static final Logger LOG = LogManager.getLogger(DeletionCommand.class);
    public static final String NTLM = "NTLM";
    public static final String PLAIN = "PLAIN";
    public static final String LOGIN = "LOGIN";
    public static final String DIGEST_MD5 = "DIGEST-MD5";
    public static final String CRAM_MD5 = "CRAM-MD5";
    public static final String ANONYMOUS = "ANONYMOUS";
    public static final byte[] EMPTY_BYTES = new byte[0];
    private AuthInfo authInfo;

    public AuthSchoonerSockIOFactory(String host, boolean isTcp, int bufferSize, int socketTO, int socketConnectTO, boolean nagle, AuthInfo authInfo) {
        super(host, isTcp, bufferSize, socketTO, socketConnectTO, nagle);
        this.authInfo = authInfo;
    }

    @Override
    public PooledObject<SchoonerSockIO> makeObject() throws Exception {
        SchoonerSockIO socket = this.createSocket(this.host);
        this.auth(socket);
        return this.wrap(socket);
    }

    private void auth(SchoonerSockIO socket) throws Exception {
        SaslClient saslClient = Sasl.createSaslClient(this.authInfo.getMechanisms(), null, "memcached", this.host, null, this.authInfo.getCallbackHandler());
        byte[] authData = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(EMPTY_BYTES) : EMPTY_BYTES;
        authData = this.sendAuthData(socket, (byte)33, saslClient.getMechanismName(), authData);
        if (authData == null) {
            return;
        }
        authData = saslClient.evaluateChallenge(authData);
        if (this.sendAuthData(socket, (byte)34, saslClient.getMechanismName(), authData) == null) {
            return;
        }
        LOG.error("Auth Failed: mechanism = " + saslClient.getMechanismName());
        throw new Exception();
    }

    private byte[] sendAuthData(SchoonerSockIO sock, byte opcode, String mechanism, byte[] authData) throws Exception {
        sock.writeBuf.clear();
        sock.writeBuf.put((byte)-128);
        sock.writeBuf.put(opcode);
        sock.writeBuf.putShort((short)mechanism.length());
        sock.writeBuf.putInt(0);
        sock.writeBuf.putInt(mechanism.length() + authData.length);
        sock.writeBuf.putInt(0);
        sock.writeBuf.putLong(0L);
        sock.writeBuf.put(mechanism.getBytes());
        sock.writeBuf.put(authData);
        sock.flush();
        DataInputStream dis = new DataInputStream(new SockInputStream(sock, Integer.MAX_VALUE));
        dis.readInt();
        dis.readByte();
        dis.readByte();
        byte[] response = null;
        short status = dis.readShort();
        if (status == 33) {
            int length = dis.readInt();
            response = new byte[length];
            dis.readInt();
            dis.readLong();
            dis.read(response);
        } else if (status == 32) {
            LOG.error("Auth Failed: mechanism = " + mechanism);
            dis.close();
            throw new Exception();
        }
        dis.close();
        return response;
    }
}

