/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.ByteBufArrayInputStream;
import com.schooner.MemCached.MemcachedItem;
import com.schooner.MemCached.NativeHandler;
import com.schooner.MemCached.ObjectTransCoder;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.SchoonerSockIOPool;
import com.schooner.MemCached.SockInputStream;
import com.schooner.MemCached.SockOutputStream;
import com.schooner.MemCached.TransCoder;
import com.schooner.MemCached.command.DeletionCommand;
import com.whalin.MemCached.ErrorHandler;
import com.whalin.MemCached.MemCachedClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinaryClient
extends MemCachedClient {
    private static final Logger LOG = LogManager.getLogger(DeletionCommand.class);
    private TransCoder transCoder = new ObjectTransCoder();
    private SchoonerSockIOPool pool;
    private String poolName;
    private boolean sanitizeKeys;
    private boolean primitiveAsString;
    private boolean compressEnable;
    private long compressThreshold;
    private String defaultEncoding = "utf-8";

    @Override
    public boolean isUseBinaryProtocol() {
        return true;
    }

    public BinaryClient() {
        this((String)null);
    }

    public BinaryClient(String poolName) {
        this(poolName, null, null);
    }

    public BinaryClient(String poolName, ClassLoader cl, ErrorHandler eh) {
        super((MemCachedClient)null);
        this.poolName = poolName;
        this.classLoader = cl;
        this.errorHandler = eh;
        this.init();
    }

    private void init() {
        this.poolName = this.poolName == null ? "default" : this.poolName;
        this.pool = SchoonerSockIOPool.getInstance(this.poolName);
    }

    @Override
    public boolean keyExists(String key) {
        return this.get(key, null) != null;
    }

    @Override
    public boolean delete(String key) {
        return this.delete(key, null, null);
    }

    @Override
    public boolean delete(String key, Date expiry) {
        return this.delete(key, null, expiry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String key, Integer hashCode, Date expiry) {
        if (key == null) {
            LOG.error("null value for key passed to delete()");
            return false;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, e, key);
            }
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return false;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, new IOException("no socket to server available"), key);
            }
            return false;
        }
        try {
            sock.writeBuf.clear();
            sock.writeBuf.put((byte)-128);
            sock.writeBuf.put((byte)4);
            byte[] keyBuf = key.getBytes();
            sock.writeBuf.putShort((short)keyBuf.length);
            sock.writeBuf.putInt(0);
            sock.writeBuf.putInt(keyBuf.length);
            sock.writeBuf.putInt(0);
            sock.writeBuf.putLong(0L);
            sock.writeBuf.put(keyBuf);
            sock.flush();
            SockInputStream input = new SockInputStream(sock, Integer.MAX_VALUE);
            DataInputStream dis = new DataInputStream(input);
            dis.readInt();
            dis.readShort();
            short status = dis.readShort();
            dis.close();
            if (status == 0) {
                LOG.debug("++++ deletion of key: " + key + " from cache was a success");
                boolean bl = true;
                return bl;
            }
            if (status == 1) {
                LOG.debug("++++ deletion of key: " + key + " from cache failed as the key was not found");
            } else {
                LOG.error("++++ error deleting key: " + key);
                LOG.error("++++ server response: " + status);
            }
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, e, key);
            }
            LOG.error("++++ exception thrown while writing bytes to server on delete");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
            }
            sock = null;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return false;
    }

    @Override
    public boolean set(String key, Object value) {
        return this.set((byte)1, key, value, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean set(String key, Object value, Integer hashCode) {
        return this.set((byte)1, key, value, null, hashCode, 0L, this.primitiveAsString);
    }

    @Override
    public boolean set(String key, Object value, Date expiry) {
        return this.set((byte)1, key, value, expiry, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean set(String key, Object value, Date expiry, Integer hashCode) {
        return this.set((byte)1, key, value, expiry, hashCode, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String key, Object value) {
        return this.set((byte)2, key, value, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String key, Object value, Integer hashCode) {
        return this.set((byte)2, key, value, null, hashCode, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String key, Object value, Date expiry) {
        return this.set((byte)2, key, value, expiry, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String key, Object value, Date expiry, Integer hashCode) {
        return this.set((byte)2, key, value, expiry, hashCode, 0L, this.primitiveAsString);
    }

    @Override
    public boolean append(String key, Object value, Integer hashCode) {
        return this.apPrepend((byte)14, key, value, hashCode, 0L);
    }

    @Override
    public boolean append(String key, Object value) {
        return this.apPrepend((byte)14, key, value, null, 0L);
    }

    @Override
    public boolean cas(String key, Object value, Integer hashCode, long casUnique) {
        return this.set((byte)1, key, value, null, hashCode, casUnique, this.primitiveAsString);
    }

    @Override
    public boolean cas(String key, Object value, Date expiry, long casUnique) {
        return this.set((byte)1, key, value, expiry, null, casUnique, this.primitiveAsString);
    }

    @Override
    public boolean cas(String key, Object value, Date expiry, Integer hashCode, long casUnique) {
        return this.set((byte)1, key, value, expiry, hashCode, casUnique, this.primitiveAsString);
    }

    @Override
    public boolean cas(String key, Object value, long casUnique) {
        return this.set((byte)1, key, value, null, null, casUnique, this.primitiveAsString);
    }

    @Override
    public boolean prepend(String key, Object value, Integer hashCode) {
        return this.apPrepend((byte)15, key, value, hashCode, 0L);
    }

    @Override
    public boolean prepend(String key, Object value) {
        return this.apPrepend((byte)15, key, value, null, 0L);
    }

    @Override
    public boolean replace(String key, Object value) {
        return this.set((byte)3, key, value, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String key, Object value, Integer hashCode) {
        return this.set((byte)3, key, value, null, hashCode, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String key, Object value, Date expiry) {
        return this.set((byte)3, key, value, expiry, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String key, Object value, Date expiry, Integer hashCode) {
        return this.set((byte)3, key, value, expiry, hashCode, 0L, this.primitiveAsString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean set(byte opcode, String key, Object value, Date expiry, Integer hashCode, long casUnique, boolean asString) {
        if (key == null) {
            LOG.error("key is null or cmd is null/empty for set()");
            return false;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return false;
        }
        if (value == null) {
            LOG.error("trying to store a null value to cache");
            return false;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), key);
            }
            return false;
        }
        if (expiry == null) {
            expiry = new Date(0L);
        }
        try {
            int flags = NativeHandler.getMarkerFlag(value);
            byte[] buf = key.getBytes();
            sock.writeBuf.clear();
            sock.writeBuf.put((byte)-128);
            sock.writeBuf.put(opcode);
            sock.writeBuf.putShort((short)buf.length);
            sock.writeBuf.put((byte)8);
            sock.writeBuf.put((byte)0);
            sock.writeBuf.putShort((short)0);
            sock.writeBuf.putInt(0);
            sock.writeBuf.putInt(0);
            sock.writeBuf.putLong(casUnique);
            sock.writeBuf.putInt(flags);
            sock.writeBuf.putInt(Long.valueOf(expiry.getTime() / 1000L).intValue());
            sock.writeBuf.put(buf);
            SockOutputStream output = new SockOutputStream(sock);
            int valLen = 0;
            if (flags != 0) {
                byte[] b = asString ? value.toString().getBytes(this.defaultEncoding) : NativeHandler.encode(value);
                output.write(b);
                valLen = b.length;
                valLen = b.length;
            } else {
                valLen = this.transCoder.encode(output, value);
            }
            int bodyLen = 8 + buf.length + valLen;
            int oldPosition = sock.writeBuf.position();
            sock.writeBuf.position(8);
            sock.writeBuf.putInt(bodyLen);
            sock.writeBuf.position(oldPosition);
            sock.flush();
            DataInputStream dis = new DataInputStream(new SockInputStream(sock, Integer.MAX_VALUE));
            dis.readInt();
            dis.readShort();
            short stat = dis.readShort();
            dis.close();
            if (0 == stat) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            LOG.error("++++ exception thrown while writing bytes to server on set");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
            }
            sock = null;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean apPrepend(byte opcode, String key, Object value, Integer hashCode, Long casUnique) {
        if (key == null) {
            LOG.error("key is null or cmd is null/empty for set()");
            return false;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return false;
        }
        if (value == null) {
            LOG.error("trying to store a null value to cache");
            return false;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            return false;
        }
        try {
            int flags = NativeHandler.getMarkerFlag(value);
            byte[] buf = key.getBytes();
            sock.writeBuf.clear();
            sock.writeBuf.put((byte)-128);
            sock.writeBuf.put(opcode);
            sock.writeBuf.putShort((short)buf.length);
            sock.writeBuf.putInt(0);
            sock.writeBuf.putLong(0L);
            sock.writeBuf.putLong(casUnique);
            sock.writeBuf.put(buf);
            SockOutputStream output = new SockOutputStream(sock);
            int valLen = 0;
            if (flags != 0) {
                byte[] b = NativeHandler.encode(value);
                output.write(b);
                valLen = b.length;
            } else {
                valLen = this.transCoder.encode(output, value);
            }
            int bodyLen = buf.length + valLen;
            int oldPosition = sock.writeBuf.position();
            sock.writeBuf.position(8);
            sock.writeBuf.putInt(bodyLen);
            sock.writeBuf.position(oldPosition);
            sock.flush();
            DataInputStream dis = new DataInputStream(new SockInputStream(sock, Integer.MAX_VALUE));
            dis.readInt();
            dis.readShort();
            short stat = dis.readShort();
            dis.close();
            if (0 == stat) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            LOG.error("++++ exception thrown while writing bytes to server on set");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return false;
    }

    @Override
    public long addOrIncr(String key) {
        return this.addOrIncr(key, 0L, null);
    }

    @Override
    public long addOrIncr(String key, long inc) {
        return this.addOrIncr(key, inc, null);
    }

    @Override
    public long addOrIncr(String key, long inc, Integer hashCode) {
        boolean ret = this.add(key, (Object)("" + inc), hashCode);
        if (ret) {
            return inc;
        }
        return this.incrdecr((byte)5, key, inc, hashCode);
    }

    @Override
    public long addOrDecr(String key) {
        return this.addOrDecr(key, 0L, null);
    }

    @Override
    public long addOrDecr(String key, long inc) {
        return this.addOrDecr(key, inc, null);
    }

    @Override
    public long addOrDecr(String key, long inc, Integer hashCode) {
        boolean ret = this.add(key, (Object)("" + inc), hashCode);
        if (ret) {
            return inc;
        }
        return this.incrdecr((byte)6, key, inc, hashCode);
    }

    @Override
    public long incr(String key) {
        return this.incrdecr((byte)5, key, 1L, null);
    }

    @Override
    public long incr(String key, long inc) {
        return this.incrdecr((byte)5, key, inc, null);
    }

    @Override
    public long incr(String key, long inc, Integer hashCode) {
        return this.incrdecr((byte)5, key, inc, hashCode);
    }

    @Override
    public long decr(String key) {
        return this.incrdecr((byte)6, key, 1L, null);
    }

    @Override
    public long decr(String key, long inc) {
        return this.incrdecr((byte)6, key, inc, null);
    }

    @Override
    public long decr(String key, long inc, Integer hashCode) {
        return this.incrdecr((byte)6, key, inc, hashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrdecr(byte opcode, String key, long inc, Integer hashCode) {
        if (key == null) {
            LOG.error("null key for incrdecr()");
            return -1L;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)e, key);
            }
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return -1L;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), key);
            }
            return -1L;
        }
        try {
            sock.writeBuf.clear();
            sock.writeBuf.put((byte)-128);
            sock.writeBuf.put(opcode);
            byte[] keyBuf = key.getBytes();
            sock.writeBuf.putShort((short)keyBuf.length);
            sock.writeBuf.put((byte)20);
            sock.writeBuf.put((byte)0);
            sock.writeBuf.putShort((short)0);
            sock.writeBuf.putInt(keyBuf.length + 20);
            sock.writeBuf.putInt(0);
            sock.writeBuf.putLong(0L);
            sock.writeBuf.putLong(inc);
            sock.writeBuf.putLong(0L);
            sock.writeBuf.putInt(0);
            sock.writeBuf.put(keyBuf);
            sock.flush();
            DataInputStream dis = new DataInputStream(new SockInputStream(sock, Integer.MAX_VALUE));
            dis.readInt();
            dis.readShort();
            short status = dis.readShort();
            dis.close();
            if (status == 0) {
                long res;
                dis.readLong();
                dis.readLong();
                long l = res = dis.readLong();
                return l;
            }
            LOG.error(new StringBuffer().append("++++ error incr/decr key: ").append(key).toString());
            LOG.error(new StringBuffer().append("++++ server response: ").append(status).toString());
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)e, key);
            }
            LOG.error("++++ exception thrown while writing bytes to server on incr/decr");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return -1L;
    }

    @Override
    public Object get(String key) {
        return this.get(key, null);
    }

    @Override
    public Object get(String key, Integer hashCode) {
        return this.get((byte)0, key, hashCode, false);
    }

    @Override
    public MemcachedItem gets(String key) {
        return this.gets(key, null);
    }

    @Override
    public MemcachedItem gets(String key, Integer hashCode) {
        return this.gets((byte)0, key, hashCode, false);
    }

    @Override
    public void setTransCoder(TransCoder transCoder) {
        this.transCoder = transCoder;
    }

    @Override
    public Object[] getMultiArray(String[] keys) {
        return this.getMultiArray(keys, null);
    }

    @Override
    public Object[] getMultiArray(String[] keys, Integer[] hashCodes) {
        Map<String, Object> data = this.getMulti(keys, hashCodes);
        if (data == null) {
            return null;
        }
        Object[] res = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            res[i] = data.get(keys[i]);
        }
        return res;
    }

    @Override
    public Map<String, Object> getMulti(String[] keys) {
        return this.getMulti(keys, null);
    }

    @Override
    public Map<String, Object> getMulti(String[] keys, Integer[] hashCodes) {
        return this.getMulti(keys, hashCodes, false);
    }

    @Override
    public Map<String, Object> getMulti(String[] keys, Integer[] hashCodes, boolean asString) {
        if (keys == null || keys.length == 0) {
            LOG.error("missing keys for getMulti()");
            return null;
        }
        HashMap<String, ArrayList<String>> cmdMap = new HashMap<String, ArrayList<String>>();
        String[] cleanKeys = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (key == null) {
                LOG.error("null key, so skipping");
                continue;
            }
            Integer hash = null;
            if (hashCodes != null && hashCodes.length > i) {
                hash = hashCodes[i];
            }
            cleanKeys[i] = key;
            try {
                cleanKeys[i] = this.sanitizeKey(key);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)e, key);
                }
                LOG.error("failed to sanitize your key!", (Throwable)e);
                continue;
            }
            SchoonerSockIO sock = this.pool.getSock(cleanKeys[i], hash);
            if (sock == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), key);
                continue;
            }
            if (!cmdMap.containsKey(sock.getHost())) {
                cmdMap.put(sock.getHost(), new ArrayList());
            }
            ((ArrayList)cmdMap.get(sock.getHost())).add(cleanKeys[i]);
            sock.close();
        }
        LOG.debug("multi get socket count : " + cmdMap.size());
        HashMap<String, Object> ret = new HashMap<String, Object>(keys.length);
        new NIOLoader(this).doMulti(asString, cmdMap, keys, ret);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].equals(cleanKeys[i]) || !ret.containsKey(cleanKeys[i])) continue;
            ret.put(keys[i], ret.get(cleanKeys[i]));
            ret.remove(cleanKeys[i]);
        }
        LOG.debug("++++ memcache: got back " + ret.size() + " results");
        return ret;
    }

    private void loadMulti(DataInputStream input, Map<String, Object> hm) throws IOException {
        while (true) {
            input.readByte();
            byte opcode = input.readByte();
            if (opcode == 13) {
                short keyLen = input.readShort();
                input.readInt();
                int length = input.readInt() - keyLen - 4;
                input.readInt();
                input.readLong();
                int flag = input.readInt();
                byte[] keyBuf = new byte[keyLen];
                input.read(keyBuf);
                String key = new String(keyBuf);
                byte[] buf = new byte[length];
                input.read(buf);
                Object o = null;
                if ((flag & 2) == 2) {
                    int count;
                    GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
                    byte[] tmp = new byte[2048];
                    while ((count = gzi.read(tmp)) != -1) {
                        bos.write(tmp, 0, count);
                    }
                    buf = bos.toByteArray();
                    gzi.close();
                }
                if (flag != 0) {
                    try {
                        o = NativeHandler.decode(buf, flag);
                    }
                    catch (Exception e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)e, key);
                        }
                        LOG.error("++++ Exception thrown while trying to deserialize for key: " + key, (Throwable)e);
                        e.printStackTrace();
                    }
                } else if (this.transCoder != null) {
                    o = this.transCoder.decode(new ByteArrayInputStream(buf));
                }
                hm.put(key, o);
                continue;
            }
            if (opcode == 10) break;
        }
    }

    @Override
    public boolean flushAll() {
        return this.flushAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushAll(String[] servers) {
        if (this.pool == null) {
            LOG.error("++++ unable to get SockIOPool instance");
            return false;
        }
        String[] stringArray = servers = servers == null ? this.pool.getServers() : servers;
        if (servers == null || servers.length <= 0) {
            LOG.error("++++ no servers to flush");
            return false;
        }
        boolean success = true;
        for (int i = 0; i < servers.length; ++i) {
            SchoonerSockIO sock = this.pool.getConnection(servers[i]);
            if (sock == null) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnFlush(this, new IOException("no socket to server available"));
                }
                LOG.error("++++ unable to get connection to : " + servers[i]);
                success = false;
                continue;
            }
            sock.writeBuf.clear();
            sock.writeBuf.put((byte)-128);
            sock.writeBuf.put((byte)8);
            sock.writeBuf.putShort((short)0);
            sock.writeBuf.putInt(0);
            sock.writeBuf.putLong(0L);
            sock.writeBuf.putLong(0L);
            try {
                sock.flush();
                DataInputStream dis = new DataInputStream(new SockInputStream(sock, Integer.MAX_VALUE));
                dis.readInt();
                dis.readShort();
                success = dis.readShort() == 0 ? success : false;
                dis.close();
                continue;
            }
            catch (IOException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnFlush(this, e);
                }
                LOG.error("++++ exception thrown while writing bytes to server on flushAll");
                LOG.error(e.getMessage(), (Throwable)e);
                try {
                    sock.sockets.invalidateObject(sock);
                }
                catch (Exception e1) {
                    LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
                }
                success = false;
                sock = null;
                continue;
            }
            finally {
                if (sock != null) {
                    sock.close();
                    sock = null;
                }
            }
        }
        return success;
    }

    @Override
    public Map<String, Map<String, String>> stats() {
        return this.stats(null);
    }

    @Override
    public Map<String, Map<String, String>> stats(String[] servers) {
        return this.stats(servers, (byte)16, null);
    }

    @Override
    public Map<String, Map<String, String>> statsItems() {
        return this.statsItems(null);
    }

    @Override
    public Map<String, Map<String, String>> statsItems(String[] servers) {
        return this.stats(servers, (byte)16, "items".getBytes());
    }

    @Override
    public Map<String, Map<String, String>> statsSlabs() {
        return this.statsSlabs(null);
    }

    @Override
    public Map<String, Map<String, String>> statsSlabs(String[] servers) {
        return this.stats(servers, (byte)16, "slabs".getBytes());
    }

    @Override
    public Map<String, Map<String, String>> statsCacheDump(int slabNumber, int limit) {
        return this.statsCacheDump(null, slabNumber, limit);
    }

    @Override
    public Map<String, Map<String, String>> statsCacheDump(String[] servers, int slabNumber, int limit) {
        return this.stats(servers, (byte)16, String.format("cachedump %d %d", slabNumber, limit).getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> stats(String[] servers, byte opcode, byte[] reqKey) {
        String[] stringArray = servers = servers == null ? this.pool.getServers() : servers;
        if (servers == null || servers.length <= 0) {
            LOG.error("++++ no servers to check stats");
            return null;
        }
        HashMap<String, Map<String, String>> statsMaps = new HashMap<String, Map<String, String>>();
        for (int i = 0; i < servers.length; ++i) {
            SchoonerSockIO sock = this.pool.getConnection(servers[i]);
            if (sock == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnStats(this, new IOException("no socket to server available"));
                continue;
            }
            try {
                HashMap<String, String> stats = new HashMap<String, String>();
                sock.writeBuf.clear();
                sock.writeBuf.put((byte)-128);
                sock.writeBuf.put(opcode);
                if (reqKey != null) {
                    sock.writeBuf.putShort((short)reqKey.length);
                } else {
                    sock.writeBuf.putShort((short)0);
                }
                sock.writeBuf.put((byte)0);
                sock.writeBuf.put((byte)0);
                sock.writeBuf.putShort((short)0);
                sock.writeBuf.putInt(0);
                sock.writeBuf.putInt(0);
                sock.writeBuf.putLong(0L);
                if (reqKey != null) {
                    sock.writeBuf.put(reqKey);
                }
                sock.writeBuf.flip();
                sock.getChannel().write(sock.writeBuf);
                DataInputStream input = new DataInputStream(new SockInputStream(sock, Integer.MAX_VALUE));
                while (true) {
                    input.skip(2L);
                    short statKeyLen = input.readShort();
                    input.skip(4L);
                    int statValLen = input.readInt() - statKeyLen;
                    input.skip(12L);
                    if (statKeyLen == 0) break;
                    byte[] key = new byte[statKeyLen];
                    byte[] value = new byte[statValLen];
                    input.read(key);
                    input.read(value);
                    stats.put(new String(key), new String(value));
                }
                statsMaps.put(servers[i], stats);
                input.close();
                continue;
            }
            catch (IOException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnStats(this, e);
                }
                LOG.error("++++ exception thrown while writing bytes to server on stats");
                LOG.error(e.getMessage(), (Throwable)e);
                try {
                    sock.sockets.invalidateObject(sock);
                }
                catch (Exception e1) {
                    LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
                }
                sock = null;
                continue;
            }
            finally {
                if (sock != null) {
                    sock.close();
                    sock = null;
                }
            }
        }
        return statsMaps;
    }

    @Override
    public boolean sync(String key, Integer hashCode) {
        return false;
    }

    @Override
    public boolean sync(String key) {
        return this.sync(key, null);
    }

    @Override
    public boolean syncAll() {
        return this.syncAll(null);
    }

    @Override
    public boolean syncAll(String[] servers) {
        return false;
    }

    @Override
    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public void setPrimitiveAsString(boolean primitiveAsString) {
        this.primitiveAsString = primitiveAsString;
    }

    @Override
    public void setSanitizeKeys(boolean sanitizeKeys) {
        this.sanitizeKeys = sanitizeKeys;
    }

    private String sanitizeKey(String key) throws UnsupportedEncodingException {
        return this.sanitizeKeys ? URLEncoder.encode(key, "UTF-8") : key;
    }

    @Override
    public Object get(String key, Integer hashCode, boolean asString) {
        return this.get((byte)0, key, hashCode, asString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object get(byte opCode, String key, Integer hashCode, boolean asString) {
        if (key == null) {
            LOG.error("key is null for get()");
            return null;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)e, key);
            }
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return null;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), key);
            }
            return null;
        }
        try {
            byte[] buf = key.getBytes();
            sock.writeBuf.clear();
            sock.writeBuf.put((byte)-128);
            sock.writeBuf.put(opCode);
            sock.writeBuf.putShort((short)buf.length);
            sock.writeBuf.putInt(0);
            sock.writeBuf.putInt(buf.length);
            sock.writeBuf.putInt(0);
            sock.writeBuf.putLong(0L);
            sock.writeBuf.put(buf);
            sock.flush();
            int dataSize = 0;
            int flag = 0;
            SockInputStream input = new SockInputStream(sock, Integer.MAX_VALUE);
            DataInputStream dis = new DataInputStream(input);
            dis.readInt();
            byte extra = dis.readByte();
            dis.readByte();
            if (0 == dis.readShort()) {
                dataSize = dis.readInt() - extra;
                dis.readInt();
                dis.readLong();
            }
            flag = dis.readInt();
            Object o = null;
            input.willRead(dataSize);
            if (dataSize > 0) {
                if (NativeHandler.isHandled(flag)) {
                    buf = input.getBuffer();
                    if ((flag & 2) == 2) {
                        int count;
                        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
                        byte[] tmp = new byte[2048];
                        while ((count = gzi.read(tmp)) != -1) {
                            bos.write(tmp, 0, count);
                        }
                        buf = bos.toByteArray();
                        gzi.close();
                    }
                    o = this.primitiveAsString || asString ? new String(buf, this.defaultEncoding) : NativeHandler.decode(buf, flag);
                } else if (this.transCoder != null) {
                    InputStream in = input;
                    if ((flag & 2) == 2) {
                        in = new GZIPInputStream(in);
                    }
                    o = this.classLoader == null ? this.transCoder.decode(in) : ((ObjectTransCoder)this.transCoder).decode(in, this.classLoader);
                }
            }
            Object object = o;
            return object;
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, e, key);
            }
            LOG.error("++++ exception thrown while writing bytes to server on get");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
            }
            sock = null;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemcachedItem gets(byte opCode, String key, Integer hashCode, boolean asString) {
        if (key == null) {
            LOG.error("key is null for get()");
            return null;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)e, key);
            }
            LOG.error("failed to sanitize your key!", (Throwable)e);
            return null;
        }
        SchoonerSockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), key);
            }
            return null;
        }
        try {
            byte[] buf = key.getBytes();
            sock.writeBuf.clear();
            sock.writeBuf.put((byte)-128);
            sock.writeBuf.put(opCode);
            sock.writeBuf.putShort((short)buf.length);
            sock.writeBuf.putInt(0);
            sock.writeBuf.putInt(buf.length);
            sock.writeBuf.putInt(0);
            sock.writeBuf.putLong(0L);
            sock.writeBuf.put(buf);
            sock.flush();
            int dataSize = 0;
            int flag = 0;
            MemcachedItem item = new MemcachedItem();
            SockInputStream input = new SockInputStream(sock, Integer.MAX_VALUE);
            DataInputStream dis = new DataInputStream(input);
            dis.readInt();
            byte extra = dis.readByte();
            dis.readByte();
            if (0 == dis.readShort()) {
                dataSize = dis.readInt() - extra;
                dis.readInt();
                item.casUnique = dis.readLong();
            }
            flag = dis.readInt();
            Object o = null;
            input.willRead(dataSize);
            if (dataSize > 0) {
                if (NativeHandler.isHandled(flag)) {
                    buf = input.getBuffer();
                    if ((flag & 2) == 2) {
                        int count;
                        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
                        byte[] tmp = new byte[2048];
                        while ((count = gzi.read(tmp)) != -1) {
                            bos.write(tmp, 0, count);
                        }
                        buf = bos.toByteArray();
                        gzi.close();
                    }
                    o = this.primitiveAsString || asString ? new String(buf, this.defaultEncoding) : NativeHandler.decode(buf, flag);
                } else if (this.transCoder != null) {
                    InputStream in = input;
                    if ((flag & 2) == 2) {
                        in = new GZIPInputStream(in);
                    }
                    o = this.classLoader == null ? this.transCoder.decode(in) : ((ObjectTransCoder)this.transCoder).decode(in, this.classLoader);
                }
            }
            item.value = o;
            MemcachedItem memcachedItem = item;
            return memcachedItem;
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, e, key);
            }
            LOG.error("++++ exception thrown while writing bytes to server on get");
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                sock.sockets.invalidateObject(sock);
            }
            catch (Exception e1) {
                LOG.error("++++ failed to close socket : " + sock.toString(), (Throwable)e1);
            }
            sock = null;
        }
        finally {
            if (sock != null) {
                sock.close();
                sock = null;
            }
        }
        return null;
    }

    @Override
    public Object[] getMultiArray(String[] keys, Integer[] hashCodes, boolean asString) {
        Map<String, Object> data = this.getMulti(keys, hashCodes, asString);
        if (data == null) {
            return null;
        }
        Object[] res = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            res[i] = data.get(keys[i]);
        }
        return res;
    }

    protected final class NIOLoader {
        protected Selector selector;
        protected int numConns = 0;
        protected BinaryClient mc;
        protected Connection[] conns;

        public NIOLoader(BinaryClient mc) {
            this.mc = mc;
        }

        public void doMulti(Map<String, ArrayList<String>> sockKeys, String[] keys, Map<String, Object> ret) {
            this.doMulti(false, sockKeys, keys, ret);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doMulti(boolean asString, Map<String, ArrayList<String>> sockKeys, String[] keys, Map<String, Object> ret) {
            long timeRemaining = 0L;
            try {
                long timeout;
                this.selector = Selector.open();
                this.conns = new Connection[sockKeys.keySet().size()];
                this.numConns = 0;
                for (String host : sockKeys.keySet()) {
                    SchoonerSockIO sock = BinaryClient.this.pool.getConnection(host);
                    if (sock == null) {
                        return;
                    }
                    this.conns[this.numConns++] = new Connection(this, sock, sockKeys.get(host));
                }
                long startTime = System.currentTimeMillis();
                timeRemaining = timeout = BinaryClient.this.pool.getMaxBusy();
                while (this.numConns > 0 && timeRemaining > 0L) {
                    int n = this.selector.select(Math.min(timeout, 5000L));
                    if (n > 0) {
                        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                        while (it.hasNext()) {
                            SelectionKey key = it.next();
                            it.remove();
                            this.handleKey(key);
                        }
                    } else {
                        LOG.error("selector timed out waiting for activity");
                    }
                    timeRemaining = timeout - (System.currentTimeMillis() - startTime);
                }
            }
            catch (IOException e) {
                LOG.error("Caught the exception on " + String.valueOf(e));
                return;
            }
            finally {
                try {
                    if (this.selector != null) {
                        this.selector.close();
                    }
                }
                catch (IOException iOException) {}
                for (Connection c : this.conns) {
                    if (c == null) continue;
                    c.close();
                }
            }
            for (Connection c : this.conns) {
                try {
                    if (c.incoming.size() <= 0 || !c.isDone()) continue;
                    BinaryClient.this.loadMulti(new DataInputStream(new ByteBufArrayInputStream(c.incoming)), ret);
                }
                catch (Exception e) {
                    LOG.debug("Caught the aforementioned exception on " + String.valueOf(c));
                }
            }
        }

        private void handleKey(SelectionKey key) throws IOException {
            if (key.isReadable()) {
                this.readResponse(key);
            } else if (key.isWritable()) {
                this.writeRequest(key);
            }
        }

        public void writeRequest(SelectionKey key) throws IOException {
            ByteBuffer buf = ((Connection)key.attachment()).outgoing;
            SocketChannel sc = (SocketChannel)key.channel();
            if (buf.hasRemaining()) {
                sc.write(buf);
            }
            if (!buf.hasRemaining()) {
                key.interestOps(1);
            }
        }

        public void readResponse(SelectionKey key) throws IOException {
            Connection conn = (Connection)key.attachment();
            ByteBuffer buf = conn.getBuffer();
            int count = conn.channel.read(buf);
            if (count > 0 && conn.isDone()) {
                key.cancel();
                --this.numConns;
                return;
            }
        }

        private final class Connection {
            public List<ByteBuffer> incoming = new ArrayList<ByteBuffer>();
            public ByteBuffer outgoing;
            public SchoonerSockIO sock;
            public SocketChannel channel;
            private boolean isDone = false;
            private final byte[] NOOPFLAG = new byte[]{-127, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

            public Connection(NIOLoader nIOLoader, SchoonerSockIO sock, ArrayList<String> keys) throws IOException {
                byte[] buf;
                this.sock = sock;
                ArrayList<byte[]> bufList = new ArrayList<byte[]>(keys.size());
                int size = 0;
                for (String key : keys) {
                    buf = key.getBytes();
                    bufList.add(buf);
                    size += buf.length;
                }
                this.outgoing = ByteBuffer.allocateDirect(size += (bufList.size() + 1) * 24);
                this.outgoing.clear();
                for (String key : keys) {
                    buf = key.getBytes();
                    this.outgoing.put((byte)-128);
                    this.outgoing.put((byte)13);
                    this.outgoing.putShort((short)buf.length);
                    this.outgoing.putInt(0);
                    this.outgoing.putInt(buf.length);
                    this.outgoing.putInt(0);
                    this.outgoing.putLong(0L);
                    this.outgoing.put(buf);
                }
                this.outgoing.put((byte)-128);
                this.outgoing.put((byte)10);
                this.outgoing.putShort((short)0);
                this.outgoing.putInt(0);
                this.outgoing.putLong(0L);
                this.outgoing.putLong(0L);
                this.outgoing.flip();
                this.channel = sock.getChannel();
                if (this.channel == null) {
                    throw new IOException("dead connection to: " + sock.getHost());
                }
                this.channel.configureBlocking(false);
                this.channel.register(nIOLoader.selector, 4, this);
            }

            public void close() {
                try {
                    if (this.isDone) {
                        this.channel.configureBlocking(true);
                        this.sock.close();
                        return;
                    }
                }
                catch (IOException e) {
                    LOG.warn("++++ memcache: unexpected error closing normally", (Throwable)e);
                }
                try {
                    this.sock.sockets.invalidateObject(this.sock);
                }
                catch (Exception e1) {
                    LOG.error("++++ failed to close socket : " + this.sock.toString(), (Throwable)e1);
                }
            }

            public boolean isDone() {
                if (this.isDone) {
                    return true;
                }
                int strPos = this.NOOPFLAG.length - 1;
                for (int bi = this.incoming.size() - 1; bi >= 0 && strPos >= 0; --bi) {
                    ByteBuffer buf = this.incoming.get(bi);
                    int pos = buf.position() - 1;
                    while (pos >= 0 && strPos >= 0) {
                        if (buf.get(pos--) == this.NOOPFLAG[strPos--]) continue;
                        return false;
                    }
                }
                this.isDone = strPos < 0;
                return this.isDone;
            }

            public ByteBuffer getBuffer() {
                int last = this.incoming.size() - 1;
                if (last >= 0 && this.incoming.get(last).hasRemaining()) {
                    return this.incoming.get(last);
                }
                ByteBuffer newBuf = ByteBuffer.allocate(8192);
                this.incoming.add(newBuf);
                return newBuf;
            }

            public String toString() {
                return new StringBuffer().append("Connection to ").append(this.sock.getHost()).append(" with ").append(this.incoming.size()).append(" bufs; done is ").append(this.isDone).toString();
            }
        }
    }
}

