/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.SchoonerSockIOPool;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class SchoonerSockIOFactory
extends BasePooledObjectFactory<SchoonerSockIO> {
    protected GenericObjectPool<SchoonerSockIO> sockets;
    protected String host;
    protected int bufferSize;
    protected int socketTO;
    protected int socketConnectTO;
    protected boolean isTcp;
    protected boolean nagle;

    public SchoonerSockIOFactory(String host, boolean isTcp, int bufferSize, int socketTO, int socketConnectTO, boolean nagle) {
        this.host = host;
        this.isTcp = isTcp;
        this.bufferSize = bufferSize;
        this.socketTO = socketTO;
        this.socketConnectTO = socketConnectTO;
        this.nagle = nagle;
    }

    @Override
    public PooledObject<SchoonerSockIO> makeObject() throws Exception {
        return this.wrap(this.create());
    }

    @Override
    public SchoonerSockIO create() throws Exception {
        return this.createSocket(this.host);
    }

    @Override
    public PooledObject<SchoonerSockIO> wrap(SchoonerSockIO arg0) {
        return new DefaultPooledObject<SchoonerSockIO>(arg0);
    }

    protected final SchoonerSockIO createSocket(String host) throws Exception {
        SchoonerSockIO socket = null;
        socket = this.isTcp ? new SchoonerSockIOPool.TCPSockIO(this.sockets, host, this.bufferSize, this.socketTO, this.socketConnectTO, this.nagle) : new SchoonerSockIOPool.UDPSockIO(this.sockets, host, this.bufferSize, this.socketTO);
        return socket;
    }

    public void setSockets(GenericObjectPool<SchoonerSockIO> sockets) {
        this.sockets = sockets;
    }
}

