/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.AuthInfo;
import com.schooner.MemCached.AuthSchoonerSockIOFactory;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.SchoonerSockIOFactory;
import com.schooner.MemCached.command.DeletionCommand;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.CRC32;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SchoonerSockIOPool {
    private static final Logger LOG = LogManager.getLogger(DeletionCommand.class);
    private static ConcurrentMap<String, SchoonerSockIOPool> pools = new ConcurrentHashMap<String, SchoonerSockIOPool>();
    private static ThreadLocal<MessageDigest> MD5 = new ThreadLocal<MessageDigest>(){

        @Override
        protected final MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("++++ no md5 algorithm found");
                throw new IllegalStateException("++++ no md5 algorythm found");
            }
        }
    };
    public static final int NATIVE_HASH = 0;
    public static final int OLD_COMPAT_HASH = 1;
    public static final int NEW_COMPAT_HASH = 2;
    public static final int CONSISTENT_HASH = 3;
    public static final long MAX_RETRY_DELAY = 600000L;
    boolean initialized = false;
    private int minConn = 8;
    private int maxConn = 32;
    private long maxBusyTime = 30000L;
    private long maintSleep = 30000L;
    private int socketTO = 30000;
    private int socketConnectTO = 3000;
    private GenericObjectPoolConfig<SchoonerSockIO> config = new GenericObjectPoolConfig();
    private long maxWait = 1000L;
    private int maxIdle = this.maxConn;
    private int minIdle = 0;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private long timeBetweenEvictionRunsMillis = GenericObjectPoolConfig.DEFAULT_TIME_BETWEEN_EVICTION_RUNS.getSeconds();
    private int numTestsPerEvictionRun = 3;
    private long minEvictableIdleTimeMillis = GenericObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_DURATION.getSeconds();
    private boolean testWhileIdle = true;
    private long softMinEvictableIdleTimeMillis = GenericObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_DURATION.getSeconds();
    private boolean lifo = true;
    private boolean aliveCheck = false;
    private boolean failover = true;
    private boolean failback = true;
    private boolean nagle = false;
    private int hashingAlg = 0;
    private final ReentrantLock initDeadLock = new ReentrantLock();
    private String[] servers;
    private Integer[] weights;
    private Integer totalWeight = 0;
    private List<String> buckets;
    private TreeMap<Long, String> consistentBuckets;
    Map<String, GenericObjectPool<SchoonerSockIO>> socketPool;
    ConcurrentMap<String, Date> hostDead;
    ConcurrentMap<String, Long> hostDeadDur;
    private AuthInfo authInfo;
    private boolean isTcp;
    private int bufferSize = 0x100400;

    protected SchoonerSockIOPool(boolean isTcp) {
        this.isTcp = isTcp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchoonerSockIOPool getInstance(String poolName) {
        ConcurrentMap<String, SchoonerSockIOPool> concurrentMap = pools;
        synchronized (concurrentMap) {
            if (!pools.containsKey(poolName)) {
                SchoonerSockIOPool pool = new SchoonerSockIOPool(true);
                pools.putIfAbsent(poolName, pool);
            }
        }
        return (SchoonerSockIOPool)pools.get(poolName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchoonerSockIOPool getInstance(String poolName, AuthInfo authInfo) {
        ConcurrentMap<String, SchoonerSockIOPool> concurrentMap = pools;
        synchronized (concurrentMap) {
            if (!pools.containsKey(poolName)) {
                SchoonerSockIOPool pool = new SchoonerSockIOPool(true);
                pool.authInfo = authInfo;
                pools.putIfAbsent(poolName, pool);
            }
        }
        return (SchoonerSockIOPool)pools.get(poolName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchoonerSockIOPool getInstance(String poolName, boolean isTcp) {
        SchoonerSockIOPool pool;
        ConcurrentMap<String, SchoonerSockIOPool> concurrentMap = pools;
        synchronized (concurrentMap) {
            if (pools.containsKey(poolName)) {
                SchoonerSockIOPool pool2 = (SchoonerSockIOPool)pools.get(poolName);
                if (pool2.isTcp() == isTcp) {
                    return pool2;
                }
                return null;
            }
            pool = new SchoonerSockIOPool(isTcp);
            pools.putIfAbsent(poolName, pool);
        }
        return pool;
    }

    public static SchoonerSockIOPool getInstance() {
        return SchoonerSockIOPool.getInstance("default", true);
    }

    public static SchoonerSockIOPool getInstance(AuthInfo authInfo) {
        return SchoonerSockIOPool.getInstance("default", authInfo);
    }

    public static SchoonerSockIOPool getInstance(boolean isTcp) {
        return SchoonerSockIOPool.getInstance("default", isTcp);
    }

    public void initialize() {
        this.initDeadLock.lock();
        try {
            if (this.servers == null || this.servers.length <= 0) {
                LOG.error("++++ trying to initialize with no servers");
                throw new IllegalStateException("++++ trying to initialize with no servers");
            }
            this.socketPool = new HashMap<String, GenericObjectPool<SchoonerSockIO>>(this.servers.length);
            this.hostDead = new ConcurrentHashMap<String, Date>();
            this.hostDeadDur = new ConcurrentHashMap<String, Long>();
            if (this.hashingAlg == 3) {
                this.populateConsistentBuckets();
            } else {
                this.populateBuckets();
            }
            this.initialized = true;
        }
        finally {
            this.initDeadLock.unlock();
        }
    }

    public boolean isTcp() {
        return this.isTcp;
    }

    private void populateBuckets() {
        this.buckets = new ArrayList<String>();
        for (int i = 0; i < this.servers.length; ++i) {
            if (this.weights != null && this.weights.length > i) {
                for (int k = 0; k < this.weights[i]; ++k) {
                    this.buckets.add(this.servers[i]);
                }
            } else {
                this.buckets.add(this.servers[i]);
            }
            SchoonerSockIOFactory factory = this.authInfo != null ? new AuthSchoonerSockIOFactory(this.servers[i], this.isTcp, this.bufferSize, this.socketTO, this.socketConnectTO, this.nagle, this.authInfo) : new SchoonerSockIOFactory(this.servers[i], this.isTcp, this.bufferSize, this.socketTO, this.socketConnectTO, this.nagle);
            GenericObjectPool<SchoonerSockIO> gop = new GenericObjectPool<SchoonerSockIO>(factory, this.config);
            factory.setSockets(gop);
            this.socketPool.put(this.servers[i], gop);
        }
    }

    private void populateConsistentBuckets() {
        int i;
        this.consistentBuckets = new TreeMap();
        MessageDigest md5 = MD5.get();
        if (this.totalWeight <= 0 && this.weights != null) {
            for (i = 0; i < this.weights.length; ++i) {
                this.totalWeight = this.totalWeight + (this.weights[i] == null ? 1 : this.weights[i]);
            }
        } else if (this.weights == null) {
            this.totalWeight = this.servers.length;
        }
        for (i = 0; i < this.servers.length; ++i) {
            int thisWeight = 1;
            if (this.weights != null && this.weights[i] != null) {
                thisWeight = this.weights[i];
            }
            double factor = Math.floor((double)(40 * this.servers.length * thisWeight) / (double)this.totalWeight.intValue());
            long j = 0L;
            while ((double)j < factor) {
                byte[] d = md5.digest((this.servers[i] + "-" + j).getBytes());
                for (int h = 0; h < 4; ++h) {
                    Long k = (long)(d[3 + h * 4] & 0xFF) << 24 | (long)(d[2 + h * 4] & 0xFF) << 16 | (long)(d[1 + h * 4] & 0xFF) << 8 | (long)(d[0 + h * 4] & 0xFF);
                    this.consistentBuckets.put(k, this.servers[i]);
                }
                ++j;
            }
            SchoonerSockIOFactory factory = this.authInfo != null ? new AuthSchoonerSockIOFactory(this.servers[i], this.isTcp, this.bufferSize, this.socketTO, this.socketConnectTO, this.nagle, this.authInfo) : new SchoonerSockIOFactory(this.servers[i], this.isTcp, this.bufferSize, this.socketTO, this.socketConnectTO, this.nagle);
            GenericObjectPool<SchoonerSockIO> gop = new GenericObjectPool<SchoonerSockIO>(factory, this.config);
            factory.setSockets(gop);
            this.socketPool.put(this.servers[i], gop);
        }
    }

    protected void clearHostFromPool(String host) {
        GenericObjectPool<SchoonerSockIO> pool = this.socketPool.get(host);
        pool.clear();
    }

    public final String getHost(String key) {
        return this.getHost(key, null);
    }

    public final String getHost(String key, Integer hashcode) {
        SchoonerSockIO socket = this.getSock(key, hashcode);
        String host = socket.getHost();
        socket.close();
        return host;
    }

    public final SchoonerSockIO getSock(String key) {
        return this.getSock(key, null);
    }

    public final SchoonerSockIO getSock(String key, Integer hashCode) {
        String server;
        if (!this.initialized) {
            LOG.error("attempting to get SockIO from uninitialized pool!");
            return null;
        }
        int size = 0;
        if (this.hashingAlg == 3 && this.consistentBuckets.size() == 0 || this.buckets != null && (size = this.buckets.size()) == 0) {
            return null;
        }
        if (size == 1) {
            SchoonerSockIO sock = this.hashingAlg == 3 ? this.getConnection(this.consistentBuckets.get(this.consistentBuckets.firstKey())) : this.getConnection(this.buckets.get(0));
            return sock;
        }
        HashSet<String> tryServers = new HashSet<String>(Arrays.asList(this.servers));
        long bucket = this.getBucket(key, hashCode);
        String string = server = this.hashingAlg == 3 ? this.consistentBuckets.get(bucket) : this.buckets.get((int)bucket);
        while (!tryServers.isEmpty()) {
            SchoonerSockIO sock = this.getConnection(server);
            if (sock != null) {
                return sock;
            }
            if (!this.failover) {
                return null;
            }
            tryServers.remove(server);
            if (tryServers.isEmpty()) break;
            int rehashTries = 0;
            while (!tryServers.contains(server)) {
                String newKey = new StringBuffer().append(rehashTries).append(key).toString();
                bucket = this.getBucket(newKey, null);
                server = this.hashingAlg == 3 ? this.consistentBuckets.get(bucket) : this.buckets.get((int)bucket);
                ++rehashTries;
            }
        }
        return null;
    }

    public final SchoonerSockIO getConnection(String host) {
        SchoonerSockIO socket;
        if (!this.initialized) {
            LOG.error("attempting to get SockIO from uninitialized pool!");
            return null;
        }
        if (host == null) {
            return null;
        }
        if (!this.failback && this.hostDead.containsKey(host) && this.hostDeadDur.containsKey(host)) {
            Date store = (Date)this.hostDead.get(host);
            long expire = (Long)this.hostDeadDur.get(host);
            if (store.getTime() + expire > System.currentTimeMillis()) {
                return null;
            }
        }
        GenericObjectPool<SchoonerSockIO> sockets = this.socketPool.get(host);
        try {
            socket = sockets.borrowObject();
        }
        catch (Exception e) {
            socket = null;
        }
        if (socket == null) {
            long expire;
            Date now = new Date();
            this.hostDead.put(host, now);
            long l = expire = this.hostDeadDur.containsKey(host) ? (Long)this.hostDeadDur.get(host) * 2L : 1000L;
            if (expire > 600000L) {
                expire = 600000L;
            }
            this.hostDeadDur.put(host, expire);
            sockets.clear();
        }
        return socket;
    }

    protected final void closeSocketPool() {
        for (GenericObjectPool<SchoonerSockIO> sockets : this.socketPool.values()) {
            try {
                sockets.close();
            }
            catch (Exception e) {
                LOG.error("++++ failed to close socket pool.");
            }
        }
    }

    public void shutDown() {
        this.closeSocketPool();
        this.socketPool.clear();
        this.socketPool = null;
        this.buckets = null;
        this.consistentBuckets = null;
        this.initialized = false;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final void setServers(String[] servers) {
        this.servers = servers;
    }

    public final String[] getServers() {
        return this.servers;
    }

    public final void setWeights(Integer[] weights) {
        this.weights = weights;
    }

    public final Integer[] getWeights() {
        return this.weights;
    }

    public final void setInitConn(int initConn) {
        if (initConn < this.minConn) {
            this.minConn = initConn;
        }
    }

    public final int getInitConn() {
        return this.minConn;
    }

    public final void setMaxBusyTime(long maxBusyTime) {
        this.maxBusyTime = maxBusyTime;
    }

    public final long getMaxBusy() {
        return this.maxBusyTime;
    }

    public void setMaintSleep(long maintSleep) {
        this.maintSleep = maintSleep;
    }

    public long getMaintSleep() {
        return this.maintSleep;
    }

    public final void setSocketTO(int socketTO) {
        this.socketTO = socketTO;
    }

    public final int getSocketTO() {
        return this.socketTO;
    }

    public final void setSocketConnectTO(int socketConnectTO) {
        this.socketConnectTO = socketConnectTO;
    }

    public final int getSocketConnectTO() {
        return this.socketConnectTO;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public final long getMaxWait() {
        return this.maxWait;
    }

    public final void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public final int getMinIdle() {
        return this.minIdle;
    }

    public final void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public final boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public final void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public final boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public final void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public final long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public final void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public final int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public final void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public final long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public final void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public final boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public final void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public final long getSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        return this.softMinEvictableIdleTimeMillis;
    }

    public final void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
    }

    public final boolean getLifo() {
        return this.lifo;
    }

    public final void setLifo(boolean lifo) {
        this.lifo = lifo;
    }

    public final void setFailover(boolean failover) {
        this.failover = failover;
    }

    public final boolean getFailover() {
        return this.failover;
    }

    public void setFailback(boolean failback) {
        this.failback = failback;
    }

    public boolean getFailback() {
        return this.failback;
    }

    public final void setAliveCheck(boolean aliveCheck) {
        this.aliveCheck = aliveCheck;
    }

    public final boolean getAliveCheck() {
        return this.aliveCheck;
    }

    public final void setNagle(boolean nagle) {
        this.nagle = nagle;
    }

    public final boolean getNagle() {
        return this.nagle;
    }

    public final void setHashingAlg(int alg) {
        this.hashingAlg = alg;
    }

    public final int getHashingAlg() {
        return this.hashingAlg;
    }

    private static long origCompatHashingAlg(String key) {
        long hash = 0L;
        char[] cArr = key.toCharArray();
        for (int i = 0; i < cArr.length; ++i) {
            hash = hash * 33L + (long)cArr[i];
        }
        return hash;
    }

    private static long newCompatHashingAlg(String key) {
        CRC32 checksum = new CRC32();
        checksum.update(key.getBytes());
        long crc = checksum.getValue();
        return crc >> 16 & 0x7FFFL;
    }

    private static long md5HashingAlg(String key) {
        MessageDigest md5 = MD5.get();
        md5.reset();
        md5.update(key.getBytes());
        byte[] bKey = md5.digest();
        long res = (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
        return res;
    }

    private final long getHash(String key, Integer hashCode) {
        if (hashCode != null) {
            if (this.hashingAlg == 3) {
                return hashCode.longValue() & 0xFFFFFFFFL;
            }
            return hashCode.longValue();
        }
        switch (this.hashingAlg) {
            case 0: {
                return key.hashCode();
            }
            case 1: {
                return SchoonerSockIOPool.origCompatHashingAlg(key);
            }
            case 2: {
                return SchoonerSockIOPool.newCompatHashingAlg(key);
            }
            case 3: {
                return SchoonerSockIOPool.md5HashingAlg(key);
            }
        }
        this.hashingAlg = 0;
        return key.hashCode();
    }

    private final long getBucket(String key, Integer hashCode) {
        long hc = this.getHash(key, hashCode);
        if (this.hashingAlg == 3) {
            return this.findPointFor(hc);
        }
        long bucket = hc % (long)this.buckets.size();
        if (bucket < 0L) {
            bucket *= -1L;
        }
        return bucket;
    }

    private final Long findPointFor(Long hv) {
        SortedMap<Long, String> tmap = this.consistentBuckets.tailMap(hv);
        return tmap.isEmpty() ? this.consistentBuckets.firstKey() : tmap.firstKey();
    }

    public void setMaxConn(int maxConn) {
        this.maxConn = maxConn;
    }

    public int getMaxConn() {
        return this.maxConn;
    }

    public void setMinConn(int minConn) {
        this.minConn = minConn;
    }

    public int getMinConn() {
        return this.minConn;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public static class TCPSockIO
    extends SchoonerSockIO {
        private String host;
        private Socket sock;
        public SocketChannel sockChannel;
        private int hash = 0;

        public TCPSockIO(GenericObjectPool<SchoonerSockIO> sockets, String host, int bufferSize, int timeout, int connectTimeout, boolean noDelay) throws IOException, UnknownHostException {
            super(sockets, bufferSize);
            String[] ip = host.split(":");
            this.sock = TCPSockIO.getSocket(ip[0], Integer.parseInt(ip[1]), connectTimeout);
            this.writeBuf = ByteBuffer.allocateDirect(bufferSize);
            if (timeout >= 0) {
                this.sock.setSoTimeout(timeout);
            }
            this.sock.setTcpNoDelay(noDelay);
            this.sockChannel = this.sock.getChannel();
            this.hash = this.sock.hashCode();
            this.host = host;
        }

        protected static final Socket getSocket(String host, int port, int timeout) throws IOException {
            SocketChannel sock = SocketChannel.open();
            try {
                sock.socket().connect(new InetSocketAddress(host, port), timeout);
            }
            catch (IOException e) {
                sock.socket().close();
                throw e;
            }
            return sock.socket();
        }

        @Override
        public final SocketChannel getChannel() {
            return this.sock.getChannel();
        }

        @Override
        public final String getHost() {
            return this.host;
        }

        @Override
        public final void trueClose() throws IOException {
            this.readBuf.clear();
            boolean err = false;
            StringBuilder errMsg = new StringBuilder();
            if (this.sockChannel == null || this.sock == null) {
                err = true;
                errMsg.append("++++ socket or its streams already null in trueClose call");
            }
            if (this.sockChannel != null) {
                try {
                    this.sockChannel.close();
                }
                catch (IOException ioe) {
                    LOG.error("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost());
                    LOG.error(ioe.getMessage(), (Throwable)ioe);
                    errMsg.append("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException ioe) {
                    LOG.error("++++ error closing socket: " + this.toString() + " for host: " + this.getHost());
                    LOG.error(ioe.getMessage(), (Throwable)ioe);
                    errMsg.append("++++ error closing socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            this.sockChannel = null;
            this.sock = null;
            if (err) {
                throw new IOException(errMsg.toString());
            }
        }

        @Override
        public final void close() {
            this.readBuf.clear();
            try {
                this.sockets.returnObject(this);
            }
            catch (Exception e) {
                LOG.error("++++ error closing socket: " + this.toString() + " for host: " + this.getHost());
            }
        }

        @Override
        public boolean isConnected() {
            return this.sock != null && this.sock.isConnected();
        }

        public final void readBytes(int length) throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                LOG.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            while (length > 0) {
                int readCount = this.sockChannel.read(this.readBuf);
                length -= readCount;
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                LOG.error("++++ attempting to write to closed socket");
                throw new IOException("++++ attempting to write to closed socket");
            }
            this.sockChannel.write(ByteBuffer.wrap(b));
        }

        @Override
        public void flush() throws IOException {
            this.writeBuf.flip();
            this.sockChannel.write(this.writeBuf);
        }

        @Override
        public final int hashCode() {
            return this.sock == null ? 0 : this.hash;
        }

        @Override
        public final String toString() {
            return this.sock == null ? "" : this.sock.toString();
        }

        @Override
        protected final void finalize() throws Throwable {
            try {
                if (this.sock != null) {
                    this.sock.close();
                    this.sock = null;
                }
            }
            catch (Throwable t) {
                LOG.error(t.getMessage(), t);
            }
            finally {
                super.finalize();
            }
        }

        @Override
        public short preWrite() {
            return 0;
        }

        @Override
        public byte[] getResponse(short rid) throws IOException {
            return null;
        }

        @Override
        public void clearEOL() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                LOG.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] b = new byte[1];
            boolean eol = false;
            InputStream in = this.sock.getInputStream();
            while (in.read(b, 0, 1) != -1) {
                if (b[0] == 13) {
                    eol = true;
                    continue;
                }
                if (!eol) continue;
                if (b[0] == 10) break;
                eol = false;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            int count;
            int cnt;
            if (this.sock == null || !this.sock.isConnected()) {
                LOG.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            InputStream in = this.sock.getInputStream();
            for (count = 0; count < b.length; count += cnt) {
                cnt = in.read(b, count, b.length - count);
            }
            return count;
        }

        @Override
        public String readLine() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                LOG.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] b = new byte[1];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            boolean eol = false;
            InputStream in = this.sock.getInputStream();
            while (in.read(b, 0, 1) != -1) {
                if (b[0] == 13) {
                    eol = true;
                } else if (eol) {
                    if (b[0] == 10) break;
                    eol = false;
                }
                bos.write(b, 0, 1);
            }
            if (bos == null || bos.size() <= 0) {
                throw new IOException("++++ Stream appears to be dead, so closing it down");
            }
            return bos.toString().trim();
        }

        @Override
        public void trueClose(boolean addToDeadPool) throws IOException {
            this.trueClose();
        }

        @Override
        public ByteChannel getByteChannel() {
            return this.sockChannel;
        }
    }

    public static class UDPSockIO
    extends SchoonerSockIO {
        public static short REQUESTID = 0;
        public static final short SEQENCE = 0;
        public static final short TOTAL = 1;
        public static final short RESERVED = 0;
        private static final Object LOCK = new Object();
        private static ConcurrentMap<String, byte[]> data = new ConcurrentHashMap<String, byte[]>();
        public static ConcurrentMap<Short, UDPDataItem> dataStore = new ConcurrentHashMap<Short, UDPDataItem>();
        public DatagramChannel channel;
        private Selector selector;

        @Override
        public void trueClose() throws IOException {
            if (this.selector != null) {
                this.selector.close();
                this.channel.close();
            }
        }

        public UDPSockIO(GenericObjectPool<SchoonerSockIO> sockets, String host, int bufferSize, int timeout) throws IOException, UnknownHostException {
            super(sockets, bufferSize);
            String[] ip = host.split(":");
            this.channel = DatagramChannel.open();
            this.channel.configureBlocking(false);
            InetSocketAddress address = new InetSocketAddress(ip[0], Integer.parseInt(ip[1]));
            this.channel.connect(address);
            this.channel.socket().setSoTimeout(timeout);
            this.selector = Selector.open();
            this.channel.register(this.selector, 1);
            this.writeBuf = ByteBuffer.allocateDirect(bufferSize);
        }

        @Override
        public ByteChannel getByteChannel() {
            return this.channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short preWrite() {
            this.writeBuf.clear();
            short rid = 0;
            Object object = LOCK;
            synchronized (object) {
                rid = REQUESTID = (short)(REQUESTID + 1);
            }
            this.writeBuf.putShort(rid);
            this.writeBuf.putShort((short)0);
            this.writeBuf.putShort((short)1);
            this.writeBuf.putShort((short)0);
            return rid;
        }

        @Override
        public byte[] getResponse(short rid) throws IOException {
            int n;
            long timeout;
            long timeRemaining = timeout = 1000L;
            int length = 0;
            byte[] ret = null;
            UDPDataItem mItem = new UDPDataItem(this);
            dataStore.put(rid, mItem);
            long startTime = System.currentTimeMillis();
            while (timeRemaining > 0L && !mItem.isFinished() && (n = this.selector.select(500L)) > 0) {
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                block1: while (it.hasNext()) {
                    SelectionKey skey = it.next();
                    it.remove();
                    if (!skey.isReadable()) continue;
                    DatagramChannel sc = (DatagramChannel)skey.channel();
                    while (true) {
                        this.readBuf.clear();
                        sc.read(this.readBuf);
                        length = this.readBuf.position();
                        if (length <= 8) continue block1;
                        this.readBuf.flip();
                        short requestID = this.readBuf.getShort();
                        UDPDataItem item = (UDPDataItem)dataStore.get(requestID);
                        if (item == null || item.isFinished) continue;
                        item.addLength(length - 8);
                        short sequence = this.readBuf.getShort();
                        item.setTotal(this.readBuf.getShort());
                        this.readBuf.getShort();
                        byte[] tmp = new byte[length - 8];
                        this.readBuf.get(tmp);
                        item.incrCounter();
                        data.put(requestID + "_" + sequence, tmp);
                        if (item.getCounter() != item.getTotal()) continue;
                        item.setFinished(true);
                    }
                }
                timeRemaining = timeout - (System.currentTimeMillis() - startTime);
            }
            if (!mItem.isFinished) {
                dataStore.remove(rid);
                for (short sq = 0; sq < mItem.getTotal(); sq = (short)(sq + 1)) {
                    data.remove(rid + "_" + sq);
                }
                return null;
            }
            int counter = mItem.getLength();
            ret = new byte[counter];
            counter = 0;
            boolean isOk = true;
            for (short sq = 0; sq < mItem.getTotal(); sq = (short)(sq + 1)) {
                byte[] src = (byte[])data.remove(rid + "_" + sq);
                if (src == null) {
                    isOk = false;
                }
                if (!isOk) continue;
                System.arraycopy(src, 0, ret, counter, src.length);
                counter += src.length;
            }
            dataStore.remove(rid);
            if (!isOk) {
                return null;
            }
            return ret;
        }

        @Override
        public void close() {
            this.readBuf.clear();
            this.writeBuf.clear();
            try {
                this.sockets.returnObject(this);
            }
            catch (Exception e) {
                LOG.error("++++ error closing socket: " + this.toString() + " for host: " + this.getHost());
            }
        }

        @Override
        public String getHost() {
            return this.channel.socket().getInetAddress().getHostName();
        }

        @Override
        public void clearEOL() throws IOException {
        }

        @Override
        public int read(byte[] b) {
            return 0;
        }

        @Override
        public String readLine() throws IOException {
            return null;
        }

        @Override
        public void trueClose(boolean addToDeadPool) throws IOException {
        }

        @Override
        public SocketChannel getChannel() {
            return null;
        }

        private class UDPDataItem {
            private short counter = 0;
            private boolean isFinished = false;
            private int length = 0;
            private short total;

            private UDPDataItem(UDPSockIO uDPSockIO) {
            }

            public synchronized short getTotal() {
                return this.total;
            }

            public synchronized void setTotal(short total) {
                if (this.total == 0) {
                    this.total = total;
                }
            }

            public synchronized short getCounter() {
                return this.counter;
            }

            public synchronized short incrCounter() {
                this.counter = (short)(this.counter + 1);
                return this.counter;
            }

            public synchronized boolean isFinished() {
                return this.isFinished;
            }

            public synchronized void setFinished(boolean isFinished) {
                this.isFinished = isFinished;
            }

            public synchronized int getLength() {
                return this.length;
            }

            public synchronized void addLength(int alength) {
                this.length += alength;
            }
        }
    }
}

