/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.SchoonerSockIO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public final class SockInputStream
extends InputStream {
    private SchoonerSockIO sock;
    private int limit;
    private int count = 0;
    private byte b;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();

    public final int getWillRead() {
        return this.limit;
    }

    public final void willRead(int limit) {
        this.limit = limit;
        this.count = 0;
    }

    public SockInputStream(SchoonerSockIO sock, int limit) throws IOException {
        this.sock = sock;
        this.willRead(limit);
        sock.readBuf.clear();
        sock.getChannel().read(sock.readBuf);
        sock.readBuf.flip();
    }

    public SockInputStream(SchoonerSockIO sock) throws IOException {
        this(sock, sock.readBuf.remaining());
    }

    @Override
    public final int read() throws IOException {
        if (this.count >= this.limit) {
            return -1;
        }
        this.b = 0;
        try {
            this.b = this.sock.readBuf.get();
        }
        catch (BufferUnderflowException e) {
            this.readFromChannel();
            this.b = this.sock.readBuf.get();
        }
        ++this.count;
        return this.b & 0xFF;
    }

    private final void readFromChannel() throws IOException {
        this.sock.readBuf.clear();
        ReadableByteChannel wrappedChannel = Channels.newChannel(this.sock.getChannel().socket().getInputStream());
        wrappedChannel.read(this.sock.readBuf);
        this.sock.readBuf.flip();
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        if (this.count >= this.limit) {
            return -1;
        }
        int read = 0;
        int r1 = 0;
        int remain = this.limit - this.count;
        int n = len = len < remain ? len : remain;
        while (len - read > 0) {
            r1 = this.sock.readBuf.remaining();
            r1 = r1 < len - read ? r1 : len - read;
            this.sock.readBuf.get(b, off + read, r1);
            if (r1 != len - read) {
                this.readFromChannel();
            }
            read += r1;
        }
        this.count += len;
        return len;
    }

    public final byte[] getBuffer() throws IOException {
        byte[] bs = new byte[this.limit - this.count];
        this.read(bs);
        return bs;
    }

    public final String getLine() throws IOException {
        int b;
        this.bos.reset();
        while ((b = this.read()) != -1) {
            this.bos.write(b);
            if (b != 10) continue;
        }
        return new String(this.bos.toByteArray());
    }

    @Override
    public int available() throws IOException {
        return this.sock.readBuf.remaining();
    }
}

