/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.SchoonerSockIO;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;

public final class SockOutputStream
extends OutputStream {
    private int count = 0;
    private SchoonerSockIO sock;

    public final int getCount() {
        return this.count;
    }

    public final void resetCount() {
        this.count = 0;
    }

    public final SchoonerSockIO getSock() {
        return this.sock;
    }

    public SockOutputStream(SchoonerSockIO sock) {
        this.sock = sock;
    }

    private final void writeToChannel() throws IOException {
        this.sock.writeBuf.flip();
        this.sock.getChannel().write(this.sock.writeBuf);
        this.sock.writeBuf.clear();
    }

    @Override
    public final void write(int b) throws IOException {
        try {
            this.sock.writeBuf.put((byte)b);
        }
        catch (BufferOverflowException e) {
            this.writeToChannel();
            this.sock.writeBuf.put((byte)b);
        }
        ++this.count;
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.sock.writeBuf.remaining() >= len) {
            this.sock.writeBuf.put(b, off, len);
        } else {
            int written = 0;
            int w1 = 0;
            int tRemain = 0;
            while ((tRemain = len - written) > 0) {
                w1 = this.sock.writeBuf.remaining();
                int n = w1 = w1 < tRemain ? w1 : tRemain;
                if (w1 == 0) {
                    this.writeToChannel();
                } else {
                    this.sock.writeBuf.put(b, off, w1);
                }
                written += w1;
            }
        }
        this.count += len;
    }
}

