/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached.command;

import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.command.Command;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeletionCommand
extends Command {
    private static final Logger LOG = LogManager.getLogger(DeletionCommand.class);
    private static final byte[] DELETED = "DELETED\r\n".getBytes();
    private static final byte[] NOTFOUND = "NOT_FOUND\r\n".getBytes();

    public DeletionCommand(String key, Integer hashCode, Date expiry) {
        StringBuilder command = new StringBuilder("delete").append(" ").append(key);
        if (expiry != null) {
            command.append(" " + expiry.getTime() / 1000L);
        }
        command.append("\r\n");
        this.textLine = command.toString().getBytes();
    }

    public boolean response(SchoonerSockIO sock, short rid) throws IOException {
        byte[] res = sock.getResponse(rid);
        if (Arrays.equals(res, DELETED)) {
            LOG.debug("DELETED!");
            return true;
        }
        if (Arrays.equals(res, NOTFOUND)) {
            LOG.debug("NOT_FOUND!");
        } else {
            LOG.error("error");
        }
        return false;
    }
}

