/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached.command;

import com.schooner.MemCached.MemcachedItem;
import com.schooner.MemCached.NativeHandler;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.TransCoder;
import com.schooner.MemCached.command.Command;
import com.schooner.MemCached.command.DeletionCommand;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RetrievalCommand
extends Command {
    private static final Logger LOG = LogManager.getLogger(DeletionCommand.class);
    private static final byte[] B_END = "END\r\n".getBytes();
    private static final byte[] B_VALUE = "VALUE ".getBytes();
    private String key;
    private String cmd;

    public RetrievalCommand(String cmd, String key) {
        this.key = key;
        this.cmd = cmd;
        StringBuilder command = new StringBuilder(cmd).append(" ").append(key).append("\r\n");
        this.textLine = command.toString().getBytes();
    }

    public MemcachedItem response(SchoonerSockIO sock, TransCoder transCoder, short rid) throws IOException {
        byte[] res = sock.getResponse(rid);
        MemcachedItem item = new MemcachedItem();
        if (res == null) {
            return item;
        }
        ResponseParser parser = new ResponseParser();
        parser.exec(res);
        if (parser.retvalue != null) {
            Value value = parser.retvalue;
            if (this.cmd.equals("gets")) {
                item.casUnique = value.casUnique;
            }
            try {
                if (NativeHandler.isHandled(value.flags)) {
                    item.value = NativeHandler.decode(value.dataBlock, value.flags);
                } else if (transCoder != null) {
                    item.value = transCoder.decode(new ByteArrayInputStream(value.dataBlock));
                }
            }
            catch (IOException e) {
                LOG.error("error happend in decoding the object");
                throw e;
            }
            return item;
        }
        return item;
    }

    public class ResponseParser {
        public Value retvalue = null;

        public void exec(byte[] res) throws IOException {
            byte next;
            ByteArrayInputStream stream = new ByteArrayInputStream(res);
            StringBuilder sb = new StringBuilder();
            byte[] end = new byte[5];
            int length = 0;
            stream.mark(0);
            stream.read(end);
            if (Arrays.equals(end, B_END)) {
                return;
            }
            stream.reset();
            Value value = new Value(RetrievalCommand.this);
            stream.skip(B_VALUE.length + RetrievalCommand.this.key.length() + 1);
            length = 0;
            while ((next = (byte)stream.read()) != 32) {
                ++length;
                sb.append((char)next);
            }
            try {
                value.flags = Integer.valueOf(sb.toString());
            }
            catch (NumberFormatException e) {
                this.retvalue = null;
                return;
            }
            sb.delete(0, length);
            length = 0;
            while ((next = (byte)stream.read()) != 32 && next != 13) {
                ++length;
                sb.append((char)next);
            }
            try {
                value.bytes = Integer.valueOf(sb.toString());
            }
            catch (NumberFormatException e) {
                this.retvalue = null;
                return;
            }
            sb.delete(0, length);
            if (RetrievalCommand.this.cmd.equals("gets")) {
                length = 0;
                while ((next = (byte)stream.read()) != 13) {
                    ++length;
                    sb.append((char)next);
                }
                try {
                    value.casUnique = Long.valueOf(sb.toString());
                }
                catch (NumberFormatException e) {
                    this.retvalue = null;
                    return;
                }
                sb.delete(0, length);
            }
            stream.skip(1L);
            value.dataBlock = new byte[value.bytes];
            stream.read(value.dataBlock);
            stream.skip(2L);
            stream.mark(0);
            stream.read(end);
            if (Arrays.equals(end, B_END)) {
                this.retvalue = value;
            }
        }
    }

    public class Value {
        public int flags;
        public int bytes;
        public long casUnique;
        public byte[] dataBlock;

        public Value(RetrievalCommand this$0) {
        }
    }
}

