/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached.command;

import com.schooner.MemCached.NativeHandler;
import com.schooner.MemCached.ObjectTransCoder;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.SockOutputStream;
import com.schooner.MemCached.TransCoder;
import com.schooner.MemCached.command.Command;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class StorageCommand
extends Command {
    public static final byte[] STORED = "STORED\r\n".getBytes();
    public static final byte[] NOT_STORED = "NOT_STORED\r\n".getBytes();
    public final byte[] BLAND_DATA_SIZE = "       ".getBytes();
    public static final byte[] B_RETURN = "\r\n".getBytes();
    private int flags;
    private TransCoder transCoder = new ObjectTransCoder();
    private Object value;
    private int valLen = 0;
    private int offset;
    private Long casUnique;

    public StorageCommand(String cmdname, String key, Object value, Date expiry, Integer hashCode, Long casUnique) {
        this.init(cmdname, key, value, expiry, hashCode, casUnique);
    }

    public StorageCommand(String cmdname, String key, Object value, Date expiry, Integer hashCode, Long casUnique, TransCoder transCoder) {
        this.init(cmdname, key, value, expiry, hashCode, casUnique);
        this.transCoder = transCoder;
    }

    private void init(String cmdname, String key, Object value, Date expiry, Integer hashCode, Long casUnique) {
        this.flags = NativeHandler.getMarkerFlag(value);
        String cmd = new StringBuffer().append(cmdname).append(" ").append(key).append(" ").append(this.flags).append(" ").append(expiry.getTime() / 1000L).append(" ").toString();
        this.textLine = cmd.getBytes();
        this.value = value;
        this.casUnique = casUnique;
    }

    private boolean writeDataBlock(SchoonerSockIO sock) throws IOException {
        SockOutputStream output = new SockOutputStream(sock);
        if (this.flags != 0) {
            byte[] b = NativeHandler.encode(this.value);
            output.write(b);
            this.valLen = b.length;
        } else {
            this.valLen = this.transCoder.encode(output, this.value);
        }
        sock.writeBuf.put(B_RETURN);
        byte[] objectSize = Integer.valueOf(this.valLen).toString().getBytes();
        int oldPosition = sock.writeBuf.position();
        sock.writeBuf.position(this.offset);
        sock.writeBuf.put(objectSize);
        sock.writeBuf.position(oldPosition);
        return true;
    }

    @Override
    public short request(SchoonerSockIO sock) throws IOException {
        short rid = sock.preWrite();
        sock.writeBuf.put(this.textLine);
        this.offset = sock.writeBuf.position();
        sock.writeBuf.put(this.BLAND_DATA_SIZE);
        if (this.casUnique != 0L) {
            sock.writeBuf.put((" " + this.casUnique.toString()).getBytes());
        }
        sock.writeBuf.put(B_RETURN);
        if (this.value != null) {
            this.writeDataBlock(sock);
        }
        sock.writeBuf.flip();
        sock.getByteChannel().write(sock.writeBuf);
        return rid;
    }

    public boolean response(SchoonerSockIO sock, short rid) throws IOException {
        byte[] temp = sock.getResponse(rid);
        return Arrays.equals(STORED, temp);
    }
}

