/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached.command;

import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.command.Command;
import com.schooner.MemCached.command.DeletionCommand;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncCommand
extends Command {
    private static final Logger LOG = LogManager.getLogger(DeletionCommand.class);
    public static final String SYNCED = "SYNCED\r\n";
    public static final String NOTFOUND = "NOT_FOUND\r\n";
    private String key;

    public SyncCommand(String key, Integer hashCode) {
        StringBuilder command = new StringBuilder("sync ").append(key);
        command.append("\r\n");
        this.textLine = command.toString().getBytes();
        this.key = key;
    }

    public boolean response(SchoonerSockIO sock, short rid) throws IOException {
        byte[] temp = sock.getResponse(rid);
        String line = new String(temp);
        if (SYNCED.equals(line)) {
            LOG.info(new StringBuffer().append("++++ sync of key: ").append(this.key).append(" from cache was a success").toString());
            return true;
        }
        if (NOTFOUND.equals(line)) {
            LOG.info(new StringBuffer().append("++++ sync of key: ").append(this.key).append(" from cache failed as the key was not found").toString());
        } else {
            LOG.error(new StringBuffer().append("++++ error sync key: ").append(this.key).toString());
            LOG.error(new StringBuffer().append("++++ server response: ").append(line).toString());
        }
        return false;
    }
}

