/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.memcache.map;

import com.weicoder.common.lang.W;
import com.weicoder.common.util.U;
import com.weicoder.memcache.Memcache;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MemcacheMap<K, V>
implements Map<K, V> {
    private String name;
    private Memcache memcache;

    public MemcacheMap(String name, Memcache memcache) {
        this.name = name;
        this.memcache = memcache;
    }

    @Override
    public int size() {
        return W.C.toInt((Object)this.memcache.get(this.getKeySize()));
    }

    @Override
    public boolean isEmpty() {
        return !this.memcache.exists(this.getKey());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.memcache.exists(this.getKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public V get(Object key) {
        return (V)this.memcache.get(this.getKey(key));
    }

    @Override
    public V put(K key, V value) {
        V v = this.get(key);
        String k = this.getKey(key);
        if (!this.memcache.exists(k) && this.memcache.set(k, value)) {
            k = this.getKey();
            if (!this.memcache.append(k, "," + String.valueOf(key))) {
                this.memcache.set(k, W.C.toString(key));
            }
            this.memcache.set(this.getKeySize(), this.size() + 1);
        }
        return v;
    }

    @Override
    public V remove(Object key) {
        V e = this.get(key);
        this.memcache.remove(this.getKey((Serializable)key));
        this.memcache.set(this.getKeySize(), this.size() - 1);
        List keys = W.L.list((Object[])this.getKeys());
        keys.remove(key);
        this.memcache.set(this.getKey(), W.L.toString((List)keys));
        return e;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        for (String key : this.getKeys()) {
            this.memcache.remove(key);
        }
        this.memcache.remove(this.getKeySize());
        this.memcache.remove(this.getKey());
    }

    @Override
    public Set<K> keySet() {
        return W.S.set((Object[])this.getKeys());
    }

    @Override
    public Collection<V> values() {
        return W.L.list((Object[])this.memcache.get(this.getKeys()));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map().entrySet();
    }

    public Map<K, V> map() {
        String[] keys = this.getKeys();
        Object[] values = this.memcache.get(this.getKey(keys));
        Map map = W.M.map();
        for (int i = 0; i < keys.length; ++i) {
            if (values[i] == null) continue;
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public String toString() {
        return this.map().toString();
    }

    private String getKey() {
        return this.getKey((Object)"key");
    }

    private String getKeySize() {
        return this.getKey((Object)"size");
    }

    private String getKey(Object key) {
        return W.C.toString((Object)key).startsWith(this.name) ? W.C.toString((Object)key) : this.name + "_" + String.valueOf(key);
    }

    private String[] getKey(String ... key) {
        String[] keys = new String[key.length];
        for (int i = 0; i < key.length; ++i) {
            keys[i] = this.getKey((Object)key[i]);
        }
        return keys;
    }

    private String[] getKeys() {
        return U.S.split((String)W.C.toString((Object)this.memcache.get(this.getKey())), (String)",");
    }
}

