/*
 * Decompiled with CFR 0.152.
 */
package com.whalin.MemCached;

import com.schooner.MemCached.AscIIClient;
import com.schooner.MemCached.AscIIUDPClient;
import com.schooner.MemCached.BinaryClient;
import com.schooner.MemCached.MemcachedItem;
import com.schooner.MemCached.TransCoder;
import com.schooner.MemCached.command.DeletionCommand;
import com.whalin.MemCached.ErrorHandler;
import java.util.Date;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MemCachedClient {
    private static final Logger LOG = LogManager.getLogger(DeletionCommand.class);
    MemCachedClient client;
    protected ClassLoader classLoader;
    protected ErrorHandler errorHandler;
    public static final String VALUE = "VALUE";
    public static final String STATS = "STAT";
    public static final String ITEM = "ITEM";
    public static final String DELETED = "DELETED\r\n";
    public static final String SYNCED = "SYNCED\r\n";
    public static final String NOTFOUND = "NOT_FOUND\r\n";
    public static final String STORED = "STORED\r\n";
    public static final String OK = "OK\r\n";
    public static final String END = "END\r\n";
    public static final String ERROR = "ERROR\r\n";
    public static final String CLIENT_ERROR = "CLIENT_ERROR\r\n";
    public static final int COMPRESS_THRESH = 30720;
    public static final String SERVER_ERROR = "SERVER_ERROR\r\n";
    public static final byte[] B_RETURN = "\r\n".getBytes();
    public static final byte[] B_END = "END\r\n".getBytes();
    public static final byte[] B_NOTFOUND = "NOT_FOUND\r\n".getBytes();
    public static final byte[] B_DELETED = "DELETED\r\r".getBytes();
    public static final byte[] B_STORED = "STORED\r\r".getBytes();
    public static final byte MAGIC_REQ = -128;
    public static final byte MAGIC_RESP = -127;
    public static final int F_COMPRESSED = 2;
    public static final int F_SERIALIZED = 8;
    public static final int STAT_NO_ERROR = 0;
    public static final int STAT_KEY_NOT_FOUND = 1;
    public static final int STAT_KEY_EXISTS = 2;
    public static final int STAT_VALUE_TOO_BIG = 3;
    public static final int STAT_INVALID_ARGUMENTS = 4;
    public static final int STAT_ITEM_NOT_STORED = 5;
    public static final int STAT_UNKNOWN_COMMAND = 129;
    public static final int STAT_OUT_OF_MEMORY = 130;
    public static final byte OPCODE_GET = 0;
    public static final byte OPCODE_SET = 1;
    public static final byte OPCODE_ADD = 2;
    public static final byte OPCODE_REPLACE = 3;
    public static final byte OPCODE_DELETE = 4;
    public static final byte OPCODE_INCREMENT = 5;
    public static final byte OPCODE_DECREMENT = 6;
    public static final byte OPCODE_QUIT = 7;
    public static final byte OPCODE_FLUSH = 8;
    public static final byte OPCODE_GETQ = 9;
    public static final byte OPCODE_NOOP = 10;
    public static final byte OPCODE_VERSION = 11;
    public static final byte OPCODE_GETK = 12;
    public static final byte OPCODE_GETKQ = 13;
    public static final byte OPCODE_APPEND = 14;
    public static final byte OPCODE_PREPEND = 15;
    public static final byte OPCODE_STAT = 16;
    public static final byte OPCODE_AUTH_LIST = 32;
    public static final byte OPCODE_START_AUTH = 33;
    public static final byte OPCODE_AUTH_STEPS = 34;
    public static final byte AUTH_FAILED = 32;
    public static final byte FURTHER_AUTH = 33;
    public final byte[] BLAND_DATA_SIZE = "       ".getBytes();
    public static final int MARKER_BYTE = 1;
    public static final int MARKER_BOOLEAN = 8192;
    public static final int MARKER_INTEGER = 4;
    public static final int MARKER_LONG = 16384;
    public static final int MARKER_CHARACTER = 16;
    public static final int MARKER_STRING = 32;
    public static final int MARKER_STRINGBUFFER = 64;
    public static final int MARKER_FLOAT = 128;
    public static final int MARKER_SHORT = 256;
    public static final int MARKER_DOUBLE = 512;
    public static final int MARKER_DATE = 1024;
    public static final int MARKER_STRINGBUILDER = 2048;
    public static final int MARKER_BYTEARR = 4096;
    public static final int MARKER_OTHERS = 0;

    public boolean isUseBinaryProtocol() {
        return this.client.isUseBinaryProtocol();
    }

    protected MemCachedClient(MemCachedClient client) {
        this.client = client;
    }

    public MemCachedClient() {
        this(null, true, false);
    }

    public MemCachedClient(boolean binaryProtocal) {
        this(null, true, binaryProtocal);
    }

    public MemCachedClient(String poolName) {
        this(poolName, true, false);
    }

    public MemCachedClient(String poolName, boolean binaryProtocal) {
        this(poolName, true, binaryProtocal);
    }

    public MemCachedClient(boolean isTCP, boolean binaryProtocal) {
        this(null, isTCP, binaryProtocal);
    }

    public MemCachedClient(String poolName, boolean isTcp, boolean binaryProtocal) {
        this.client = binaryProtocal ? new BinaryClient(poolName) : (isTcp ? new AscIIClient(poolName) : new AscIIUDPClient(poolName));
    }

    public MemCachedClient(String poolName, boolean isTcp, boolean binaryProtocol, ClassLoader cl, ErrorHandler eh) {
        this.client = binaryProtocol ? new BinaryClient(poolName, cl, eh) : (isTcp ? new AscIIClient(poolName, cl, eh) : new AscIIUDPClient(poolName, cl, eh));
    }

    public MemCachedClient(ClassLoader classLoader) {
        this();
        this.client.setClassLoader(classLoader);
    }

    public MemCachedClient(ClassLoader classLoader, ErrorHandler errorHandler) {
        this(null, true, false, classLoader, errorHandler);
    }

    public MemCachedClient(ClassLoader classLoader, ErrorHandler errorHandler, String poolName) {
        this(poolName, true, false, classLoader, errorHandler);
    }

    public void setClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        throw new UnsupportedOperationException();
    }

    public void setCompressEnable(boolean compressEnable) {
        throw new UnsupportedOperationException();
    }

    public void setCompressThreshold(long compressThreshold) {
        throw new UnsupportedOperationException();
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.client.setDefaultEncoding(defaultEncoding);
    }

    public void setPrimitiveAsString(boolean primitiveAsString) {
        this.client.setPrimitiveAsString(primitiveAsString);
    }

    public void setSanitizeKeys(boolean sanitizeKeys) {
        this.client.setSanitizeKeys(sanitizeKeys);
    }

    public boolean keyExists(String key) {
        return this.client.keyExists(key);
    }

    public boolean delete(String key) {
        return this.client.delete(key);
    }

    public boolean delete(String key, Date expiry) {
        return this.client.delete(key, expiry);
    }

    public boolean delete(String key, Integer hashCode, Date expiry) {
        return this.client.delete(key, hashCode, expiry);
    }

    public boolean set(String key, Object value) {
        return this.client.set(key, value);
    }

    public boolean set(String key, Object value, Integer hashCode) {
        return this.client.set(key, value, hashCode);
    }

    public boolean set(String key, Object value, Date expiry) {
        return this.client.set(key, value, expiry);
    }

    public boolean set(String key, Object value, Date expiry, Integer hashCode) {
        return this.client.set(key, value, expiry, hashCode);
    }

    public boolean add(String key, Object value) {
        return this.client.add(key, value);
    }

    public boolean add(String key, Object value, Integer hashCode) {
        return this.client.add(key, value, hashCode);
    }

    public boolean add(String key, Object value, Date expiry) {
        return this.client.add(key, value, expiry);
    }

    public boolean add(String key, Object value, Date expiry, Integer hashCode) {
        return this.client.add(key, value, expiry, hashCode);
    }

    public boolean replace(String key, Object value) {
        return this.client.replace(key, value);
    }

    public boolean replace(String key, Object value, Integer hashCode) {
        return this.client.replace(key, value, hashCode);
    }

    public boolean replace(String key, Object value, Date expiry) {
        return this.client.replace(key, value, expiry);
    }

    public boolean replace(String key, Object value, Date expiry, Integer hashCode) {
        return this.client.replace(key, value, expiry, hashCode);
    }

    public boolean storeCounter(String key, Long counter) {
        return this.storeCounter(key, counter, null, null);
    }

    public boolean storeCounter(String key, Long counter, Date date) {
        return this.storeCounter(key, counter, date, null);
    }

    public boolean storeCounter(String key, Long counter, Date date, Integer hashCode) {
        return this.set(key, counter, date, hashCode);
    }

    public boolean storeCounter(String key, Long counter, Integer hashCode) {
        return this.storeCounter(key, counter, null, hashCode);
    }

    public long getCounter(String key) {
        return this.getCounter(key, null);
    }

    public long getCounter(String key, Integer hashCode) {
        if (key == null) {
            LOG.error("null key for getCounter()");
            return -1L;
        }
        long counter = -1L;
        try {
            counter = Long.parseLong((String)this.get(key, hashCode, true));
        }
        catch (Exception ex) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet(this, (Throwable)ex, key);
            }
            LOG.info(String.format("Failed to parse Long value for key: %s", key));
        }
        return counter;
    }

    public long addOrIncr(String key) {
        return this.client.addOrIncr(key);
    }

    public long addOrIncr(String key, long inc) {
        return this.client.addOrIncr(key, inc);
    }

    public long addOrIncr(String key, long inc, Integer hashCode) {
        return this.client.addOrIncr(key, inc, hashCode);
    }

    public long addOrDecr(String key) {
        return this.client.addOrDecr(key);
    }

    public long addOrDecr(String key, long inc) {
        return this.client.addOrDecr(key, inc);
    }

    public long addOrDecr(String key, long inc, Integer hashCode) {
        return this.client.addOrDecr(key, inc, hashCode);
    }

    public long incr(String key) {
        return this.client.incr(key);
    }

    public long incr(String key, long inc) {
        return this.client.incr(key, inc);
    }

    public long incr(String key, long inc, Integer hashCode) {
        return this.client.incr(key, inc, hashCode);
    }

    public long decr(String key) {
        return this.client.decr(key);
    }

    public long decr(String key, long inc) {
        return this.client.decr(key, inc);
    }

    public long decr(String key, long inc, Integer hashCode) {
        return this.client.decr(key, inc, hashCode);
    }

    public Object get(String key) {
        return this.client.get(key);
    }

    public Object get(String key, Integer hashCode) {
        return this.client.get(key, hashCode);
    }

    public MemcachedItem gets(String key) {
        return this.client.gets(key);
    }

    public MemcachedItem gets(String key, Integer hashCode) {
        return this.client.gets(key, hashCode);
    }

    public void setTransCoder(TransCoder transCoder) {
        this.client.setTransCoder(transCoder);
    }

    public Object get(String key, Integer hashCode, boolean asString) {
        return this.client.get(key, hashCode, asString);
    }

    public Object[] getMultiArray(String[] keys) {
        return this.client.getMultiArray(keys);
    }

    public Object[] getMultiArray(String[] keys, Integer[] hashCodes) {
        return this.client.getMultiArray(keys, hashCodes);
    }

    public Object[] getMultiArray(String[] keys, Integer[] hashCodes, boolean asString) {
        return this.client.getMultiArray(keys, hashCodes, asString);
    }

    public Map<String, Object> getMulti(String[] keys) {
        return this.getMulti(keys, null);
    }

    public Map<String, Object> getMulti(String[] keys, Integer[] hashCodes) {
        return this.client.getMulti(keys, hashCodes);
    }

    public Map<String, Object> getMulti(String[] keys, Integer[] hashCodes, boolean asString) {
        return this.client.getMulti(keys, hashCodes, asString);
    }

    public boolean flushAll() {
        return this.client.flushAll();
    }

    public boolean flushAll(String[] servers) {
        return this.client.flushAll(servers);
    }

    public Map<String, Map<String, String>> stats() {
        return this.client.stats();
    }

    public Map<String, Map<String, String>> stats(String[] servers) {
        return this.client.stats(servers);
    }

    public Map<String, Map<String, String>> statsItems() {
        return this.client.statsItems();
    }

    public Map<String, Map<String, String>> statsItems(String[] servers) {
        return this.client.statsItems(servers);
    }

    public Map<String, Map<String, String>> statsSlabs() {
        return this.client.statsSlabs();
    }

    public Map<String, Map<String, String>> statsSlabs(String[] servers) {
        return this.client.statsSlabs(servers);
    }

    public Map<String, Map<String, String>> statsCacheDump(int slabNumber, int limit) {
        return this.client.statsCacheDump(slabNumber, limit);
    }

    public Map<String, Map<String, String>> statsCacheDump(String[] servers, int slabNumber, int limit) {
        return this.client.statsCacheDump(servers, slabNumber, limit);
    }

    public boolean sync(String key, Integer hashCode) {
        return this.client.sync(key, hashCode);
    }

    public boolean sync(String key) {
        return this.client.sync(key);
    }

    public boolean syncAll() {
        return this.client.syncAll();
    }

    public boolean syncAll(String[] servers) {
        return this.client.syncAll(servers);
    }

    public boolean append(String key, Object value, Integer hashCode) {
        return this.client.append(key, value, hashCode);
    }

    public boolean append(String key, Object value) {
        return this.client.append(key, value);
    }

    public boolean cas(String key, Object value, Integer hashCode, long casUnique) {
        return this.client.cas(key, value, hashCode, casUnique);
    }

    public boolean cas(String key, Object value, Date expiry, long casUnique) {
        return this.client.cas(key, value, expiry, casUnique);
    }

    public boolean cas(String key, Object value, Date expiry, Integer hashCode, long casUnique) {
        return this.client.cas(key, value, expiry, hashCode, casUnique);
    }

    public boolean cas(String key, Object value, long casUnique) {
        return this.client.cas(key, value, casUnique);
    }

    public boolean prepend(String key, Object value, Integer hashCode) {
        return this.client.prepend(key, value, hashCode);
    }

    public boolean prepend(String key, Object value) {
        return this.client.prepend(key, value);
    }
}

